
import OpenGL.GL as gl

import glitch

class Material(glitch.Node):
    def __init__(self, r=0, g=0, b=0, a=1, **kw):
        glitch.Node.__init__(self, **kw)
        (self.r, self.g, self.b, self.a) = (r, g, b, a)

    def render(self, ctx):
        gl.glPushAttrib(gl.GL_LIGHTING_BIT)
        glitch.Node.render(self, ctx)
        gl.glPopAttrib()

    def draw(self, ctx):
        gl.glMaterialfv(
            gl.GL_FRONT_AND_BACK, gl.GL_AMBIENT_AND_DIFFUSE,
            (self.r, self.g, self.b, self.a))

