/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(viterbi.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(3dddfa88ff00d9ca651bb0b942244465)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/trellis/viterbi.h>
// pydoc.h is automatically generated in the build directory
#include <viterbi_pydoc.h>

template <typename T>
void bind_viterbi_template(py::module& m, const char* classname)
{
    using viterbi = gr::trellis::viterbi<T>;

    py::class_<viterbi, gr::block, gr::basic_block, std::shared_ptr<viterbi>>(m,
                                                                              classname)
        .def(py::init(&gr::trellis::viterbi<T>::make),
             py::arg("FSM"),
             py::arg("K"),
             py::arg("S0"),
             py::arg("SK"))
        .def("FSM", &viterbi::FSM)
        .def("K", &viterbi::K)
        .def("S0", &viterbi::S0)
        .def("SK", &viterbi::SK)
        .def("set_FSM", &viterbi::set_FSM)
        .def("set_K", &viterbi::set_K)
        .def("set_S0", &viterbi::set_S0)
        .def("set_SK", &viterbi::set_SK);
}

void bind_viterbi(py::module& m)
{
    bind_viterbi_template<std::uint8_t>(m, "viterbi_b");
    bind_viterbi_template<std::int16_t>(m, "viterbi_s");
    bind_viterbi_template<std::int32_t>(m, "viterbi_i");
}
