// DO NOT EDIT
// generated by pyang using OpenConfig https://github.com/openconfig/public
//
// Copyright (C) 2014-2025 Nippon Telegraph and Telephone Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
// implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by pyang. DO NOT EDIT.

package oc

import (
	"fmt"

	"github.com/osrg/gobgp/v3/pkg/packet/bgp"
)

func mapkey(index int, name string) string {
	if name != "" {
		return name
	}
	return fmt.Sprintf("%v", index)
}

// typedef for identity rpol:default-policy-type.
// type used to specify default route disposition in
// a policy chain.
type DefaultPolicyType string

const (
	DEFAULT_POLICY_TYPE_ACCEPT_ROUTE DefaultPolicyType = "accept-route"
	DEFAULT_POLICY_TYPE_REJECT_ROUTE DefaultPolicyType = "reject-route"
)

var DefaultPolicyTypeToIntMap = map[DefaultPolicyType]int{
	DEFAULT_POLICY_TYPE_ACCEPT_ROUTE: 0,
	DEFAULT_POLICY_TYPE_REJECT_ROUTE: 1,
}

var IntToDefaultPolicyTypeMap = map[int]DefaultPolicyType{
	0: DEFAULT_POLICY_TYPE_ACCEPT_ROUTE,
	1: DEFAULT_POLICY_TYPE_REJECT_ROUTE,
}

func (v DefaultPolicyType) Validate() error {
	if _, ok := DefaultPolicyTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid DefaultPolicyType: %s", v)
	}
	return nil
}

func (v DefaultPolicyType) ToInt() int {
	i, ok := DefaultPolicyTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity rpol:route-type.
// Condition to check the route type in the route update.
type RouteType string

const (
	ROUTE_TYPE_NONE     RouteType = "none"
	ROUTE_TYPE_INTERNAL RouteType = "internal"
	ROUTE_TYPE_EXTERNAL RouteType = "external"
	ROUTE_TYPE_LOCAL    RouteType = "local"
)

var RouteTypeToIntMap = map[RouteType]int{
	ROUTE_TYPE_NONE:     0,
	ROUTE_TYPE_INTERNAL: 1,
	ROUTE_TYPE_EXTERNAL: 2,
	ROUTE_TYPE_LOCAL:    3,
}

var IntToRouteTypeMap = map[int]RouteType{
	0: ROUTE_TYPE_NONE,
	1: ROUTE_TYPE_INTERNAL,
	2: ROUTE_TYPE_EXTERNAL,
	3: ROUTE_TYPE_LOCAL,
}

func (v RouteType) Validate() error {
	if _, ok := RouteTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid RouteType: %s", v)
	}
	return nil
}

func (v RouteType) ToInt() int {
	i, ok := RouteTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity rpol:route-disposition.
// Select the final disposition for the route, either
// accept or reject.
type RouteDisposition string

const (
	ROUTE_DISPOSITION_NONE         RouteDisposition = "none"
	ROUTE_DISPOSITION_ACCEPT_ROUTE RouteDisposition = "accept-route"
	ROUTE_DISPOSITION_REJECT_ROUTE RouteDisposition = "reject-route"
)

var RouteDispositionToIntMap = map[RouteDisposition]int{
	ROUTE_DISPOSITION_NONE:         0,
	ROUTE_DISPOSITION_ACCEPT_ROUTE: 1,
	ROUTE_DISPOSITION_REJECT_ROUTE: 2,
}

var IntToRouteDispositionMap = map[int]RouteDisposition{
	0: ROUTE_DISPOSITION_NONE,
	1: ROUTE_DISPOSITION_ACCEPT_ROUTE,
	2: ROUTE_DISPOSITION_REJECT_ROUTE,
}

func (v RouteDisposition) Validate() error {
	if _, ok := RouteDispositionToIntMap[v]; !ok {
		return fmt.Errorf("invalid RouteDisposition: %s", v)
	}
	return nil
}

func (v RouteDisposition) ToInt() int {
	i, ok := RouteDispositionToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity ptypes:match-set-options-type.
// Options that govern the behavior of a match statement.  The
// default behavior is ANY, i.e., the given value matches any
// of the members of the defined set.
type MatchSetOptionsType string

const (
	MATCH_SET_OPTIONS_TYPE_ANY    MatchSetOptionsType = "any"
	MATCH_SET_OPTIONS_TYPE_ALL    MatchSetOptionsType = "all"
	MATCH_SET_OPTIONS_TYPE_INVERT MatchSetOptionsType = "invert"
)

var MatchSetOptionsTypeToIntMap = map[MatchSetOptionsType]int{
	MATCH_SET_OPTIONS_TYPE_ANY:    0,
	MATCH_SET_OPTIONS_TYPE_ALL:    1,
	MATCH_SET_OPTIONS_TYPE_INVERT: 2,
}

var IntToMatchSetOptionsTypeMap = map[int]MatchSetOptionsType{
	0: MATCH_SET_OPTIONS_TYPE_ANY,
	1: MATCH_SET_OPTIONS_TYPE_ALL,
	2: MATCH_SET_OPTIONS_TYPE_INVERT,
}

func (v MatchSetOptionsType) Validate() error {
	if _, ok := MatchSetOptionsTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid MatchSetOptionsType: %s", v)
	}
	return nil
}

func (v MatchSetOptionsType) Default() MatchSetOptionsType {
	return MATCH_SET_OPTIONS_TYPE_ANY
}

func (v MatchSetOptionsType) DefaultAsNeeded() MatchSetOptionsType {
	if string(v) == "" {
		return v.Default()
	}
	return v
}
func (v MatchSetOptionsType) ToInt() int {
	_v := v.DefaultAsNeeded()
	i, ok := MatchSetOptionsTypeToIntMap[_v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity ptypes:match-set-options-restricted-type.
// Options that govern the behavior of a match statement.  The
// default behavior is ANY, i.e., the given value matches any
// of the members of the defined set.  Note this type is a
// restricted version of the match-set-options-type.
type MatchSetOptionsRestrictedType string

const (
	MATCH_SET_OPTIONS_RESTRICTED_TYPE_ANY    MatchSetOptionsRestrictedType = "any"
	MATCH_SET_OPTIONS_RESTRICTED_TYPE_INVERT MatchSetOptionsRestrictedType = "invert"
)

var MatchSetOptionsRestrictedTypeToIntMap = map[MatchSetOptionsRestrictedType]int{
	MATCH_SET_OPTIONS_RESTRICTED_TYPE_ANY:    0,
	MATCH_SET_OPTIONS_RESTRICTED_TYPE_INVERT: 1,
}

var IntToMatchSetOptionsRestrictedTypeMap = map[int]MatchSetOptionsRestrictedType{
	0: MATCH_SET_OPTIONS_RESTRICTED_TYPE_ANY,
	1: MATCH_SET_OPTIONS_RESTRICTED_TYPE_INVERT,
}

func (v MatchSetOptionsRestrictedType) Validate() error {
	if _, ok := MatchSetOptionsRestrictedTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid MatchSetOptionsRestrictedType: %s", v)
	}
	return nil
}

func (v MatchSetOptionsRestrictedType) Default() MatchSetOptionsRestrictedType {
	return MATCH_SET_OPTIONS_RESTRICTED_TYPE_ANY
}

func (v MatchSetOptionsRestrictedType) DefaultAsNeeded() MatchSetOptionsRestrictedType {
	if string(v) == "" {
		return v.Default()
	}
	return v
}
func (v MatchSetOptionsRestrictedType) ToInt() int {
	_v := v.DefaultAsNeeded()
	i, ok := MatchSetOptionsRestrictedTypeToIntMap[_v]
	if !ok {
		return -1
	}
	return i
}

// typedef for typedef ptypes:tag-type.
type TagType string

// typedef for identity ptypes:attribute-comparison.
// base type for supported comparison operators on route
// attributes.
type AttributeComparison string

const (
	ATTRIBUTE_COMPARISON_ATTRIBUTE_EQ AttributeComparison = "attribute-eq"
	ATTRIBUTE_COMPARISON_ATTRIBUTE_GE AttributeComparison = "attribute-ge"
	ATTRIBUTE_COMPARISON_ATTRIBUTE_LE AttributeComparison = "attribute-le"
	ATTRIBUTE_COMPARISON_EQ           AttributeComparison = "eq"
	ATTRIBUTE_COMPARISON_GE           AttributeComparison = "ge"
	ATTRIBUTE_COMPARISON_LE           AttributeComparison = "le"
)

var AttributeComparisonToIntMap = map[AttributeComparison]int{
	ATTRIBUTE_COMPARISON_ATTRIBUTE_EQ: 0,
	ATTRIBUTE_COMPARISON_ATTRIBUTE_GE: 1,
	ATTRIBUTE_COMPARISON_ATTRIBUTE_LE: 2,
	ATTRIBUTE_COMPARISON_EQ:           3,
	ATTRIBUTE_COMPARISON_GE:           4,
	ATTRIBUTE_COMPARISON_LE:           5,
}

var IntToAttributeComparisonMap = map[int]AttributeComparison{
	0: ATTRIBUTE_COMPARISON_ATTRIBUTE_EQ,
	1: ATTRIBUTE_COMPARISON_ATTRIBUTE_GE,
	2: ATTRIBUTE_COMPARISON_ATTRIBUTE_LE,
	3: ATTRIBUTE_COMPARISON_EQ,
	4: ATTRIBUTE_COMPARISON_GE,
	5: ATTRIBUTE_COMPARISON_LE,
}

func (v AttributeComparison) Validate() error {
	if _, ok := AttributeComparisonToIntMap[v]; !ok {
		return fmt.Errorf("invalid AttributeComparison: %s", v)
	}
	return nil
}

func (v AttributeComparison) ToInt() int {
	i, ok := AttributeComparisonToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity ptypes:install-protocol-type.
// Base type for protocols which can install prefixes into the
// RIB.
type InstallProtocolType string

const (
	INSTALL_PROTOCOL_TYPE_BGP                InstallProtocolType = "bgp"
	INSTALL_PROTOCOL_TYPE_ISIS               InstallProtocolType = "isis"
	INSTALL_PROTOCOL_TYPE_OSPF               InstallProtocolType = "ospf"
	INSTALL_PROTOCOL_TYPE_OSPF3              InstallProtocolType = "ospf3"
	INSTALL_PROTOCOL_TYPE_STATIC             InstallProtocolType = "static"
	INSTALL_PROTOCOL_TYPE_DIRECTLY_CONNECTED InstallProtocolType = "directly-connected"
	INSTALL_PROTOCOL_TYPE_LOCAL_AGGREGATE    InstallProtocolType = "local-aggregate"
)

var InstallProtocolTypeToIntMap = map[InstallProtocolType]int{
	INSTALL_PROTOCOL_TYPE_BGP:                0,
	INSTALL_PROTOCOL_TYPE_ISIS:               1,
	INSTALL_PROTOCOL_TYPE_OSPF:               2,
	INSTALL_PROTOCOL_TYPE_OSPF3:              3,
	INSTALL_PROTOCOL_TYPE_STATIC:             4,
	INSTALL_PROTOCOL_TYPE_DIRECTLY_CONNECTED: 5,
	INSTALL_PROTOCOL_TYPE_LOCAL_AGGREGATE:    6,
}

var IntToInstallProtocolTypeMap = map[int]InstallProtocolType{
	0: INSTALL_PROTOCOL_TYPE_BGP,
	1: INSTALL_PROTOCOL_TYPE_ISIS,
	2: INSTALL_PROTOCOL_TYPE_OSPF,
	3: INSTALL_PROTOCOL_TYPE_OSPF3,
	4: INSTALL_PROTOCOL_TYPE_STATIC,
	5: INSTALL_PROTOCOL_TYPE_DIRECTLY_CONNECTED,
	6: INSTALL_PROTOCOL_TYPE_LOCAL_AGGREGATE,
}

func (v InstallProtocolType) Validate() error {
	if _, ok := InstallProtocolTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid InstallProtocolType: %s", v)
	}
	return nil
}

func (v InstallProtocolType) ToInt() int {
	i, ok := InstallProtocolTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity bgp:session-state.
// Operational state of the BGP peer.
type SessionState string

const (
	SESSION_STATE_IDLE        SessionState = "idle"
	SESSION_STATE_CONNECT     SessionState = "connect"
	SESSION_STATE_ACTIVE      SessionState = "active"
	SESSION_STATE_OPENSENT    SessionState = "opensent"
	SESSION_STATE_OPENCONFIRM SessionState = "openconfirm"
	SESSION_STATE_ESTABLISHED SessionState = "established"
)

var SessionStateToIntMap = map[SessionState]int{
	SESSION_STATE_IDLE:        0,
	SESSION_STATE_CONNECT:     1,
	SESSION_STATE_ACTIVE:      2,
	SESSION_STATE_OPENSENT:    3,
	SESSION_STATE_OPENCONFIRM: 4,
	SESSION_STATE_ESTABLISHED: 5,
}

var IntToSessionStateMap = map[int]SessionState{
	0: SESSION_STATE_IDLE,
	1: SESSION_STATE_CONNECT,
	2: SESSION_STATE_ACTIVE,
	3: SESSION_STATE_OPENSENT,
	4: SESSION_STATE_OPENCONFIRM,
	5: SESSION_STATE_ESTABLISHED,
}

func (v SessionState) Validate() error {
	if _, ok := SessionStateToIntMap[v]; !ok {
		return fmt.Errorf("invalid SessionState: %s", v)
	}
	return nil
}

func (v SessionState) ToInt() int {
	i, ok := SessionStateToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity bgp:admin-state.
type AdminState string

const (
	ADMIN_STATE_UP     AdminState = "up"
	ADMIN_STATE_DOWN   AdminState = "down"
	ADMIN_STATE_PFX_CT AdminState = "pfx_ct"
)

var AdminStateToIntMap = map[AdminState]int{
	ADMIN_STATE_UP:     0,
	ADMIN_STATE_DOWN:   1,
	ADMIN_STATE_PFX_CT: 2,
}

var IntToAdminStateMap = map[int]AdminState{
	0: ADMIN_STATE_UP,
	1: ADMIN_STATE_DOWN,
	2: ADMIN_STATE_PFX_CT,
}

func (v AdminState) Validate() error {
	if _, ok := AdminStateToIntMap[v]; !ok {
		return fmt.Errorf("invalid AdminState: %s", v)
	}
	return nil
}

func (v AdminState) ToInt() int {
	i, ok := AdminStateToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity bgp:mode.
// Ths leaf indicates the mode of operation of BGP graceful
// restart with the peer.
type Mode string

const (
	MODE_HELPER_ONLY   Mode = "helper-only"
	MODE_BILATERAL     Mode = "bilateral"
	MODE_REMOTE_HELPER Mode = "remote-helper"
)

var ModeToIntMap = map[Mode]int{
	MODE_HELPER_ONLY:   0,
	MODE_BILATERAL:     1,
	MODE_REMOTE_HELPER: 2,
}

var IntToModeMap = map[int]Mode{
	0: MODE_HELPER_ONLY,
	1: MODE_BILATERAL,
	2: MODE_REMOTE_HELPER,
}

func (v Mode) Validate() error {
	if _, ok := ModeToIntMap[v]; !ok {
		return fmt.Errorf("invalid Mode: %s", v)
	}
	return nil
}

func (v Mode) ToInt() int {
	i, ok := ModeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity bgp-types:bgp-session-direction.
// Type to describe the direction of NLRI transmission.
type BgpSessionDirection string

const (
	BGP_SESSION_DIRECTION_INBOUND  BgpSessionDirection = "inbound"
	BGP_SESSION_DIRECTION_OUTBOUND BgpSessionDirection = "outbound"
)

var BgpSessionDirectionToIntMap = map[BgpSessionDirection]int{
	BGP_SESSION_DIRECTION_INBOUND:  0,
	BGP_SESSION_DIRECTION_OUTBOUND: 1,
}

var IntToBgpSessionDirectionMap = map[int]BgpSessionDirection{
	0: BGP_SESSION_DIRECTION_INBOUND,
	1: BGP_SESSION_DIRECTION_OUTBOUND,
}

func (v BgpSessionDirection) Validate() error {
	if _, ok := BgpSessionDirectionToIntMap[v]; !ok {
		return fmt.Errorf("invalid BgpSessionDirection: %s", v)
	}
	return nil
}

func (v BgpSessionDirection) ToInt() int {
	i, ok := BgpSessionDirectionToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for typedef bgp-types:bgp-std-community-type.
type BgpStdCommunityType string

// typedef for typedef bgp-types:bgp-ext-community-type.
type BgpExtCommunityType string

// typedef for typedef bgp-types:bgp-community-regexp-type.
type BgpCommunityRegexpType StdRegexp

// typedef for identity bgp-types:bgp-origin-attr-type.
// Type definition for standard BGP origin attribute.
type BgpOriginAttrType string

const (
	BGP_ORIGIN_ATTR_TYPE_IGP        BgpOriginAttrType = "igp"
	BGP_ORIGIN_ATTR_TYPE_EGP        BgpOriginAttrType = "egp"
	BGP_ORIGIN_ATTR_TYPE_INCOMPLETE BgpOriginAttrType = "incomplete"
)

var BgpOriginAttrTypeToIntMap = map[BgpOriginAttrType]int{
	BGP_ORIGIN_ATTR_TYPE_IGP:        0,
	BGP_ORIGIN_ATTR_TYPE_EGP:        1,
	BGP_ORIGIN_ATTR_TYPE_INCOMPLETE: 2,
}

var IntToBgpOriginAttrTypeMap = map[int]BgpOriginAttrType{
	0: BGP_ORIGIN_ATTR_TYPE_IGP,
	1: BGP_ORIGIN_ATTR_TYPE_EGP,
	2: BGP_ORIGIN_ATTR_TYPE_INCOMPLETE,
}

func (v BgpOriginAttrType) Validate() error {
	if _, ok := BgpOriginAttrTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid BgpOriginAttrType: %s", v)
	}
	return nil
}

func (v BgpOriginAttrType) ToInt() int {
	i, ok := BgpOriginAttrTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity bgp-types:peer-type.
// labels a peer or peer group as explicitly internal or
// external.
type PeerType string

const (
	PEER_TYPE_INTERNAL PeerType = "internal"
	PEER_TYPE_EXTERNAL PeerType = "external"
)

var PeerTypeToIntMap = map[PeerType]int{
	PEER_TYPE_INTERNAL: 0,
	PEER_TYPE_EXTERNAL: 1,
}

var IntToPeerTypeMap = map[int]PeerType{
	0: PEER_TYPE_INTERNAL,
	1: PEER_TYPE_EXTERNAL,
}

func (v PeerType) Validate() error {
	if _, ok := PeerTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid PeerType: %s", v)
	}
	return nil
}

func (v PeerType) ToInt() int {
	i, ok := PeerTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity bgp-types:remove-private-as-option.
// set of options for configuring how private AS path numbers
// are removed from advertisements.
type RemovePrivateAsOption string

const (
	REMOVE_PRIVATE_AS_OPTION_ALL     RemovePrivateAsOption = "all"
	REMOVE_PRIVATE_AS_OPTION_REPLACE RemovePrivateAsOption = "replace"
)

var RemovePrivateAsOptionToIntMap = map[RemovePrivateAsOption]int{
	REMOVE_PRIVATE_AS_OPTION_ALL:     0,
	REMOVE_PRIVATE_AS_OPTION_REPLACE: 1,
}

var IntToRemovePrivateAsOptionMap = map[int]RemovePrivateAsOption{
	0: REMOVE_PRIVATE_AS_OPTION_ALL,
	1: REMOVE_PRIVATE_AS_OPTION_REPLACE,
}

func (v RemovePrivateAsOption) Validate() error {
	if _, ok := RemovePrivateAsOptionToIntMap[v]; !ok {
		return fmt.Errorf("invalid RemovePrivateAsOption: %s", v)
	}
	return nil
}

func (v RemovePrivateAsOption) ToInt() int {
	i, ok := RemovePrivateAsOptionToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for typedef bgp-types:percentage.
type Percentage uint8

// typedef for typedef bgp-types:rr-cluster-id-type.
type RrClusterIdType string

// typedef for identity bgp-types:community-type.
// type describing variations of community attributes:
// STANDARD: standard BGP community [rfc1997]
// EXTENDED: extended BGP community [rfc4360]
// BOTH: both standard and extended community.
type CommunityType string

const (
	COMMUNITY_TYPE_STANDARD CommunityType = "standard"
	COMMUNITY_TYPE_EXTENDED CommunityType = "extended"
	COMMUNITY_TYPE_BOTH     CommunityType = "both"
	COMMUNITY_TYPE_NONE     CommunityType = "none"
)

var CommunityTypeToIntMap = map[CommunityType]int{
	COMMUNITY_TYPE_STANDARD: 0,
	COMMUNITY_TYPE_EXTENDED: 1,
	COMMUNITY_TYPE_BOTH:     2,
	COMMUNITY_TYPE_NONE:     3,
}

var IntToCommunityTypeMap = map[int]CommunityType{
	0: COMMUNITY_TYPE_STANDARD,
	1: COMMUNITY_TYPE_EXTENDED,
	2: COMMUNITY_TYPE_BOTH,
	3: COMMUNITY_TYPE_NONE,
}

func (v CommunityType) Validate() error {
	if _, ok := CommunityTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid CommunityType: %s", v)
	}
	return nil
}

func (v CommunityType) ToInt() int {
	i, ok := CommunityTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity bgp-types:bgp-capability.
// Base identity for a BGP capability.
type BgpCapability string

const (
	BGP_CAPABILITY_MPBGP            BgpCapability = "mpbgp"
	BGP_CAPABILITY_ROUTE_REFRESH    BgpCapability = "route-refresh"
	BGP_CAPABILITY_ASN32            BgpCapability = "asn32"
	BGP_CAPABILITY_GRACEFUL_RESTART BgpCapability = "graceful-restart"
	BGP_CAPABILITY_ADD_PATHS        BgpCapability = "add-paths"
)

var BgpCapabilityToIntMap = map[BgpCapability]int{
	BGP_CAPABILITY_MPBGP:            0,
	BGP_CAPABILITY_ROUTE_REFRESH:    1,
	BGP_CAPABILITY_ASN32:            2,
	BGP_CAPABILITY_GRACEFUL_RESTART: 3,
	BGP_CAPABILITY_ADD_PATHS:        4,
}

var IntToBgpCapabilityMap = map[int]BgpCapability{
	0: BGP_CAPABILITY_MPBGP,
	1: BGP_CAPABILITY_ROUTE_REFRESH,
	2: BGP_CAPABILITY_ASN32,
	3: BGP_CAPABILITY_GRACEFUL_RESTART,
	4: BGP_CAPABILITY_ADD_PATHS,
}

func (v BgpCapability) Validate() error {
	if _, ok := BgpCapabilityToIntMap[v]; !ok {
		return fmt.Errorf("invalid BgpCapability: %s", v)
	}
	return nil
}

func (v BgpCapability) ToInt() int {
	i, ok := BgpCapabilityToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity bgp-types:afi-safi-type.
// Base identity type for AFI,SAFI tuples for BGP-4.
type AfiSafiType string

const (
	AFI_SAFI_TYPE_IPV4_UNICAST          AfiSafiType = "ipv4-unicast"
	AFI_SAFI_TYPE_IPV6_UNICAST          AfiSafiType = "ipv6-unicast"
	AFI_SAFI_TYPE_IPV4_LABELLED_UNICAST AfiSafiType = "ipv4-labelled-unicast"
	AFI_SAFI_TYPE_IPV6_LABELLED_UNICAST AfiSafiType = "ipv6-labelled-unicast"
	AFI_SAFI_TYPE_L3VPN_IPV4_UNICAST    AfiSafiType = "l3vpn-ipv4-unicast"
	AFI_SAFI_TYPE_L3VPN_IPV6_UNICAST    AfiSafiType = "l3vpn-ipv6-unicast"
	AFI_SAFI_TYPE_L3VPN_IPV4_MULTICAST  AfiSafiType = "l3vpn-ipv4-multicast"
	AFI_SAFI_TYPE_L3VPN_IPV6_MULTICAST  AfiSafiType = "l3vpn-ipv6-multicast"
	AFI_SAFI_TYPE_L2VPN_VPLS            AfiSafiType = "l2vpn-vpls"
	AFI_SAFI_TYPE_L2VPN_EVPN            AfiSafiType = "l2vpn-evpn"
	AFI_SAFI_TYPE_IPV4_MULTICAST        AfiSafiType = "ipv4-multicast"
	AFI_SAFI_TYPE_IPV6_MULTICAST        AfiSafiType = "ipv6-multicast"
	AFI_SAFI_TYPE_RTC                   AfiSafiType = "rtc"
	AFI_SAFI_TYPE_IPV4_ENCAP            AfiSafiType = "ipv4-encap"
	AFI_SAFI_TYPE_IPV6_ENCAP            AfiSafiType = "ipv6-encap"
	AFI_SAFI_TYPE_IPV4_FLOWSPEC         AfiSafiType = "ipv4-flowspec"
	AFI_SAFI_TYPE_L3VPN_IPV4_FLOWSPEC   AfiSafiType = "l3vpn-ipv4-flowspec"
	AFI_SAFI_TYPE_IPV6_FLOWSPEC         AfiSafiType = "ipv6-flowspec"
	AFI_SAFI_TYPE_L3VPN_IPV6_FLOWSPEC   AfiSafiType = "l3vpn-ipv6-flowspec"
	AFI_SAFI_TYPE_L2VPN_FLOWSPEC        AfiSafiType = "l2vpn-flowspec"
	AFI_SAFI_TYPE_IPV4_SRPOLICY         AfiSafiType = "ipv4-srpolicy"
	AFI_SAFI_TYPE_IPV6_SRPOLICY         AfiSafiType = "ipv6-srpolicy"
	AFI_SAFI_TYPE_OPAQUE                AfiSafiType = "opaque"
	AFI_SAFI_TYPE_LS                    AfiSafiType = "ls"
	AFI_SAFI_TYPE_IPV4_MUP              AfiSafiType = "ipv4-mup"
	AFI_SAFI_TYPE_IPV6_MUP              AfiSafiType = "ipv6-mup"
)

var AfiSafiTypeToIntMap = map[AfiSafiType]int{
	AFI_SAFI_TYPE_IPV4_UNICAST:          0,
	AFI_SAFI_TYPE_IPV6_UNICAST:          1,
	AFI_SAFI_TYPE_IPV4_LABELLED_UNICAST: 2,
	AFI_SAFI_TYPE_IPV6_LABELLED_UNICAST: 3,
	AFI_SAFI_TYPE_L3VPN_IPV4_UNICAST:    4,
	AFI_SAFI_TYPE_L3VPN_IPV6_UNICAST:    5,
	AFI_SAFI_TYPE_L3VPN_IPV4_MULTICAST:  6,
	AFI_SAFI_TYPE_L3VPN_IPV6_MULTICAST:  7,
	AFI_SAFI_TYPE_L2VPN_VPLS:            8,
	AFI_SAFI_TYPE_L2VPN_EVPN:            9,
	AFI_SAFI_TYPE_IPV4_MULTICAST:        10,
	AFI_SAFI_TYPE_IPV6_MULTICAST:        11,
	AFI_SAFI_TYPE_RTC:                   12,
	AFI_SAFI_TYPE_IPV4_ENCAP:            13,
	AFI_SAFI_TYPE_IPV6_ENCAP:            14,
	AFI_SAFI_TYPE_IPV4_FLOWSPEC:         15,
	AFI_SAFI_TYPE_L3VPN_IPV4_FLOWSPEC:   16,
	AFI_SAFI_TYPE_IPV6_FLOWSPEC:         17,
	AFI_SAFI_TYPE_L3VPN_IPV6_FLOWSPEC:   18,
	AFI_SAFI_TYPE_L2VPN_FLOWSPEC:        19,
	AFI_SAFI_TYPE_IPV4_SRPOLICY:         20,
	AFI_SAFI_TYPE_IPV6_SRPOLICY:         21,
	AFI_SAFI_TYPE_OPAQUE:                22,
	AFI_SAFI_TYPE_LS:                    23,
	AFI_SAFI_TYPE_IPV4_MUP:              24,
	AFI_SAFI_TYPE_IPV6_MUP:              25,
}

var IntToAfiSafiTypeMap = map[int]AfiSafiType{
	0:  AFI_SAFI_TYPE_IPV4_UNICAST,
	1:  AFI_SAFI_TYPE_IPV6_UNICAST,
	2:  AFI_SAFI_TYPE_IPV4_LABELLED_UNICAST,
	3:  AFI_SAFI_TYPE_IPV6_LABELLED_UNICAST,
	4:  AFI_SAFI_TYPE_L3VPN_IPV4_UNICAST,
	5:  AFI_SAFI_TYPE_L3VPN_IPV6_UNICAST,
	6:  AFI_SAFI_TYPE_L3VPN_IPV4_MULTICAST,
	7:  AFI_SAFI_TYPE_L3VPN_IPV6_MULTICAST,
	8:  AFI_SAFI_TYPE_L2VPN_VPLS,
	9:  AFI_SAFI_TYPE_L2VPN_EVPN,
	10: AFI_SAFI_TYPE_IPV4_MULTICAST,
	11: AFI_SAFI_TYPE_IPV6_MULTICAST,
	12: AFI_SAFI_TYPE_RTC,
	13: AFI_SAFI_TYPE_IPV4_ENCAP,
	14: AFI_SAFI_TYPE_IPV6_ENCAP,
	15: AFI_SAFI_TYPE_IPV4_FLOWSPEC,
	16: AFI_SAFI_TYPE_L3VPN_IPV4_FLOWSPEC,
	17: AFI_SAFI_TYPE_IPV6_FLOWSPEC,
	18: AFI_SAFI_TYPE_L3VPN_IPV6_FLOWSPEC,
	19: AFI_SAFI_TYPE_L2VPN_FLOWSPEC,
	20: AFI_SAFI_TYPE_IPV4_SRPOLICY,
	21: AFI_SAFI_TYPE_IPV6_SRPOLICY,
	22: AFI_SAFI_TYPE_OPAQUE,
	23: AFI_SAFI_TYPE_LS,
	24: AFI_SAFI_TYPE_IPV4_MUP,
	25: AFI_SAFI_TYPE_IPV6_MUP,
}

func (v AfiSafiType) Validate() error {
	if _, ok := AfiSafiTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid AfiSafiType: %s", v)
	}
	return nil
}

func (v AfiSafiType) ToInt() int {
	i, ok := AfiSafiTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity bgp-types:bgp-well-known-std-community.
// Reserved communities within the standard community space
// defined by RFC1997. These communities must fall within the
// range 0x00000000 to 0xFFFFFFFF.
type BgpWellKnownStdCommunity string

const (
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT           BgpWellKnownStdCommunity = "no_export"
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_ADVERTISE        BgpWellKnownStdCommunity = "no_advertise"
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT_SUBCONFED BgpWellKnownStdCommunity = "no_export_subconfed"
	BGP_WELL_KNOWN_STD_COMMUNITY_NOPEER              BgpWellKnownStdCommunity = "nopeer"
)

var BgpWellKnownStdCommunityToIntMap = map[BgpWellKnownStdCommunity]int{
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT:           0,
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_ADVERTISE:        1,
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT_SUBCONFED: 2,
	BGP_WELL_KNOWN_STD_COMMUNITY_NOPEER:              3,
}

var IntToBgpWellKnownStdCommunityMap = map[int]BgpWellKnownStdCommunity{
	0: BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT,
	1: BGP_WELL_KNOWN_STD_COMMUNITY_NO_ADVERTISE,
	2: BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT_SUBCONFED,
	3: BGP_WELL_KNOWN_STD_COMMUNITY_NOPEER,
}

func (v BgpWellKnownStdCommunity) Validate() error {
	if _, ok := BgpWellKnownStdCommunityToIntMap[v]; !ok {
		return fmt.Errorf("invalid BgpWellKnownStdCommunity: %s", v)
	}
	return nil
}

func (v BgpWellKnownStdCommunity) ToInt() int {
	i, ok := BgpWellKnownStdCommunityToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for typedef openconfig-types:std-regexp.
type StdRegexp string

// typedef for identity gobgp:bmp-route-monitoring-policy-type.
type BmpRouteMonitoringPolicyType string

const (
	BMP_ROUTE_MONITORING_POLICY_TYPE_PRE_POLICY  BmpRouteMonitoringPolicyType = "pre-policy"
	BMP_ROUTE_MONITORING_POLICY_TYPE_POST_POLICY BmpRouteMonitoringPolicyType = "post-policy"
	BMP_ROUTE_MONITORING_POLICY_TYPE_BOTH        BmpRouteMonitoringPolicyType = "both"
	BMP_ROUTE_MONITORING_POLICY_TYPE_LOCAL_RIB   BmpRouteMonitoringPolicyType = "local-rib"
	BMP_ROUTE_MONITORING_POLICY_TYPE_ALL         BmpRouteMonitoringPolicyType = "all"
)

var BmpRouteMonitoringPolicyTypeToIntMap = map[BmpRouteMonitoringPolicyType]int{
	BMP_ROUTE_MONITORING_POLICY_TYPE_PRE_POLICY:  0,
	BMP_ROUTE_MONITORING_POLICY_TYPE_POST_POLICY: 1,
	BMP_ROUTE_MONITORING_POLICY_TYPE_BOTH:        2,
	BMP_ROUTE_MONITORING_POLICY_TYPE_LOCAL_RIB:   3,
	BMP_ROUTE_MONITORING_POLICY_TYPE_ALL:         4,
}

var IntToBmpRouteMonitoringPolicyTypeMap = map[int]BmpRouteMonitoringPolicyType{
	0: BMP_ROUTE_MONITORING_POLICY_TYPE_PRE_POLICY,
	1: BMP_ROUTE_MONITORING_POLICY_TYPE_POST_POLICY,
	2: BMP_ROUTE_MONITORING_POLICY_TYPE_BOTH,
	3: BMP_ROUTE_MONITORING_POLICY_TYPE_LOCAL_RIB,
	4: BMP_ROUTE_MONITORING_POLICY_TYPE_ALL,
}

func (v BmpRouteMonitoringPolicyType) Validate() error {
	if _, ok := BmpRouteMonitoringPolicyTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid BmpRouteMonitoringPolicyType: %s", v)
	}
	return nil
}

func (v BmpRouteMonitoringPolicyType) ToInt() int {
	i, ok := BmpRouteMonitoringPolicyTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity gobgp:rpki-validation-result-type.
// indicate the validation result of RPKI based on ROA.
type RpkiValidationResultType string

const (
	RPKI_VALIDATION_RESULT_TYPE_NONE      RpkiValidationResultType = "none"
	RPKI_VALIDATION_RESULT_TYPE_NOT_FOUND RpkiValidationResultType = "not-found"
	RPKI_VALIDATION_RESULT_TYPE_VALID     RpkiValidationResultType = "valid"
	RPKI_VALIDATION_RESULT_TYPE_INVALID   RpkiValidationResultType = "invalid"
)

var RpkiValidationResultTypeToIntMap = map[RpkiValidationResultType]int{
	RPKI_VALIDATION_RESULT_TYPE_NONE:      0,
	RPKI_VALIDATION_RESULT_TYPE_NOT_FOUND: 1,
	RPKI_VALIDATION_RESULT_TYPE_VALID:     2,
	RPKI_VALIDATION_RESULT_TYPE_INVALID:   3,
}

var IntToRpkiValidationResultTypeMap = map[int]RpkiValidationResultType{
	0: RPKI_VALIDATION_RESULT_TYPE_NONE,
	1: RPKI_VALIDATION_RESULT_TYPE_NOT_FOUND,
	2: RPKI_VALIDATION_RESULT_TYPE_VALID,
	3: RPKI_VALIDATION_RESULT_TYPE_INVALID,
}

func (v RpkiValidationResultType) Validate() error {
	if _, ok := RpkiValidationResultTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid RpkiValidationResultType: %s", v)
	}
	return nil
}

func (v RpkiValidationResultType) ToInt() int {
	i, ok := RpkiValidationResultTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for identity gobgp:mrt-type.
type MrtType string

const (
	MRT_TYPE_UPDATES MrtType = "updates"
	MRT_TYPE_TABLE   MrtType = "table"
)

var MrtTypeToIntMap = map[MrtType]int{
	MRT_TYPE_UPDATES: 0,
	MRT_TYPE_TABLE:   1,
}

var IntToMrtTypeMap = map[int]MrtType{
	0: MRT_TYPE_UPDATES,
	1: MRT_TYPE_TABLE,
}

func (v MrtType) Validate() error {
	if _, ok := MrtTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid MrtType: %s", v)
	}
	return nil
}

func (v MrtType) ToInt() int {
	i, ok := MrtTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for typedef bgp-pol:bgp-as-path-prepend-repeat.
type BgpAsPathPrependRepeat uint8

// typedef for identity bgp-pol:bgp-set-community-option-type.
// Type definition for options when setting the community
// attribute in a policy action.
type BgpSetCommunityOptionType string

const (
	BGP_SET_COMMUNITY_OPTION_TYPE_ADD     BgpSetCommunityOptionType = "add"
	BGP_SET_COMMUNITY_OPTION_TYPE_REMOVE  BgpSetCommunityOptionType = "remove"
	BGP_SET_COMMUNITY_OPTION_TYPE_REPLACE BgpSetCommunityOptionType = "replace"
)

var BgpSetCommunityOptionTypeToIntMap = map[BgpSetCommunityOptionType]int{
	BGP_SET_COMMUNITY_OPTION_TYPE_ADD:     0,
	BGP_SET_COMMUNITY_OPTION_TYPE_REMOVE:  1,
	BGP_SET_COMMUNITY_OPTION_TYPE_REPLACE: 2,
}

var IntToBgpSetCommunityOptionTypeMap = map[int]BgpSetCommunityOptionType{
	0: BGP_SET_COMMUNITY_OPTION_TYPE_ADD,
	1: BGP_SET_COMMUNITY_OPTION_TYPE_REMOVE,
	2: BGP_SET_COMMUNITY_OPTION_TYPE_REPLACE,
}

func (v BgpSetCommunityOptionType) Validate() error {
	if _, ok := BgpSetCommunityOptionTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid BgpSetCommunityOptionType: %s", v)
	}
	return nil
}

func (v BgpSetCommunityOptionType) ToInt() int {
	i, ok := BgpSetCommunityOptionTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

// typedef for typedef bgp-pol:bgp-next-hop-type.
type BgpNextHopType string

// typedef for typedef bgp-pol:bgp-set-med-type.
type BgpSetMedType string

// struct for container gobgp:state.
type DynamicNeighborState struct {
	// original -> gobgp:prefix
	Prefix string `mapstructure:"prefix" json:"prefix,omitempty"`
	// original -> gobgp:peer-group
	PeerGroup string `mapstructure:"peer-group" json:"peer-group,omitempty"`
}

// struct for container gobgp:config.
type DynamicNeighborConfig struct {
	// original -> gobgp:prefix
	Prefix string `mapstructure:"prefix" json:"prefix,omitempty"`
	// original -> gobgp:peer-group
	PeerGroup string `mapstructure:"peer-group" json:"peer-group,omitempty"`
}

func (lhs *DynamicNeighborConfig) Equal(rhs *DynamicNeighborConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Prefix != rhs.Prefix {
		return false
	}
	if lhs.PeerGroup != rhs.PeerGroup {
		return false
	}
	return true
}

// struct for container gobgp:dynamic-neighbor.
type DynamicNeighbor struct {
	// original -> gobgp:prefix
	// original -> gobgp:dynamic-neighbor-config
	Config DynamicNeighborConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> gobgp:dynamic-neighbor-state
	State DynamicNeighborState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *DynamicNeighbor) Equal(rhs *DynamicNeighbor) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container gobgp:state.
type CollectorState struct {
	// original -> gobgp:url
	Url string `mapstructure:"url" json:"url,omitempty"`
	// original -> gobgp:db-name
	DbName string `mapstructure:"db-name" json:"db-name,omitempty"`
	// original -> gobgp:table-dump-interval
	TableDumpInterval uint64 `mapstructure:"table-dump-interval" json:"table-dump-interval,omitempty"`
}

// struct for container gobgp:config.
type CollectorConfig struct {
	// original -> gobgp:url
	Url string `mapstructure:"url" json:"url,omitempty"`
	// original -> gobgp:db-name
	DbName string `mapstructure:"db-name" json:"db-name,omitempty"`
	// original -> gobgp:table-dump-interval
	TableDumpInterval uint64 `mapstructure:"table-dump-interval" json:"table-dump-interval,omitempty"`
}

func (lhs *CollectorConfig) Equal(rhs *CollectorConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Url != rhs.Url {
		return false
	}
	if lhs.DbName != rhs.DbName {
		return false
	}
	if lhs.TableDumpInterval != rhs.TableDumpInterval {
		return false
	}
	return true
}

// struct for container gobgp:collector.
type Collector struct {
	// original -> gobgp:collector-config
	Config CollectorConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> gobgp:collector-state
	State CollectorState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *Collector) Equal(rhs *Collector) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container gobgp:state.
type ZebraState struct {
	// original -> gobgp:enabled
	// gobgp:enabled's original type is boolean.
	// Configure enabling to connect to zebra.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> gobgp:url
	// Configure url for zebra.
	Url string `mapstructure:"url" json:"url,omitempty"`
	// original -> gobgp:redistribute-route-type
	RedistributeRouteTypeList []string `mapstructure:"redistribute-route-type-list" json:"redistribute-route-type-list,omitempty"`
	// original -> gobgp:version
	// Configure version of zebra protocol.  Default is 2.
	// Supported version are 2 or 3 for Quagga and 4, 5 or 6 for FRRouting.
	Version uint8 `mapstructure:"version" json:"version,omitempty"`
	// original -> gobgp:nexthop-trigger-enable
	// gobgp:nexthop-trigger-enable's original type is boolean.
	NexthopTriggerEnable bool `mapstructure:"nexthop-trigger-enable" json:"nexthop-trigger-enable,omitempty"`
	// original -> gobgp:nexthop-trigger-delay
	NexthopTriggerDelay uint8 `mapstructure:"nexthop-trigger-delay" json:"nexthop-trigger-delay,omitempty"`
	// original -> gobgp:mpls-label-range-size
	// Configure MPLS label range size which will be requested to
	// FRR/Zebra.
	MplsLabelRangeSize uint32 `mapstructure:"mpls-label-range-size" json:"mpls-label-range-size,omitempty"`
	// original -> gobgp:software-name
	// Configure zebra software name.
	// frr4, cumulus, frr6, frr7, frr7.2, frr7.3, frr7.4, frr7.5, frr8, frr8.1 can be used.
	SoftwareName string `mapstructure:"software-name" json:"software-name,omitempty"`
}

// struct for container gobgp:config.
type ZebraConfig struct {
	// original -> gobgp:enabled
	// gobgp:enabled's original type is boolean.
	// Configure enabling to connect to zebra.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> gobgp:url
	// Configure url for zebra.
	Url string `mapstructure:"url" json:"url,omitempty"`
	// original -> gobgp:redistribute-route-type
	RedistributeRouteTypeList []string `mapstructure:"redistribute-route-type-list" json:"redistribute-route-type-list,omitempty"`
	// original -> gobgp:version
	// Configure version of zebra protocol.  Default is 2.
	// Supported version are 2 or 3 for Quagga and 4, 5 or 6 for FRRouting.
	Version uint8 `mapstructure:"version" json:"version,omitempty"`
	// original -> gobgp:nexthop-trigger-enable
	// gobgp:nexthop-trigger-enable's original type is boolean.
	NexthopTriggerEnable bool `mapstructure:"nexthop-trigger-enable" json:"nexthop-trigger-enable,omitempty"`
	// original -> gobgp:nexthop-trigger-delay
	NexthopTriggerDelay uint8 `mapstructure:"nexthop-trigger-delay" json:"nexthop-trigger-delay,omitempty"`
	// original -> gobgp:mpls-label-range-size
	// Configure MPLS label range size which will be requested to
	// FRR/Zebra.
	MplsLabelRangeSize uint32 `mapstructure:"mpls-label-range-size" json:"mpls-label-range-size,omitempty"`
	// original -> gobgp:software-name
	// Configure zebra software name.
	// frr4, cumulus, frr6, frr7, frr7.2, frr7.3, frr7.4, frr7.5, frr8, frr8.1 can be used.
	SoftwareName string `mapstructure:"software-name" json:"software-name,omitempty"`
}

func (lhs *ZebraConfig) Equal(rhs *ZebraConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.Url != rhs.Url {
		return false
	}
	if len(lhs.RedistributeRouteTypeList) != len(rhs.RedistributeRouteTypeList) {
		return false
	}
	for idx, l := range lhs.RedistributeRouteTypeList {
		if l != rhs.RedistributeRouteTypeList[idx] {
			return false
		}
	}
	if lhs.Version != rhs.Version {
		return false
	}
	if lhs.NexthopTriggerEnable != rhs.NexthopTriggerEnable {
		return false
	}
	if lhs.NexthopTriggerDelay != rhs.NexthopTriggerDelay {
		return false
	}
	if lhs.MplsLabelRangeSize != rhs.MplsLabelRangeSize {
		return false
	}
	if lhs.SoftwareName != rhs.SoftwareName {
		return false
	}
	return true
}

// struct for container gobgp:zebra.
type Zebra struct {
	// original -> gobgp:zebra-config
	Config ZebraConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> gobgp:zebra-state
	State ZebraState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *Zebra) Equal(rhs *Zebra) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container gobgp:config.
type MrtConfig struct {
	// original -> gobgp:dump-type
	DumpType MrtType `mapstructure:"dump-type" json:"dump-type,omitempty"`
	// original -> gobgp:file-name
	// Configures a file name to be written.
	FileName string `mapstructure:"file-name" json:"file-name,omitempty"`
	// original -> gobgp:table-name
	// specify the table name with route server setup.
	TableName string `mapstructure:"table-name" json:"table-name,omitempty"`
	// original -> gobgp:dump-interval
	DumpInterval uint64 `mapstructure:"dump-interval" json:"dump-interval,omitempty"`
	// original -> gobgp:rotation-interval
	RotationInterval uint64 `mapstructure:"rotation-interval" json:"rotation-interval,omitempty"`
}

func (lhs *MrtConfig) Equal(rhs *MrtConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.DumpType != rhs.DumpType {
		return false
	}
	if lhs.FileName != rhs.FileName {
		return false
	}
	if lhs.TableName != rhs.TableName {
		return false
	}
	if lhs.DumpInterval != rhs.DumpInterval {
		return false
	}
	if lhs.RotationInterval != rhs.RotationInterval {
		return false
	}
	return true
}

// struct for container gobgp:mrt.
type Mrt struct {
	// original -> gobgp:file-name
	// original -> gobgp:mrt-config
	Config MrtConfig `mapstructure:"config" json:"config,omitempty"`
}

func (lhs *Mrt) Equal(rhs *Mrt) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container gobgp:state.
// Configured states of VRF.
type VrfState struct {
	// original -> gobgp:name
	// Unique name among all VRF instances.
	Name string `mapstructure:"name" json:"name,omitempty"`
	// original -> gobgp:id
	// Unique identifier among all VRF instances.
	Id uint32 `mapstructure:"id" json:"id,omitempty"`
	// original -> gobgp:rd
	// Route Distinguisher for this VRF.
	Rd string `mapstructure:"rd" json:"rd,omitempty"`
	// original -> gobgp:import-rt
	// List of import Route Targets for this VRF.
	ImportRtList []string `mapstructure:"import-rt-list" json:"import-rt-list,omitempty"`
	// original -> gobgp:export-rt
	// List of export Route Targets for this VRF.
	ExportRtList []string `mapstructure:"export-rt-list" json:"export-rt-list,omitempty"`
}

// struct for container gobgp:config.
// Configuration parameters for VRF.
type VrfConfig struct {
	// original -> gobgp:name
	// Unique name among all VRF instances.
	Name string `mapstructure:"name" json:"name,omitempty"`
	// original -> gobgp:id
	// Unique identifier among all VRF instances.
	Id uint32 `mapstructure:"id" json:"id,omitempty"`
	// original -> gobgp:rd
	// Route Distinguisher for this VRF.
	Rd string `mapstructure:"rd" json:"rd,omitempty"`
	// original -> gobgp:import-rt
	// List of import Route Targets for this VRF.
	ImportRtList []string `mapstructure:"import-rt-list" json:"import-rt-list,omitempty"`
	// original -> gobgp:export-rt
	// List of export Route Targets for this VRF.
	ExportRtList []string `mapstructure:"export-rt-list" json:"export-rt-list,omitempty"`
	// original -> gobgp:both-rt
	// List of both import and export Route Targets for this VRF. Each
	// configuration for import and export Route Targets will be preferred.
	BothRtList []string `mapstructure:"both-rt-list" json:"both-rt-list,omitempty"`
}

func (lhs *VrfConfig) Equal(rhs *VrfConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Name != rhs.Name {
		return false
	}
	if lhs.Id != rhs.Id {
		return false
	}
	if lhs.Rd != rhs.Rd {
		return false
	}
	if len(lhs.ImportRtList) != len(rhs.ImportRtList) {
		return false
	}
	for idx, l := range lhs.ImportRtList {
		if l != rhs.ImportRtList[idx] {
			return false
		}
	}
	if len(lhs.ExportRtList) != len(rhs.ExportRtList) {
		return false
	}
	for idx, l := range lhs.ExportRtList {
		if l != rhs.ExportRtList[idx] {
			return false
		}
	}
	if len(lhs.BothRtList) != len(rhs.BothRtList) {
		return false
	}
	for idx, l := range lhs.BothRtList {
		if l != rhs.BothRtList[idx] {
			return false
		}
	}
	return true
}

// struct for container gobgp:vrf.
// VRF instance configurations on the local system.
type Vrf struct {
	// original -> gobgp:name
	// original -> gobgp:vrf-config
	// Configuration parameters for VRF.
	Config VrfConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> gobgp:vrf-state
	// Configured states of VRF.
	State VrfState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *Vrf) Equal(rhs *Vrf) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container gobgp:state.
// Configuration parameters relating to BMP server.
type BmpServerState struct {
	// original -> gobgp:address
	// gobgp:address's original type is inet:ip-address.
	// Reference to the address of the BMP server used as
	// a key in the BMP server list.
	Address string `mapstructure:"address" json:"address,omitempty"`
	// original -> gobgp:port
	// Reference to the port of the BMP server.
	Port uint32 `mapstructure:"port" json:"port,omitempty"`
	// original -> gobgp:route-monitoring-policy
	RouteMonitoringPolicy BmpRouteMonitoringPolicyType `mapstructure:"route-monitoring-policy" json:"route-monitoring-policy,omitempty"`
	// original -> gobgp:statistics-timeout
	// Interval seconds of statistics messages sent to BMP server.
	StatisticsTimeout uint16 `mapstructure:"statistics-timeout" json:"statistics-timeout,omitempty"`
	// original -> gobgp:route-mirroring-enabled
	// gobgp:route-mirroring-enabled's original type is boolean.
	// Enable feature for mirroring of received BGP messages
	// mainly for debugging purpose.
	RouteMirroringEnabled bool `mapstructure:"route-mirroring-enabled" json:"route-mirroring-enabled,omitempty"`
	// original -> gobgp:sys-name
	// Reference to the SysName of the BMP server.
	SysName string `mapstructure:"sys-name" json:"sys-name,omitempty"`
	// original -> gobgp:sys-descr
	// Reference to the SysDescr of the BMP server.
	SysDescr string `mapstructure:"sys-descr" json:"sys-descr,omitempty"`
}

// struct for container gobgp:config.
// Configuration parameters relating to BMP server.
type BmpServerConfig struct {
	// original -> gobgp:address
	// gobgp:address's original type is inet:ip-address.
	// Reference to the address of the BMP server used as
	// a key in the BMP server list.
	Address string `mapstructure:"address" json:"address,omitempty"`
	// original -> gobgp:port
	// Reference to the port of the BMP server.
	Port uint32 `mapstructure:"port" json:"port,omitempty"`
	// original -> gobgp:route-monitoring-policy
	RouteMonitoringPolicy BmpRouteMonitoringPolicyType `mapstructure:"route-monitoring-policy" json:"route-monitoring-policy,omitempty"`
	// original -> gobgp:statistics-timeout
	// Interval seconds of statistics messages sent to BMP server.
	StatisticsTimeout uint16 `mapstructure:"statistics-timeout" json:"statistics-timeout,omitempty"`
	// original -> gobgp:route-mirroring-enabled
	// gobgp:route-mirroring-enabled's original type is boolean.
	// Enable feature for mirroring of received BGP messages
	// mainly for debugging purpose.
	RouteMirroringEnabled bool `mapstructure:"route-mirroring-enabled" json:"route-mirroring-enabled,omitempty"`
	// original -> gobgp:sys-name
	// Reference to the SysName of the BMP server.
	SysName string `mapstructure:"sys-name" json:"sys-name,omitempty"`
	// original -> gobgp:sys-descr
	// Reference to the SysDescr of the BMP server.
	SysDescr string `mapstructure:"sys-descr" json:"sys-descr,omitempty"`
}

func (lhs *BmpServerConfig) Equal(rhs *BmpServerConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Address != rhs.Address {
		return false
	}
	if lhs.Port != rhs.Port {
		return false
	}
	if lhs.RouteMonitoringPolicy != rhs.RouteMonitoringPolicy {
		return false
	}
	if lhs.StatisticsTimeout != rhs.StatisticsTimeout {
		return false
	}
	if lhs.RouteMirroringEnabled != rhs.RouteMirroringEnabled {
		return false
	}
	if lhs.SysName != rhs.SysName {
		return false
	}
	if lhs.SysDescr != rhs.SysDescr {
		return false
	}
	return true
}

// struct for container gobgp:bmp-server.
// List of BMP servers configured on the local system.
type BmpServer struct {
	// original -> gobgp:address
	// original -> gobgp:bmp-server-config
	// Configuration parameters relating to BMP server.
	Config BmpServerConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> gobgp:bmp-server-state
	// Configuration parameters relating to BMP server.
	State BmpServerState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *BmpServer) Equal(rhs *BmpServer) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container gobgp:rpki-received.
// Counters for reception RPKI Message types.
type RpkiReceived struct {
	// original -> gobgp:serial-notify
	// Number of serial notify message received from RPKI server.
	SerialNotify int64 `mapstructure:"serial-notify" json:"serial-notify,omitempty"`
	// original -> gobgp:cache-reset
	// Number of cache reset message received from RPKI server.
	CacheReset int64 `mapstructure:"cache-reset" json:"cache-reset,omitempty"`
	// original -> gobgp:cache-response
	// Number of cache response message received from RPKI server.
	CacheResponse int64 `mapstructure:"cache-response" json:"cache-response,omitempty"`
	// original -> gobgp:ipv4-prefix
	// Number of ipv4 prefix message received from RPKI server.
	Ipv4Prefix int64 `mapstructure:"ipv4-prefix" json:"ipv4-prefix,omitempty"`
	// original -> gobgp:ipv6-prefix
	// Number of ipv6 prefix message received from RPKI server.
	Ipv6Prefix int64 `mapstructure:"ipv6-prefix" json:"ipv6-prefix,omitempty"`
	// original -> gobgp:end-of-data
	// Number of end of data message received from RPKI server.
	EndOfData int64 `mapstructure:"end-of-data" json:"end-of-data,omitempty"`
	// original -> gobgp:error
	// Number of error message received from RPKI server.
	Error int64 `mapstructure:"error" json:"error,omitempty"`
}

func (lhs *RpkiReceived) Equal(rhs *RpkiReceived) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SerialNotify != rhs.SerialNotify {
		return false
	}
	if lhs.CacheReset != rhs.CacheReset {
		return false
	}
	if lhs.CacheResponse != rhs.CacheResponse {
		return false
	}
	if lhs.Ipv4Prefix != rhs.Ipv4Prefix {
		return false
	}
	if lhs.Ipv6Prefix != rhs.Ipv6Prefix {
		return false
	}
	if lhs.EndOfData != rhs.EndOfData {
		return false
	}
	if lhs.Error != rhs.Error {
		return false
	}
	return true
}

// struct for container gobgp:rpki-sent.
// Counters for transmission RPKI Message types.
type RpkiSent struct {
	// original -> gobgp:serial-query
	// Number of serial query message sent to RPKI server.
	SerialQuery int64 `mapstructure:"serial-query" json:"serial-query,omitempty"`
	// original -> gobgp:reset-query
	// Number of reset query message sent to RPKI server.
	ResetQuery int64 `mapstructure:"reset-query" json:"reset-query,omitempty"`
	// original -> gobgp:error
	// Number of error message sent to RPKI server.
	Error int64 `mapstructure:"error" json:"error,omitempty"`
}

func (lhs *RpkiSent) Equal(rhs *RpkiSent) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SerialQuery != rhs.SerialQuery {
		return false
	}
	if lhs.ResetQuery != rhs.ResetQuery {
		return false
	}
	if lhs.Error != rhs.Error {
		return false
	}
	return true
}

// struct for container gobgp:rpki-messages.
// Counters for transmission and reception RPKI Message types.
type RpkiMessages struct {
	// original -> gobgp:rpki-sent
	// Counters for transmission RPKI Message types.
	RpkiSent RpkiSent `mapstructure:"rpki-sent" json:"rpki-sent,omitempty"`
	// original -> gobgp:rpki-received
	// Counters for reception RPKI Message types.
	RpkiReceived RpkiReceived `mapstructure:"rpki-received" json:"rpki-received,omitempty"`
}

func (lhs *RpkiMessages) Equal(rhs *RpkiMessages) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.RpkiSent.Equal(&(rhs.RpkiSent)) {
		return false
	}
	if !lhs.RpkiReceived.Equal(&(rhs.RpkiReceived)) {
		return false
	}
	return true
}

// struct for container gobgp:state.
// State information relating to RPKI server.
type RpkiServerState struct {
	// original -> gobgp:up
	// gobgp:up's original type is boolean.
	Up bool `mapstructure:"up" json:"up,omitempty"`
	// original -> gobgp:serial-number
	SerialNumber uint32 `mapstructure:"serial-number" json:"serial-number,omitempty"`
	// original -> gobgp:records-v4
	RecordsV4 uint32 `mapstructure:"records-v4" json:"records-v4,omitempty"`
	// original -> gobgp:records-v6
	RecordsV6 uint32 `mapstructure:"records-v6" json:"records-v6,omitempty"`
	// original -> gobgp:prefixes-v4
	PrefixesV4 uint32 `mapstructure:"prefixes-v4" json:"prefixes-v4,omitempty"`
	// original -> gobgp:prefixes-v6
	PrefixesV6 uint32 `mapstructure:"prefixes-v6" json:"prefixes-v6,omitempty"`
	// original -> gobgp:uptime
	// This timer determines the amount of time since the
	// RPKI last transitioned in of the Established state.
	Uptime int64 `mapstructure:"uptime" json:"uptime,omitempty"`
	// original -> gobgp:downtime
	// This timer determines the amount of time since the
	// RPKI last transitioned out of the Established state.
	Downtime int64 `mapstructure:"downtime" json:"downtime,omitempty"`
	// original -> gobgp:last-pdu-recv-time
	// last time the received an pdu message from RPKI server.
	LastPduRecvTime int64 `mapstructure:"last-pdu-recv-time" json:"last-pdu-recv-time,omitempty"`
	// original -> gobgp:rpki-messages
	// Counters for transmission and reception RPKI Message types.
	RpkiMessages RpkiMessages `mapstructure:"rpki-messages" json:"rpki-messages,omitempty"`
}

// struct for container gobgp:config.
// Configuration parameters relating to RPKI server.
type RpkiServerConfig struct {
	// original -> gobgp:address
	// gobgp:address's original type is inet:ip-address.
	// Reference to the address of the RPKI server used as
	// a key in the RPKI server list.
	Address string `mapstructure:"address" json:"address,omitempty"`
	// original -> gobgp:port
	// Reference to the port of the RPKI server.
	Port uint32 `mapstructure:"port" json:"port,omitempty"`
	// original -> gobgp:refresh-time
	// Check interval for a configured RPKI server.
	RefreshTime int64 `mapstructure:"refresh-time" json:"refresh-time,omitempty"`
	// original -> gobgp:hold-time
	// Specify the length of time in seconds that the session between
	// the router and RPKI server is to be considered operational
	// without any activity.
	HoldTime int64 `mapstructure:"hold-time" json:"hold-time,omitempty"`
	// original -> gobgp:record-lifetime
	// Indicate the expiration date of the route validation recode
	// received from RPKI server.
	RecordLifetime int64 `mapstructure:"record-lifetime" json:"record-lifetime,omitempty"`
	// original -> gobgp:preference
	// RPKI server has a static preference.
	// Higher the preference values indicates a higher priority RPKI server.
	Preference uint8 `mapstructure:"preference" json:"preference,omitempty"`
}

func (lhs *RpkiServerConfig) Equal(rhs *RpkiServerConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Address != rhs.Address {
		return false
	}
	if lhs.Port != rhs.Port {
		return false
	}
	if lhs.RefreshTime != rhs.RefreshTime {
		return false
	}
	if lhs.HoldTime != rhs.HoldTime {
		return false
	}
	if lhs.RecordLifetime != rhs.RecordLifetime {
		return false
	}
	if lhs.Preference != rhs.Preference {
		return false
	}
	return true
}

// struct for container gobgp:rpki-server.
// List of RPKI servers configured on the local system.
type RpkiServer struct {
	// original -> gobgp:address
	// original -> gobgp:rpki-server-config
	// Configuration parameters relating to RPKI server.
	Config RpkiServerConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> gobgp:rpki-server-state
	// State information relating to RPKI server.
	State RpkiServerState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *RpkiServer) Equal(rhs *RpkiServer) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to the BGP neighbor or group.
type PeerGroupState struct {
	// original -> bgp:peer-as
	// bgp:peer-as's original type is inet:as-number.
	// AS number of the peer.
	PeerAs uint32 `mapstructure:"peer-as" json:"peer-as,omitempty"`
	// original -> bgp:local-as
	// bgp:local-as's original type is inet:as-number.
	// The local autonomous system number that is to be used
	// when establishing sessions with the remote peer or peer
	// group, if this differs from the global BGP router
	// autonomous system number.
	LocalAs uint32 `mapstructure:"local-as" json:"local-as,omitempty"`
	// original -> bgp:peer-type
	// Explicitly designate the peer or peer group as internal
	// (iBGP) or external (eBGP).
	PeerType PeerType `mapstructure:"peer-type" json:"peer-type,omitempty"`
	// original -> bgp:auth-password
	// Configures an MD5 authentication password for use with
	// neighboring devices.
	AuthPassword string `mapstructure:"auth-password" json:"auth-password,omitempty"`
	// original -> bgp:remove-private-as
	// Remove private AS numbers from updates sent to peers.
	RemovePrivateAs RemovePrivateAsOption `mapstructure:"remove-private-as" json:"remove-private-as,omitempty"`
	// original -> bgp:route-flap-damping
	// bgp:route-flap-damping's original type is boolean.
	// Enable route flap damping.
	RouteFlapDamping bool `mapstructure:"route-flap-damping" json:"route-flap-damping,omitempty"`
	// original -> bgp:send-community
	// Specify which types of community should be sent to the
	// neighbor or group. The default is to not send the
	// community attribute.
	SendCommunity CommunityType `mapstructure:"send-community" json:"send-community,omitempty"`
	// original -> bgp:description
	// An optional textual description (intended primarily for use
	// with a peer or group.
	Description string `mapstructure:"description" json:"description,omitempty"`
	// original -> bgp:peer-group-name
	// Name of the BGP peer-group.
	PeerGroupName string `mapstructure:"peer-group-name" json:"peer-group-name,omitempty"`
	// original -> bgp-op:total-paths
	// Total number of BGP paths within the context.
	TotalPaths uint32 `mapstructure:"total-paths" json:"total-paths,omitempty"`
	// original -> bgp-op:total-prefixes
	// .
	TotalPrefixes uint32 `mapstructure:"total-prefixes" json:"total-prefixes,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to the BGP neighbor or
// group.
type PeerGroupConfig struct {
	// original -> bgp:peer-as
	// bgp:peer-as's original type is inet:as-number.
	// AS number of the peer.
	PeerAs uint32 `mapstructure:"peer-as" json:"peer-as,omitempty"`
	// original -> bgp:local-as
	// bgp:local-as's original type is inet:as-number.
	// The local autonomous system number that is to be used
	// when establishing sessions with the remote peer or peer
	// group, if this differs from the global BGP router
	// autonomous system number.
	LocalAs uint32 `mapstructure:"local-as" json:"local-as,omitempty"`
	// original -> bgp:peer-type
	// Explicitly designate the peer or peer group as internal
	// (iBGP) or external (eBGP).
	PeerType PeerType `mapstructure:"peer-type" json:"peer-type,omitempty"`
	// original -> bgp:auth-password
	// Configures an MD5 authentication password for use with
	// neighboring devices.
	AuthPassword string `mapstructure:"auth-password" json:"auth-password,omitempty"`
	// original -> bgp:remove-private-as
	// Remove private AS numbers from updates sent to peers.
	RemovePrivateAs RemovePrivateAsOption `mapstructure:"remove-private-as" json:"remove-private-as,omitempty"`
	// original -> bgp:route-flap-damping
	// bgp:route-flap-damping's original type is boolean.
	// Enable route flap damping.
	RouteFlapDamping bool `mapstructure:"route-flap-damping" json:"route-flap-damping,omitempty"`
	// original -> bgp:send-community
	// Specify which types of community should be sent to the
	// neighbor or group. The default is to not send the
	// community attribute.
	SendCommunity CommunityType `mapstructure:"send-community" json:"send-community,omitempty"`
	// original -> bgp:description
	// An optional textual description (intended primarily for use
	// with a peer or group.
	Description string `mapstructure:"description" json:"description,omitempty"`
	// original -> bgp:peer-group-name
	// Name of the BGP peer-group.
	PeerGroupName string `mapstructure:"peer-group-name" json:"peer-group-name,omitempty"`
	// original -> gobgp:send-software-version
	// gobgp:send-software-version's original type is boolean.
	SendSoftwareVersion bool `mapstructure:"send-software-version" json:"send-software-version,omitempty"`
}

func (lhs *PeerGroupConfig) Equal(rhs *PeerGroupConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.PeerAs != rhs.PeerAs {
		return false
	}
	if lhs.LocalAs != rhs.LocalAs {
		return false
	}
	if lhs.PeerType != rhs.PeerType {
		return false
	}
	if lhs.AuthPassword != rhs.AuthPassword {
		return false
	}
	if lhs.RemovePrivateAs != rhs.RemovePrivateAs {
		return false
	}
	if lhs.RouteFlapDamping != rhs.RouteFlapDamping {
		return false
	}
	if lhs.SendCommunity != rhs.SendCommunity {
		return false
	}
	if lhs.Description != rhs.Description {
		return false
	}
	if lhs.PeerGroupName != rhs.PeerGroupName {
		return false
	}
	if lhs.SendSoftwareVersion != rhs.SendSoftwareVersion {
		return false
	}
	return true
}

// struct for container bgp:peer-group.
// List of BGP peer-groups configured on the local system -
// uniquely identified by peer-group name.
type PeerGroup struct {
	// original -> bgp:peer-group-name
	// original -> bgp:peer-group-config
	// Configuration parameters relating to the BGP neighbor or
	// group.
	Config PeerGroupConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:peer-group-state
	// State information relating to the BGP neighbor or group.
	State PeerGroupState `mapstructure:"state" json:"state,omitempty"`
	// original -> bgp:timers
	// Timers related to a BGP neighbor or group.
	Timers Timers `mapstructure:"timers" json:"timers,omitempty"`
	// original -> bgp:transport
	// Transport session parameters for the BGP neighbor or group.
	Transport Transport `mapstructure:"transport" json:"transport,omitempty"`
	// original -> bgp:error-handling
	// Error handling parameters used for the BGP neighbor or
	// group.
	ErrorHandling ErrorHandling `mapstructure:"error-handling" json:"error-handling,omitempty"`
	// original -> bgp:logging-options
	// Logging options for events related to the BGP neighbor or
	// group.
	LoggingOptions LoggingOptions `mapstructure:"logging-options" json:"logging-options,omitempty"`
	// original -> bgp:ebgp-multihop
	// eBGP multi-hop parameters for the BGP neighbor or group.
	EbgpMultihop EbgpMultihop `mapstructure:"ebgp-multihop" json:"ebgp-multihop,omitempty"`
	// original -> bgp:route-reflector
	// Route reflector parameters for the BGP neighbor or group.
	RouteReflector RouteReflector `mapstructure:"route-reflector" json:"route-reflector,omitempty"`
	// original -> bgp:as-path-options
	// AS_PATH manipulation parameters for the BGP neighbor or
	// group.
	AsPathOptions AsPathOptions `mapstructure:"as-path-options" json:"as-path-options,omitempty"`
	// original -> bgp:add-paths
	// Parameters relating to the advertisement and receipt of
	// multiple paths for a single NLRI (add-paths).
	AddPaths AddPaths `mapstructure:"add-paths" json:"add-paths,omitempty"`
	// original -> bgp:afi-safis
	// Per-address-family configuration parameters associated with
	// the neighbor or group.
	AfiSafis []AfiSafi `mapstructure:"afi-safis" json:"afi-safis,omitempty"`
	// original -> bgp:graceful-restart
	// Parameters relating the graceful restart mechanism for BGP.
	GracefulRestart GracefulRestart `mapstructure:"graceful-restart" json:"graceful-restart,omitempty"`
	// original -> rpol:apply-policy
	// Anchor point for routing policies in the model.
	// Import and export policies are with respect to the local
	// routing table, i.e., export (send) and import (receive),
	// depending on the context.
	ApplyPolicy ApplyPolicy `mapstructure:"apply-policy" json:"apply-policy,omitempty"`
	// original -> bgp-mp:use-multiple-paths
	// Parameters related to the use of multiple paths for the
	// same NLRI.
	UseMultiplePaths UseMultiplePaths `mapstructure:"use-multiple-paths" json:"use-multiple-paths,omitempty"`
	// original -> gobgp:route-server
	// Configure the local router as a route server.
	RouteServer RouteServer `mapstructure:"route-server" json:"route-server,omitempty"`
	// original -> gobgp:ttl-security
	// Configure TTL Security feature.
	TtlSecurity TtlSecurity `mapstructure:"ttl-security" json:"ttl-security,omitempty"`
}

func (lhs *PeerGroup) Equal(rhs *PeerGroup) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	if !lhs.Timers.Equal(&(rhs.Timers)) {
		return false
	}
	if !lhs.Transport.Equal(&(rhs.Transport)) {
		return false
	}
	if !lhs.ErrorHandling.Equal(&(rhs.ErrorHandling)) {
		return false
	}
	if !lhs.LoggingOptions.Equal(&(rhs.LoggingOptions)) {
		return false
	}
	if !lhs.EbgpMultihop.Equal(&(rhs.EbgpMultihop)) {
		return false
	}
	if !lhs.RouteReflector.Equal(&(rhs.RouteReflector)) {
		return false
	}
	if !lhs.AsPathOptions.Equal(&(rhs.AsPathOptions)) {
		return false
	}
	if !lhs.AddPaths.Equal(&(rhs.AddPaths)) {
		return false
	}
	if len(lhs.AfiSafis) != len(rhs.AfiSafis) {
		return false
	}
	{
		lmap := make(map[string]*AfiSafi)
		for i, l := range lhs.AfiSafis {
			lmap[mapkey(i, string(l.Config.AfiSafiName))] = &lhs.AfiSafis[i]
		}
		for i, r := range rhs.AfiSafis {
			if l, y := lmap[mapkey(i, string(r.Config.AfiSafiName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if !lhs.GracefulRestart.Equal(&(rhs.GracefulRestart)) {
		return false
	}
	if !lhs.ApplyPolicy.Equal(&(rhs.ApplyPolicy)) {
		return false
	}
	if !lhs.UseMultiplePaths.Equal(&(rhs.UseMultiplePaths)) {
		return false
	}
	if !lhs.RouteServer.Equal(&(rhs.RouteServer)) {
		return false
	}
	if !lhs.TtlSecurity.Equal(&(rhs.TtlSecurity)) {
		return false
	}
	return true
}

// struct for container gobgp:state.
// State information for TTL Security.
type TtlSecurityState struct {
	// original -> gobgp:enabled
	// gobgp:enabled's original type is boolean.
	// Enable features for TTL Security.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> gobgp:ttl-min
	// Reference to the port of the BMP server.
	TtlMin uint8 `mapstructure:"ttl-min" json:"ttl-min,omitempty"`
}

// struct for container gobgp:config.
// Configuration parameters for TTL Security.
type TtlSecurityConfig struct {
	// original -> gobgp:enabled
	// gobgp:enabled's original type is boolean.
	// Enable features for TTL Security.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> gobgp:ttl-min
	// Reference to the port of the BMP server.
	TtlMin uint8 `mapstructure:"ttl-min" json:"ttl-min,omitempty"`
}

func (lhs *TtlSecurityConfig) Equal(rhs *TtlSecurityConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.TtlMin != rhs.TtlMin {
		return false
	}
	return true
}

// struct for container gobgp:ttl-security.
// Configure TTL Security feature.
type TtlSecurity struct {
	// original -> gobgp:ttl-security-config
	// Configuration parameters for TTL Security.
	Config TtlSecurityConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> gobgp:ttl-security-state
	// State information for TTL Security.
	State TtlSecurityState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *TtlSecurity) Equal(rhs *TtlSecurity) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container gobgp:state.
// State information relating to route server
// client(s) used for the BGP neighbor.
type RouteServerState struct {
	// original -> gobgp:route-server-client
	// gobgp:route-server-client's original type is boolean.
	// Configure the neighbor as a route server client.
	RouteServerClient bool `mapstructure:"route-server-client" json:"route-server-client,omitempty"`
	// original -> gobgp:secondary-route
	// gobgp:secondary-route's original type is boolean.
	// if an export policy rejects a selected route, try the next route in
	// order until one that is accepted is found or all routes for the peer
	// are rejected.
	SecondaryRoute bool `mapstructure:"secondary-route" json:"secondary-route,omitempty"`
}

// struct for container gobgp:config.
// Configuration parameters relating to route server
// client(s) used for the BGP neighbor.
type RouteServerConfig struct {
	// original -> gobgp:route-server-client
	// gobgp:route-server-client's original type is boolean.
	// Configure the neighbor as a route server client.
	RouteServerClient bool `mapstructure:"route-server-client" json:"route-server-client,omitempty"`
	// original -> gobgp:secondary-route
	// gobgp:secondary-route's original type is boolean.
	// if an export policy rejects a selected route, try the next route in
	// order until one that is accepted is found or all routes for the peer
	// are rejected.
	SecondaryRoute bool `mapstructure:"secondary-route" json:"secondary-route,omitempty"`
}

func (lhs *RouteServerConfig) Equal(rhs *RouteServerConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.RouteServerClient != rhs.RouteServerClient {
		return false
	}
	if lhs.SecondaryRoute != rhs.SecondaryRoute {
		return false
	}
	return true
}

// struct for container gobgp:route-server.
// Configure the local router as a route server.
type RouteServer struct {
	// original -> gobgp:route-server-config
	// Configuration parameters relating to route server
	// client(s) used for the BGP neighbor.
	Config RouteServerConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> gobgp:route-server-state
	// State information relating to route server
	// client(s) used for the BGP neighbor.
	State RouteServerState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *RouteServer) Equal(rhs *RouteServer) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp-op:prefixes.
// Prefix counters for the BGP session.
type Prefixes struct {
	// original -> bgp-op:received
	// The number of prefixes received from the neighbor.
	Received uint32 `mapstructure:"received" json:"received,omitempty"`
	// original -> bgp-op:sent
	// The number of prefixes advertised to the neighbor.
	Sent uint32 `mapstructure:"sent" json:"sent,omitempty"`
	// original -> bgp-op:installed
	// The number of advertised prefixes installed in the
	// Loc-RIB.
	Installed uint32 `mapstructure:"installed" json:"installed,omitempty"`
}

func (lhs *Prefixes) Equal(rhs *Prefixes) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Received != rhs.Received {
		return false
	}
	if lhs.Sent != rhs.Sent {
		return false
	}
	if lhs.Installed != rhs.Installed {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information associated with ADD_PATHS.
type AddPathsState struct {
	// original -> bgp:receive
	// bgp:receive's original type is boolean.
	// Enable ability to receive multiple path advertisements
	// for an NLRI from the neighbor or group.
	Receive bool `mapstructure:"receive" json:"receive,omitempty"`
	// original -> bgp:send-max
	// The maximum number of paths to advertise to neighbors
	// for a single NLRI.
	SendMax uint8 `mapstructure:"send-max" json:"send-max,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to ADD_PATHS.
type AddPathsConfig struct {
	// original -> bgp:receive
	// bgp:receive's original type is boolean.
	// Enable ability to receive multiple path advertisements
	// for an NLRI from the neighbor or group.
	Receive bool `mapstructure:"receive" json:"receive,omitempty"`
	// original -> bgp:send-max
	// The maximum number of paths to advertise to neighbors
	// for a single NLRI.
	SendMax uint8 `mapstructure:"send-max" json:"send-max,omitempty"`
}

func (lhs *AddPathsConfig) Equal(rhs *AddPathsConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Receive != rhs.Receive {
		return false
	}
	if lhs.SendMax != rhs.SendMax {
		return false
	}
	return true
}

// struct for container bgp:add-paths.
// Parameters relating to the advertisement and receipt of
// multiple paths for a single NLRI (add-paths).
type AddPaths struct {
	// original -> bgp:add-paths-config
	// Configuration parameters relating to ADD_PATHS.
	Config AddPathsConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:add-paths-state
	// State information associated with ADD_PATHS.
	State AddPathsState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *AddPaths) Equal(rhs *AddPaths) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to the AS_PATH manipulation
// mechanisms for the BGP peer or group.
type AsPathOptionsState struct {
	// original -> bgp:allow-own-as
	// Specify the number of occurrences of the local BGP speaker's
	// AS that can occur within the AS_PATH before it is rejected.
	AllowOwnAs uint8 `mapstructure:"allow-own-as" json:"allow-own-as,omitempty"`
	// original -> bgp:replace-peer-as
	// bgp:replace-peer-as's original type is boolean.
	// Replace occurrences of the peer's AS in the AS_PATH
	// with the local autonomous system number.
	ReplacePeerAs bool `mapstructure:"replace-peer-as" json:"replace-peer-as,omitempty"`
	// original -> gobgp:allow-as-path-loop-local
	// gobgp:allow-as-path-loop-local's original type is boolean.
	// Bypasses as-path loop detection on locally sourced (static) routes
	// when exporting towards iBGP neighbors. This is needed in some environments
	// where gobgp is functioning as a route injector. Non-local routes
	// are still checked for as-path loops.
	AllowAsPathLoopLocal bool `mapstructure:"allow-as-path-loop-local" json:"allow-as-path-loop-local,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to AS_PATH manipulation
// for the BGP peer or group.
type AsPathOptionsConfig struct {
	// original -> bgp:allow-own-as
	// Specify the number of occurrences of the local BGP speaker's
	// AS that can occur within the AS_PATH before it is rejected.
	AllowOwnAs uint8 `mapstructure:"allow-own-as" json:"allow-own-as,omitempty"`
	// original -> bgp:replace-peer-as
	// bgp:replace-peer-as's original type is boolean.
	// Replace occurrences of the peer's AS in the AS_PATH
	// with the local autonomous system number.
	ReplacePeerAs bool `mapstructure:"replace-peer-as" json:"replace-peer-as,omitempty"`
	// original -> gobgp:allow-as-path-loop-local
	// gobgp:allow-as-path-loop-local's original type is boolean.
	// Bypasses as-path loop detection on locally sourced (static) routes
	// when exporting towards iBGP neighbors. This is needed in some environments
	// where gobgp is functioning as a route injector. Non-local routes
	// are still checked for as-path loops.
	AllowAsPathLoopLocal bool `mapstructure:"allow-as-path-loop-local" json:"allow-as-path-loop-local,omitempty"`
}

func (lhs *AsPathOptionsConfig) Equal(rhs *AsPathOptionsConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AllowOwnAs != rhs.AllowOwnAs {
		return false
	}
	if lhs.ReplacePeerAs != rhs.ReplacePeerAs {
		return false
	}
	if lhs.AllowAsPathLoopLocal != rhs.AllowAsPathLoopLocal {
		return false
	}
	return true
}

// struct for container bgp:as-path-options.
// AS_PATH manipulation parameters for the BGP neighbor or
// group.
type AsPathOptions struct {
	// original -> bgp:as-path-options-config
	// Configuration parameters relating to AS_PATH manipulation
	// for the BGP peer or group.
	Config AsPathOptionsConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:as-path-options-state
	// State information relating to the AS_PATH manipulation
	// mechanisms for the BGP peer or group.
	State AsPathOptionsState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *AsPathOptions) Equal(rhs *AsPathOptions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to route reflection for the
// BGP neighbor or group.
type RouteReflectorState struct {
	// original -> bgp:route-reflector-cluster-id
	// route-reflector cluster id to use when local router is
	// configured as a route reflector.  Commonly set at the group
	// level, but allows a different cluster
	// id to be set for each neighbor.
	RouteReflectorClusterId RrClusterIdType `mapstructure:"route-reflector-cluster-id" json:"route-reflector-cluster-id,omitempty"`
	// original -> bgp:route-reflector-client
	// bgp:route-reflector-client's original type is boolean.
	// Configure the neighbor as a route reflector client.
	RouteReflectorClient bool `mapstructure:"route-reflector-client" json:"route-reflector-client,omitempty"`
}

// struct for container bgp:config.
// Configuraton parameters relating to route reflection
// for the BGP neighbor or group.
type RouteReflectorConfig struct {
	// original -> bgp:route-reflector-cluster-id
	// route-reflector cluster id to use when local router is
	// configured as a route reflector.  Commonly set at the group
	// level, but allows a different cluster
	// id to be set for each neighbor.
	RouteReflectorClusterId RrClusterIdType `mapstructure:"route-reflector-cluster-id" json:"route-reflector-cluster-id,omitempty"`
	// original -> bgp:route-reflector-client
	// bgp:route-reflector-client's original type is boolean.
	// Configure the neighbor as a route reflector client.
	RouteReflectorClient bool `mapstructure:"route-reflector-client" json:"route-reflector-client,omitempty"`
}

func (lhs *RouteReflectorConfig) Equal(rhs *RouteReflectorConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.RouteReflectorClusterId != rhs.RouteReflectorClusterId {
		return false
	}
	if lhs.RouteReflectorClient != rhs.RouteReflectorClient {
		return false
	}
	return true
}

// struct for container bgp:route-reflector.
// Route reflector parameters for the BGP neighbor or group.
type RouteReflector struct {
	// original -> bgp:route-reflector-config
	// Configuraton parameters relating to route reflection
	// for the BGP neighbor or group.
	Config RouteReflectorConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:route-reflector-state
	// State information relating to route reflection for the
	// BGP neighbor or group.
	State RouteReflectorState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *RouteReflector) Equal(rhs *RouteReflector) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information for eBGP multihop, for the BGP neighbor
// or group.
type EbgpMultihopState struct {
	// original -> bgp:enabled
	// bgp:enabled's original type is boolean.
	// When enabled the referenced group or neighbors are permitted
	// to be indirectly connected - including cases where the TTL
	// can be decremented between the BGP peers.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> bgp:multihop-ttl
	// Time-to-live value to use when packets are sent to the
	// referenced group or neighbors and ebgp-multihop is enabled.
	MultihopTtl uint8 `mapstructure:"multihop-ttl" json:"multihop-ttl,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to eBGP multihop for the
// BGP neighbor or group.
type EbgpMultihopConfig struct {
	// original -> bgp:enabled
	// bgp:enabled's original type is boolean.
	// When enabled the referenced group or neighbors are permitted
	// to be indirectly connected - including cases where the TTL
	// can be decremented between the BGP peers.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> bgp:multihop-ttl
	// Time-to-live value to use when packets are sent to the
	// referenced group or neighbors and ebgp-multihop is enabled.
	MultihopTtl uint8 `mapstructure:"multihop-ttl" json:"multihop-ttl,omitempty"`
}

func (lhs *EbgpMultihopConfig) Equal(rhs *EbgpMultihopConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.MultihopTtl != rhs.MultihopTtl {
		return false
	}
	return true
}

// struct for container bgp:ebgp-multihop.
// eBGP multi-hop parameters for the BGP neighbor or group.
type EbgpMultihop struct {
	// original -> bgp:ebgp-multihop-config
	// Configuration parameters relating to eBGP multihop for the
	// BGP neighbor or group.
	Config EbgpMultihopConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:ebgp-multihop-state
	// State information for eBGP multihop, for the BGP neighbor
	// or group.
	State EbgpMultihopState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *EbgpMultihop) Equal(rhs *EbgpMultihop) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to logging for the BGP neighbor
// or group.
type LoggingOptionsState struct {
	// original -> bgp:log-neighbor-state-changes
	// bgp:log-neighbor-state-changes's original type is boolean.
	// Configure logging of peer state changes.  Default is
	// to enable logging of peer state changes.
	LogNeighborStateChanges bool `mapstructure:"log-neighbor-state-changes" json:"log-neighbor-state-changes,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters enabling or modifying logging
// for events relating to the BGP neighbor or group.
type LoggingOptionsConfig struct {
	// original -> bgp:log-neighbor-state-changes
	// bgp:log-neighbor-state-changes's original type is boolean.
	// Configure logging of peer state changes.  Default is
	// to enable logging of peer state changes.
	LogNeighborStateChanges bool `mapstructure:"log-neighbor-state-changes" json:"log-neighbor-state-changes,omitempty"`
}

func (lhs *LoggingOptionsConfig) Equal(rhs *LoggingOptionsConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.LogNeighborStateChanges != rhs.LogNeighborStateChanges {
		return false
	}
	return true
}

// struct for container bgp:logging-options.
// Logging options for events related to the BGP neighbor or
// group.
type LoggingOptions struct {
	// original -> bgp:logging-options-config
	// Configuration parameters enabling or modifying logging
	// for events relating to the BGP neighbor or group.
	Config LoggingOptionsConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:logging-options-state
	// State information relating to logging for the BGP neighbor
	// or group.
	State LoggingOptionsState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *LoggingOptions) Equal(rhs *LoggingOptions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to enhanced error handling
// mechanisms for the BGP neighbor or group.
type ErrorHandlingState struct {
	// original -> bgp:treat-as-withdraw
	// bgp:treat-as-withdraw's original type is boolean.
	// Specify whether erroneous UPDATE messages for which the
	// NLRI can be extracted are reated as though the NLRI is
	// withdrawn - avoiding session reset.
	TreatAsWithdraw bool `mapstructure:"treat-as-withdraw" json:"treat-as-withdraw,omitempty"`
	// original -> bgp-op:erroneous-update-messages
	// The number of BGP UPDATE messages for which the
	// treat-as-withdraw mechanism has been applied based
	// on erroneous message contents.
	ErroneousUpdateMessages uint32 `mapstructure:"erroneous-update-messages" json:"erroneous-update-messages,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters enabling or modifying the
// behavior or enhanced error handling mechanisms for the BGP
// neighbor or group.
type ErrorHandlingConfig struct {
	// original -> bgp:treat-as-withdraw
	// bgp:treat-as-withdraw's original type is boolean.
	// Specify whether erroneous UPDATE messages for which the
	// NLRI can be extracted are reated as though the NLRI is
	// withdrawn - avoiding session reset.
	TreatAsWithdraw bool `mapstructure:"treat-as-withdraw" json:"treat-as-withdraw,omitempty"`
}

func (lhs *ErrorHandlingConfig) Equal(rhs *ErrorHandlingConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.TreatAsWithdraw != rhs.TreatAsWithdraw {
		return false
	}
	return true
}

// struct for container bgp:error-handling.
// Error handling parameters used for the BGP neighbor or
// group.
type ErrorHandling struct {
	// original -> bgp:error-handling-config
	// Configuration parameters enabling or modifying the
	// behavior or enhanced error handling mechanisms for the BGP
	// neighbor or group.
	Config ErrorHandlingConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:error-handling-state
	// State information relating to enhanced error handling
	// mechanisms for the BGP neighbor or group.
	State ErrorHandlingState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *ErrorHandling) Equal(rhs *ErrorHandling) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to the transport session(s)
// used for the BGP neighbor or group.
type TransportState struct {
	// original -> bgp:tcp-mss
	// Sets the max segment size for BGP TCP sessions.
	TcpMss uint16 `mapstructure:"tcp-mss" json:"tcp-mss,omitempty"`
	// original -> bgp:mtu-discovery
	// bgp:mtu-discovery's original type is boolean.
	// Turns path mtu discovery for BGP TCP sessions on (true)
	// or off (false).
	MtuDiscovery bool `mapstructure:"mtu-discovery" json:"mtu-discovery,omitempty"`
	// original -> bgp:passive-mode
	// bgp:passive-mode's original type is boolean.
	// Wait for peers to issue requests to open a BGP session,
	// rather than initiating sessions from the local router.
	PassiveMode bool `mapstructure:"passive-mode" json:"passive-mode,omitempty"`
	// original -> bgp:local-address
	// bgp:local-address's original type is union.
	// Set the local IP (either IPv4 or IPv6) address to use
	// for the session when sending BGP update messages.  This
	// may be expressed as either an IP address or reference
	// to the name of an interface.
	LocalAddress string `mapstructure:"local-address" json:"local-address,omitempty"`
	// original -> bgp-op:local-port
	// bgp-op:local-port's original type is inet:port-number.
	// Local TCP port being used for the TCP session supporting
	// the BGP session.
	LocalPort uint16 `mapstructure:"local-port" json:"local-port,omitempty"`
	// original -> bgp-op:remote-address
	// bgp-op:remote-address's original type is inet:ip-address.
	// Remote address to which the BGP session has been
	// established.
	RemoteAddress string `mapstructure:"remote-address" json:"remote-address,omitempty"`
	// original -> bgp-op:remote-port
	// bgp-op:remote-port's original type is inet:port-number.
	// Remote port being used by the peer for the TCP session
	// supporting the BGP session.
	RemotePort uint16 `mapstructure:"remote-port" json:"remote-port,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to the transport
// session(s) used for the BGP neighbor or group.
type TransportConfig struct {
	// original -> bgp:tcp-mss
	// Sets the max segment size for BGP TCP sessions.
	TcpMss uint16 `mapstructure:"tcp-mss" json:"tcp-mss,omitempty"`
	// original -> bgp:mtu-discovery
	// bgp:mtu-discovery's original type is boolean.
	// Turns path mtu discovery for BGP TCP sessions on (true)
	// or off (false).
	MtuDiscovery bool `mapstructure:"mtu-discovery" json:"mtu-discovery,omitempty"`
	// original -> bgp:passive-mode
	// bgp:passive-mode's original type is boolean.
	// Wait for peers to issue requests to open a BGP session,
	// rather than initiating sessions from the local router.
	PassiveMode bool `mapstructure:"passive-mode" json:"passive-mode,omitempty"`
	// original -> bgp:local-address
	// bgp:local-address's original type is union.
	// Set the local IP (either IPv4 or IPv6) address to use
	// for the session when sending BGP update messages.  This
	// may be expressed as either an IP address or reference
	// to the name of an interface.
	LocalAddress string `mapstructure:"local-address" json:"local-address,omitempty"`
	// original -> gobgp:local-port
	// gobgp:local-port's original type is inet:port-number.
	// Set the local port (if available) to use for the session.
	LocalPort uint16 `mapstructure:"local-port" json:"local-port,omitempty"`
	// original -> gobgp:remote-port
	// gobgp:remote-port's original type is inet:port-number.
	RemotePort uint16 `mapstructure:"remote-port" json:"remote-port,omitempty"`
	// original -> gobgp:ttl
	// TTL value for BGP packets.
	Ttl uint8 `mapstructure:"ttl" json:"ttl,omitempty"`
	// original -> gobgp:bind-interface
	// Interface name for binding.
	BindInterface string `mapstructure:"bind-interface" json:"bind-interface,omitempty"`
}

func (lhs *TransportConfig) Equal(rhs *TransportConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.TcpMss != rhs.TcpMss {
		return false
	}
	if lhs.MtuDiscovery != rhs.MtuDiscovery {
		return false
	}
	if lhs.PassiveMode != rhs.PassiveMode {
		return false
	}
	if lhs.LocalAddress != rhs.LocalAddress {
		return false
	}
	if lhs.LocalPort != rhs.LocalPort {
		return false
	}
	if lhs.RemotePort != rhs.RemotePort {
		return false
	}
	if lhs.Ttl != rhs.Ttl {
		return false
	}
	if lhs.BindInterface != rhs.BindInterface {
		return false
	}
	return true
}

// struct for container bgp:transport.
// Transport session parameters for the BGP neighbor or group.
type Transport struct {
	// original -> bgp:transport-config
	// Configuration parameters relating to the transport
	// session(s) used for the BGP neighbor or group.
	Config TransportConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:transport-state
	// State information relating to the transport session(s)
	// used for the BGP neighbor or group.
	State TransportState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *Transport) Equal(rhs *Transport) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to the timers used for the BGP
// neighbor or group.
type TimersState struct {
	// original -> bgp:connect-retry
	// bgp:connect-retry's original type is decimal64.
	// Time interval in seconds between attempts to establish a
	// session with the peer.
	ConnectRetry float64 `mapstructure:"connect-retry" json:"connect-retry,omitempty"`
	// original -> bgp:hold-time
	// bgp:hold-time's original type is decimal64.
	// Time interval in seconds that a BGP session will be
	// considered active in the absence of keepalive or other
	// messages from the peer.  The hold-time is typically
	// set to 3x the keepalive-interval.
	HoldTime float64 `mapstructure:"hold-time" json:"hold-time,omitempty"`
	// original -> bgp:keepalive-interval
	// bgp:keepalive-interval's original type is decimal64.
	// Time interval in seconds between transmission of keepalive
	// messages to the neighbor.  Typically set to 1/3 the
	// hold-time.
	KeepaliveInterval float64 `mapstructure:"keepalive-interval" json:"keepalive-interval,omitempty"`
	// original -> bgp:minimum-advertisement-interval
	// bgp:minimum-advertisement-interval's original type is decimal64.
	// Minimum time which must elapse between subsequent UPDATE
	// messages relating to a common set of NLRI being transmitted
	// to a peer. This timer is referred to as
	// MinRouteAdvertisementIntervalTimer by RFC 4721 and serves to
	// reduce the number of UPDATE messages transmitted when a
	// particular set of NLRI exhibit instability.
	MinimumAdvertisementInterval float64 `mapstructure:"minimum-advertisement-interval" json:"minimum-advertisement-interval,omitempty"`
	// original -> bgp-op:uptime
	// bgp-op:uptime's original type is yang:timeticks.
	// This timer determines the amount of time since the
	// BGP last transitioned in or out of the Established
	// state.
	Uptime int64 `mapstructure:"uptime" json:"uptime,omitempty"`
	// original -> bgp-op:negotiated-hold-time
	// bgp-op:negotiated-hold-time's original type is decimal64.
	// The negotiated hold-time for the BGP session.
	NegotiatedHoldTime float64 `mapstructure:"negotiated-hold-time" json:"negotiated-hold-time,omitempty"`
	// original -> gobgp:idle-hold-time-after-reset
	// gobgp:idle-hold-time-after-reset's original type is decimal64.
	// Time interval in seconds that a BGP session will be
	// in idle state after neighbor reset operation.
	IdleHoldTimeAfterReset float64 `mapstructure:"idle-hold-time-after-reset" json:"idle-hold-time-after-reset,omitempty"`
	// original -> gobgp:downtime
	// gobgp:downtime's original type is yang:timeticks.
	// This timer determines the amount of time since the
	// BGP last transitioned out of the Established state.
	Downtime int64 `mapstructure:"downtime" json:"downtime,omitempty"`
	// original -> gobgp:update-recv-time
	// The number of seconds elapsed since January 1, 1970 UTC
	// last time the BGP session received an UPDATE message.
	UpdateRecvTime int64 `mapstructure:"update-recv-time" json:"update-recv-time,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to timers used for the
// BGP neighbor or group.
type TimersConfig struct {
	// original -> bgp:connect-retry
	// bgp:connect-retry's original type is decimal64.
	// Time interval in seconds between attempts to establish a
	// session with the peer.
	ConnectRetry float64 `mapstructure:"connect-retry" json:"connect-retry,omitempty"`
	// original -> bgp:hold-time
	// bgp:hold-time's original type is decimal64.
	// Time interval in seconds that a BGP session will be
	// considered active in the absence of keepalive or other
	// messages from the peer.  The hold-time is typically
	// set to 3x the keepalive-interval.
	HoldTime float64 `mapstructure:"hold-time" json:"hold-time,omitempty"`
	// original -> bgp:keepalive-interval
	// bgp:keepalive-interval's original type is decimal64.
	// Time interval in seconds between transmission of keepalive
	// messages to the neighbor.  Typically set to 1/3 the
	// hold-time.
	KeepaliveInterval float64 `mapstructure:"keepalive-interval" json:"keepalive-interval,omitempty"`
	// original -> bgp:minimum-advertisement-interval
	// bgp:minimum-advertisement-interval's original type is decimal64.
	// Minimum time which must elapse between subsequent UPDATE
	// messages relating to a common set of NLRI being transmitted
	// to a peer. This timer is referred to as
	// MinRouteAdvertisementIntervalTimer by RFC 4721 and serves to
	// reduce the number of UPDATE messages transmitted when a
	// particular set of NLRI exhibit instability.
	MinimumAdvertisementInterval float64 `mapstructure:"minimum-advertisement-interval" json:"minimum-advertisement-interval,omitempty"`
	// original -> gobgp:idle-hold-time-after-reset
	// gobgp:idle-hold-time-after-reset's original type is decimal64.
	// Time interval in seconds that a BGP session will be
	// in idle state after neighbor reset operation.
	IdleHoldTimeAfterReset float64 `mapstructure:"idle-hold-time-after-reset" json:"idle-hold-time-after-reset,omitempty"`
}

func (lhs *TimersConfig) Equal(rhs *TimersConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.ConnectRetry != rhs.ConnectRetry {
		return false
	}
	if lhs.HoldTime != rhs.HoldTime {
		return false
	}
	if lhs.KeepaliveInterval != rhs.KeepaliveInterval {
		return false
	}
	if lhs.MinimumAdvertisementInterval != rhs.MinimumAdvertisementInterval {
		return false
	}
	if lhs.IdleHoldTimeAfterReset != rhs.IdleHoldTimeAfterReset {
		return false
	}
	return true
}

// struct for container bgp:timers.
// Timers related to a BGP neighbor or group.
type Timers struct {
	// original -> bgp:timers-config
	// Configuration parameters relating to timers used for the
	// BGP neighbor or group.
	Config TimersConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:timers-state
	// State information relating to the timers used for the BGP
	// neighbor or group.
	State TimersState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *Timers) Equal(rhs *Timers) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container gobgp:adj-table.
type AdjTable struct {
	// original -> gobgp:ADVERTISED
	Advertised uint32 `mapstructure:"advertised" json:"advertised,omitempty"`
	// original -> gobgp:FILTERED
	Filtered uint32 `mapstructure:"filtered" json:"filtered,omitempty"`
	// original -> gobgp:RECEIVED
	Received uint32 `mapstructure:"received" json:"received,omitempty"`
	// original -> gobgp:ACCEPTED
	Accepted uint32 `mapstructure:"accepted" json:"accepted,omitempty"`
}

func (lhs *AdjTable) Equal(rhs *AdjTable) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Advertised != rhs.Advertised {
		return false
	}
	if lhs.Filtered != rhs.Filtered {
		return false
	}
	if lhs.Received != rhs.Received {
		return false
	}
	if lhs.Accepted != rhs.Accepted {
		return false
	}
	return true
}

// struct for container bgp:queues.
// Counters related to queued messages associated with the
// BGP neighbor.
type Queues struct {
	// original -> bgp-op:input
	// The number of messages received from the peer currently
	// queued.
	Input uint32 `mapstructure:"input" json:"input,omitempty"`
	// original -> bgp-op:output
	// The number of messages queued to be sent to the peer.
	Output uint32 `mapstructure:"output" json:"output,omitempty"`
}

func (lhs *Queues) Equal(rhs *Queues) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Input != rhs.Input {
		return false
	}
	if lhs.Output != rhs.Output {
		return false
	}
	return true
}

// struct for container bgp:received.
// Counters for BGP messages received from the neighbor.
type Received struct {
	// original -> bgp-op:UPDATE
	// Number of BGP UPDATE messages announcing, withdrawing
	// or modifying paths exchanged.
	Update uint64 `mapstructure:"update" json:"update,omitempty"`
	// original -> bgp-op:NOTIFICATION
	// Number of BGP NOTIFICATION messages indicating an
	// error condition has occurred exchanged.
	Notification uint64 `mapstructure:"notification" json:"notification,omitempty"`
	// original -> gobgp:OPEN
	// Number of BGP open messages announcing, withdrawing
	// or modifying paths exchanged.
	Open uint64 `mapstructure:"open" json:"open,omitempty"`
	// original -> gobgp:REFRESH
	// Number of BGP Route-Refresh messages indicating an
	// error condition has occurred exchanged.
	Refresh uint64 `mapstructure:"refresh" json:"refresh,omitempty"`
	// original -> gobgp:KEEPALIVE
	// Number of BGP Keepalive messages indicating an
	// error condition has occurred exchanged.
	Keepalive uint64 `mapstructure:"keepalive" json:"keepalive,omitempty"`
	// original -> gobgp:DYNAMIC-CAP
	// Number of BGP dynamic-cap messages indicating an
	// error condition has occurred exchanged.
	DynamicCap uint64 `mapstructure:"dynamic-cap" json:"dynamic-cap,omitempty"`
	// original -> gobgp:WITHDRAW-UPDATE
	// Number of updates subjected to treat-as-withdraw treatment.
	WithdrawUpdate uint32 `mapstructure:"withdraw-update" json:"withdraw-update,omitempty"`
	// original -> gobgp:WITHDRAW-PREFIX
	// Number of prefixes subjected to treat-as-withdraw treatment.
	WithdrawPrefix uint32 `mapstructure:"withdraw-prefix" json:"withdraw-prefix,omitempty"`
	// original -> gobgp:DISCARDED
	// Number of discarded messages indicating an
	// error condition has occurred exchanged.
	Discarded uint64 `mapstructure:"discarded" json:"discarded,omitempty"`
	// original -> gobgp:TOTAL
	// Number of total messages indicating an
	// error condition has occurred exchanged.
	Total uint64 `mapstructure:"total" json:"total,omitempty"`
}

func (lhs *Received) Equal(rhs *Received) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Update != rhs.Update {
		return false
	}
	if lhs.Notification != rhs.Notification {
		return false
	}
	if lhs.Open != rhs.Open {
		return false
	}
	if lhs.Refresh != rhs.Refresh {
		return false
	}
	if lhs.Keepalive != rhs.Keepalive {
		return false
	}
	if lhs.DynamicCap != rhs.DynamicCap {
		return false
	}
	if lhs.WithdrawUpdate != rhs.WithdrawUpdate {
		return false
	}
	if lhs.WithdrawPrefix != rhs.WithdrawPrefix {
		return false
	}
	if lhs.Discarded != rhs.Discarded {
		return false
	}
	if lhs.Total != rhs.Total {
		return false
	}
	return true
}

// struct for container bgp:sent.
// Counters relating to BGP messages sent to the neighbor.
type Sent struct {
	// original -> bgp-op:UPDATE
	// Number of BGP UPDATE messages announcing, withdrawing
	// or modifying paths exchanged.
	Update uint64 `mapstructure:"update" json:"update,omitempty"`
	// original -> bgp-op:NOTIFICATION
	// Number of BGP NOTIFICATION messages indicating an
	// error condition has occurred exchanged.
	Notification uint64 `mapstructure:"notification" json:"notification,omitempty"`
	// original -> gobgp:OPEN
	// Number of BGP open messages announcing, withdrawing
	// or modifying paths exchanged.
	Open uint64 `mapstructure:"open" json:"open,omitempty"`
	// original -> gobgp:REFRESH
	// Number of BGP Route-Refresh messages indicating an
	// error condition has occurred exchanged.
	Refresh uint64 `mapstructure:"refresh" json:"refresh,omitempty"`
	// original -> gobgp:KEEPALIVE
	// Number of BGP Keepalive messages indicating an
	// error condition has occurred exchanged.
	Keepalive uint64 `mapstructure:"keepalive" json:"keepalive,omitempty"`
	// original -> gobgp:DYNAMIC-CAP
	// Number of BGP dynamic-cap messages indicating an
	// error condition has occurred exchanged.
	DynamicCap uint64 `mapstructure:"dynamic-cap" json:"dynamic-cap,omitempty"`
	// original -> gobgp:WITHDRAW-UPDATE
	// Number of updates subjected to treat-as-withdraw treatment.
	WithdrawUpdate uint32 `mapstructure:"withdraw-update" json:"withdraw-update,omitempty"`
	// original -> gobgp:WITHDRAW-PREFIX
	// Number of prefixes subjected to treat-as-withdraw treatment.
	WithdrawPrefix uint32 `mapstructure:"withdraw-prefix" json:"withdraw-prefix,omitempty"`
	// original -> gobgp:DISCARDED
	// Number of discarded messages indicating an
	// error condition has occurred exchanged.
	Discarded uint64 `mapstructure:"discarded" json:"discarded,omitempty"`
	// original -> gobgp:TOTAL
	// Number of total messages indicating an
	// error condition has occurred exchanged.
	Total uint64 `mapstructure:"total" json:"total,omitempty"`
}

func (lhs *Sent) Equal(rhs *Sent) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Update != rhs.Update {
		return false
	}
	if lhs.Notification != rhs.Notification {
		return false
	}
	if lhs.Open != rhs.Open {
		return false
	}
	if lhs.Refresh != rhs.Refresh {
		return false
	}
	if lhs.Keepalive != rhs.Keepalive {
		return false
	}
	if lhs.DynamicCap != rhs.DynamicCap {
		return false
	}
	if lhs.WithdrawUpdate != rhs.WithdrawUpdate {
		return false
	}
	if lhs.WithdrawPrefix != rhs.WithdrawPrefix {
		return false
	}
	if lhs.Discarded != rhs.Discarded {
		return false
	}
	if lhs.Total != rhs.Total {
		return false
	}
	return true
}

// struct for container bgp:messages.
// Counters for BGP messages sent and received from the
// neighbor.
type Messages struct {
	// original -> bgp:sent
	// Counters relating to BGP messages sent to the neighbor.
	Sent Sent `mapstructure:"sent" json:"sent,omitempty"`
	// original -> bgp:received
	// Counters for BGP messages received from the neighbor.
	Received Received `mapstructure:"received" json:"received,omitempty"`
}

func (lhs *Messages) Equal(rhs *Messages) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Sent.Equal(&(rhs.Sent)) {
		return false
	}
	if !lhs.Received.Equal(&(rhs.Received)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to the BGP neighbor or group.
type NeighborState struct {
	// original -> bgp:peer-as
	// bgp:peer-as's original type is inet:as-number.
	// AS number of the peer.
	PeerAs uint32 `mapstructure:"peer-as" json:"peer-as,omitempty"`
	// original -> bgp:local-as
	// bgp:local-as's original type is inet:as-number.
	// The local autonomous system number that is to be used
	// when establishing sessions with the remote peer or peer
	// group, if this differs from the global BGP router
	// autonomous system number.
	LocalAs uint32 `mapstructure:"local-as" json:"local-as,omitempty"`
	// original -> bgp:peer-type
	// Explicitly designate the peer or peer group as internal
	// (iBGP) or external (eBGP).
	PeerType PeerType `mapstructure:"peer-type" json:"peer-type,omitempty"`
	// original -> bgp:auth-password
	// Configures an MD5 authentication password for use with
	// neighboring devices.
	AuthPassword string `mapstructure:"auth-password" json:"auth-password,omitempty"`
	// original -> bgp:remove-private-as
	// Remove private AS numbers from updates sent to peers.
	RemovePrivateAs RemovePrivateAsOption `mapstructure:"remove-private-as" json:"remove-private-as,omitempty"`
	// original -> bgp:route-flap-damping
	// bgp:route-flap-damping's original type is boolean.
	// Enable route flap damping.
	RouteFlapDamping bool `mapstructure:"route-flap-damping" json:"route-flap-damping,omitempty"`
	// original -> bgp:send-community
	// Specify which types of community should be sent to the
	// neighbor or group. The default is to not send the
	// community attribute.
	SendCommunity CommunityType `mapstructure:"send-community" json:"send-community,omitempty"`
	// original -> bgp:description
	// An optional textual description (intended primarily for use
	// with a peer or group.
	Description string `mapstructure:"description" json:"description,omitempty"`
	// original -> bgp:peer-group
	// The peer-group with which this neighbor is associated.
	PeerGroup string `mapstructure:"peer-group" json:"peer-group,omitempty"`
	// original -> bgp:neighbor-address
	// bgp:neighbor-address's original type is inet:ip-address.
	// Address of the BGP peer, either in IPv4 or IPv6.
	NeighborAddress string `mapstructure:"neighbor-address" json:"neighbor-address,omitempty"`
	// original -> bgp-op:session-state
	// Operational state of the BGP peer.
	SessionState SessionState `mapstructure:"session-state" json:"session-state,omitempty"`
	// original -> bgp-op:supported-capabilities
	// BGP capabilities negotiated as supported with the peer.
	SupportedCapabilitiesList []BgpCapability `mapstructure:"supported-capabilities-list" json:"supported-capabilities-list,omitempty"`
	// original -> bgp:messages
	// Counters for BGP messages sent and received from the
	// neighbor.
	Messages Messages `mapstructure:"messages" json:"messages,omitempty"`
	// original -> bgp:queues
	// Counters related to queued messages associated with the
	// BGP neighbor.
	Queues Queues `mapstructure:"queues" json:"queues,omitempty"`
	// original -> gobgp:adj-table
	AdjTable AdjTable `mapstructure:"adj-table" json:"adj-table,omitempty"`
	// original -> gobgp:remote-capability
	// original type is list of bgp-capability
	RemoteCapabilityList []bgp.ParameterCapabilityInterface `mapstructure:"remote-capability-list" json:"remote-capability-list,omitempty"`
	// original -> gobgp:local-capability
	// original type is list of bgp-capability
	LocalCapabilityList []bgp.ParameterCapabilityInterface `mapstructure:"local-capability-list" json:"local-capability-list,omitempty"`
	// original -> gobgp:received-open-message
	// gobgp:received-open-message's original type is bgp-open-message.
	ReceivedOpenMessage *bgp.BGPMessage `mapstructure:"received-open-message" json:"received-open-message,omitempty"`
	// original -> gobgp:admin-down
	// gobgp:admin-down's original type is boolean.
	// The state of administrative operation. If the state is true, it indicates the neighbor is disabled by the administrator.
	AdminDown bool `mapstructure:"admin-down" json:"admin-down,omitempty"`
	// original -> gobgp:admin-state
	AdminState AdminState `mapstructure:"admin-state" json:"admin-state,omitempty"`
	// original -> gobgp:established-count
	// The number of how many the peer became established state.
	EstablishedCount uint32 `mapstructure:"established-count" json:"established-count,omitempty"`
	// original -> gobgp:flops
	// The number of flip-flops.
	Flops uint32 `mapstructure:"flops" json:"flops,omitempty"`
	// original -> gobgp:neighbor-interface
	NeighborInterface string `mapstructure:"neighbor-interface" json:"neighbor-interface,omitempty"`
	// original -> gobgp:vrf
	Vrf string `mapstructure:"vrf" json:"vrf,omitempty"`
	// original -> gobgp:remote-router-id
	RemoteRouterId string `mapstructure:"remote-router-id" json:"remote-router-id,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to the BGP neighbor or
// group.
type NeighborConfig struct {
	// original -> bgp:peer-as
	// bgp:peer-as's original type is inet:as-number.
	// AS number of the peer.
	PeerAs uint32 `mapstructure:"peer-as" json:"peer-as,omitempty"`
	// original -> bgp:local-as
	// bgp:local-as's original type is inet:as-number.
	// The local autonomous system number that is to be used
	// when establishing sessions with the remote peer or peer
	// group, if this differs from the global BGP router
	// autonomous system number.
	LocalAs uint32 `mapstructure:"local-as" json:"local-as,omitempty"`
	// original -> bgp:peer-type
	// Explicitly designate the peer or peer group as internal
	// (iBGP) or external (eBGP).
	PeerType PeerType `mapstructure:"peer-type" json:"peer-type,omitempty"`
	// original -> bgp:auth-password
	// Configures an MD5 authentication password for use with
	// neighboring devices.
	AuthPassword string `mapstructure:"auth-password" json:"auth-password,omitempty"`
	// original -> bgp:remove-private-as
	// Remove private AS numbers from updates sent to peers.
	RemovePrivateAs RemovePrivateAsOption `mapstructure:"remove-private-as" json:"remove-private-as,omitempty"`
	// original -> bgp:route-flap-damping
	// bgp:route-flap-damping's original type is boolean.
	// Enable route flap damping.
	RouteFlapDamping bool `mapstructure:"route-flap-damping" json:"route-flap-damping,omitempty"`
	// original -> bgp:send-community
	// Specify which types of community should be sent to the
	// neighbor or group. The default is to not send the
	// community attribute.
	SendCommunity CommunityType `mapstructure:"send-community" json:"send-community,omitempty"`
	// original -> bgp:description
	// An optional textual description (intended primarily for use
	// with a peer or group.
	Description string `mapstructure:"description" json:"description,omitempty"`
	// original -> bgp:peer-group
	// The peer-group with which this neighbor is associated.
	PeerGroup string `mapstructure:"peer-group" json:"peer-group,omitempty"`
	// original -> bgp:neighbor-address
	// bgp:neighbor-address's original type is inet:ip-address.
	// Address of the BGP peer, either in IPv4 or IPv6.
	NeighborAddress string `mapstructure:"neighbor-address" json:"neighbor-address,omitempty"`
	// original -> gobgp:admin-down
	// gobgp:admin-down's original type is boolean.
	// The config of administrative operation. If state, indicates the neighbor is disabled by the administrator.
	AdminDown bool `mapstructure:"admin-down" json:"admin-down,omitempty"`
	// original -> gobgp:neighbor-interface
	NeighborInterface string `mapstructure:"neighbor-interface" json:"neighbor-interface,omitempty"`
	// original -> gobgp:vrf
	Vrf string `mapstructure:"vrf" json:"vrf,omitempty"`
	// original -> gobgp:send-software-version
	// gobgp:send-software-version's original type is boolean.
	SendSoftwareVersion bool `mapstructure:"send-software-version" json:"send-software-version,omitempty"`
}

func (lhs *NeighborConfig) Equal(rhs *NeighborConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.PeerAs != rhs.PeerAs {
		return false
	}
	if lhs.LocalAs != rhs.LocalAs {
		return false
	}
	if lhs.PeerType != rhs.PeerType {
		return false
	}
	if lhs.AuthPassword != rhs.AuthPassword {
		return false
	}
	if lhs.RemovePrivateAs != rhs.RemovePrivateAs {
		return false
	}
	if lhs.RouteFlapDamping != rhs.RouteFlapDamping {
		return false
	}
	if lhs.SendCommunity != rhs.SendCommunity {
		return false
	}
	if lhs.Description != rhs.Description {
		return false
	}
	if lhs.PeerGroup != rhs.PeerGroup {
		return false
	}
	if lhs.NeighborAddress != rhs.NeighborAddress {
		return false
	}
	if lhs.AdminDown != rhs.AdminDown {
		return false
	}
	if lhs.NeighborInterface != rhs.NeighborInterface {
		return false
	}
	if lhs.Vrf != rhs.Vrf {
		return false
	}
	if lhs.SendSoftwareVersion != rhs.SendSoftwareVersion {
		return false
	}
	return true
}

// struct for container bgp:neighbor.
// List of BGP neighbors configured on the local system,
// uniquely identified by peer IPv[46] address.
type Neighbor struct {
	// original -> bgp:neighbor-address
	// original -> bgp:neighbor-config
	// Configuration parameters relating to the BGP neighbor or
	// group.
	Config NeighborConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:neighbor-state
	// State information relating to the BGP neighbor or group.
	State NeighborState `mapstructure:"state" json:"state,omitempty"`
	// original -> bgp:timers
	// Timers related to a BGP neighbor or group.
	Timers Timers `mapstructure:"timers" json:"timers,omitempty"`
	// original -> bgp:transport
	// Transport session parameters for the BGP neighbor or group.
	Transport Transport `mapstructure:"transport" json:"transport,omitempty"`
	// original -> bgp:error-handling
	// Error handling parameters used for the BGP neighbor or
	// group.
	ErrorHandling ErrorHandling `mapstructure:"error-handling" json:"error-handling,omitempty"`
	// original -> bgp:logging-options
	// Logging options for events related to the BGP neighbor or
	// group.
	LoggingOptions LoggingOptions `mapstructure:"logging-options" json:"logging-options,omitempty"`
	// original -> bgp:ebgp-multihop
	// eBGP multi-hop parameters for the BGP neighbor or group.
	EbgpMultihop EbgpMultihop `mapstructure:"ebgp-multihop" json:"ebgp-multihop,omitempty"`
	// original -> bgp:route-reflector
	// Route reflector parameters for the BGP neighbor or group.
	RouteReflector RouteReflector `mapstructure:"route-reflector" json:"route-reflector,omitempty"`
	// original -> bgp:as-path-options
	// AS_PATH manipulation parameters for the BGP neighbor or
	// group.
	AsPathOptions AsPathOptions `mapstructure:"as-path-options" json:"as-path-options,omitempty"`
	// original -> bgp:add-paths
	// Parameters relating to the advertisement and receipt of
	// multiple paths for a single NLRI (add-paths).
	AddPaths AddPaths `mapstructure:"add-paths" json:"add-paths,omitempty"`
	// original -> bgp:afi-safis
	// Per-address-family configuration parameters associated with
	// the neighbor or group.
	AfiSafis []AfiSafi `mapstructure:"afi-safis" json:"afi-safis,omitempty"`
	// original -> bgp:graceful-restart
	// Parameters relating the graceful restart mechanism for BGP.
	GracefulRestart GracefulRestart `mapstructure:"graceful-restart" json:"graceful-restart,omitempty"`
	// original -> rpol:apply-policy
	// Anchor point for routing policies in the model.
	// Import and export policies are with respect to the local
	// routing table, i.e., export (send) and import (receive),
	// depending on the context.
	ApplyPolicy ApplyPolicy `mapstructure:"apply-policy" json:"apply-policy,omitempty"`
	// original -> bgp-mp:use-multiple-paths
	// Parameters related to the use of multiple-paths for the same
	// NLRI when they are received only from this neighbor.
	UseMultiplePaths UseMultiplePaths `mapstructure:"use-multiple-paths" json:"use-multiple-paths,omitempty"`
	// original -> gobgp:route-server
	// Configure the local router as a route server.
	RouteServer RouteServer `mapstructure:"route-server" json:"route-server,omitempty"`
	// original -> gobgp:ttl-security
	// Configure TTL Security feature.
	TtlSecurity TtlSecurity `mapstructure:"ttl-security" json:"ttl-security,omitempty"`
}

func (lhs *Neighbor) Equal(rhs *Neighbor) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	if !lhs.Timers.Equal(&(rhs.Timers)) {
		return false
	}
	if !lhs.Transport.Equal(&(rhs.Transport)) {
		return false
	}
	if !lhs.ErrorHandling.Equal(&(rhs.ErrorHandling)) {
		return false
	}
	if !lhs.LoggingOptions.Equal(&(rhs.LoggingOptions)) {
		return false
	}
	if !lhs.EbgpMultihop.Equal(&(rhs.EbgpMultihop)) {
		return false
	}
	if !lhs.RouteReflector.Equal(&(rhs.RouteReflector)) {
		return false
	}
	if !lhs.AsPathOptions.Equal(&(rhs.AsPathOptions)) {
		return false
	}
	if !lhs.AddPaths.Equal(&(rhs.AddPaths)) {
		return false
	}
	if len(lhs.AfiSafis) != len(rhs.AfiSafis) {
		return false
	}
	{
		lmap := make(map[string]*AfiSafi)
		for i, l := range lhs.AfiSafis {
			lmap[mapkey(i, string(l.Config.AfiSafiName))] = &lhs.AfiSafis[i]
		}
		for i, r := range rhs.AfiSafis {
			if l, y := lmap[mapkey(i, string(r.Config.AfiSafiName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if !lhs.GracefulRestart.Equal(&(rhs.GracefulRestart)) {
		return false
	}
	if !lhs.ApplyPolicy.Equal(&(rhs.ApplyPolicy)) {
		return false
	}
	if !lhs.UseMultiplePaths.Equal(&(rhs.UseMultiplePaths)) {
		return false
	}
	if !lhs.RouteServer.Equal(&(rhs.RouteServer)) {
		return false
	}
	if !lhs.TtlSecurity.Equal(&(rhs.TtlSecurity)) {
		return false
	}
	return true
}

// struct for container gobgp:state.
type LongLivedGracefulRestartState struct {
	// original -> gobgp:enabled
	// gobgp:enabled's original type is boolean.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> gobgp:received
	// gobgp:received's original type is boolean.
	Received bool `mapstructure:"received" json:"received,omitempty"`
	// original -> gobgp:advertised
	// gobgp:advertised's original type is boolean.
	Advertised bool `mapstructure:"advertised" json:"advertised,omitempty"`
	// original -> gobgp:peer-restart-time
	PeerRestartTime uint32 `mapstructure:"peer-restart-time" json:"peer-restart-time,omitempty"`
	// original -> gobgp:peer-restart-timer-expired
	// gobgp:peer-restart-timer-expired's original type is boolean.
	PeerRestartTimerExpired bool `mapstructure:"peer-restart-timer-expired" json:"peer-restart-timer-expired,omitempty"`
}

// struct for container gobgp:config.
type LongLivedGracefulRestartConfig struct {
	// original -> gobgp:enabled
	// gobgp:enabled's original type is boolean.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> gobgp:restart-time
	RestartTime uint32 `mapstructure:"restart-time" json:"restart-time,omitempty"`
}

func (lhs *LongLivedGracefulRestartConfig) Equal(rhs *LongLivedGracefulRestartConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.RestartTime != rhs.RestartTime {
		return false
	}
	return true
}

// struct for container gobgp:long-lived-graceful-restart.
type LongLivedGracefulRestart struct {
	// original -> gobgp:long-lived-graceful-restart-config
	Config LongLivedGracefulRestartConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> gobgp:long-lived-graceful-restart-state
	State LongLivedGracefulRestartState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *LongLivedGracefulRestart) Equal(rhs *LongLivedGracefulRestart) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container gobgp:state.
type RouteTargetMembershipState struct {
	// original -> gobgp:deferral-time
	DeferralTime uint16 `mapstructure:"deferral-time" json:"deferral-time,omitempty"`
}

// struct for container gobgp:config.
type RouteTargetMembershipConfig struct {
	// original -> gobgp:deferral-time
	DeferralTime uint16 `mapstructure:"deferral-time" json:"deferral-time,omitempty"`
}

func (lhs *RouteTargetMembershipConfig) Equal(rhs *RouteTargetMembershipConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.DeferralTime != rhs.DeferralTime {
		return false
	}
	return true
}

// struct for container gobgp:route-target-membership.
type RouteTargetMembership struct {
	// original -> gobgp:route-target-membership-config
	Config RouteTargetMembershipConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> gobgp:route-target-membership-state
	State RouteTargetMembershipState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *RouteTargetMembership) Equal(rhs *RouteTargetMembership) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp-mp:l2vpn-evpn.
// BGP EVPN configuration options.
type L2vpnEvpn struct {
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
}

func (lhs *L2vpnEvpn) Equal(rhs *L2vpnEvpn) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

// struct for container bgp-mp:l2vpn-vpls.
// BGP-signalled VPLS configuration options.
type L2vpnVpls struct {
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
}

func (lhs *L2vpnVpls) Equal(rhs *L2vpnVpls) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

// struct for container bgp-mp:l3vpn-ipv6-multicast.
// Multicast IPv6 L3VPN configuration options.
type L3vpnIpv6Multicast struct {
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
}

func (lhs *L3vpnIpv6Multicast) Equal(rhs *L3vpnIpv6Multicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

// struct for container bgp-mp:l3vpn-ipv4-multicast.
// Multicast IPv4 L3VPN configuration options.
type L3vpnIpv4Multicast struct {
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
}

func (lhs *L3vpnIpv4Multicast) Equal(rhs *L3vpnIpv4Multicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

// struct for container bgp-mp:l3vpn-ipv6-unicast.
// Unicast IPv6 L3VPN configuration options.
type L3vpnIpv6Unicast struct {
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
}

func (lhs *L3vpnIpv6Unicast) Equal(rhs *L3vpnIpv6Unicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

// struct for container bgp-mp:l3vpn-ipv4-unicast.
// Unicast IPv4 L3VPN configuration options.
type L3vpnIpv4Unicast struct {
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
}

func (lhs *L3vpnIpv4Unicast) Equal(rhs *L3vpnIpv4Unicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

// struct for container bgp-mp:ipv6-labelled-unicast.
// IPv6 Labelled Unicast configuration options.
type Ipv6LabelledUnicast struct {
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
}

func (lhs *Ipv6LabelledUnicast) Equal(rhs *Ipv6LabelledUnicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

// struct for container bgp-mp:ipv4-labelled-unicast.
// IPv4 Labelled Unicast configuration options.
type Ipv4LabelledUnicast struct {
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
}

func (lhs *Ipv4LabelledUnicast) Equal(rhs *Ipv4LabelledUnicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

// struct for container bgp-mp:state.
// State information for common IPv4 and IPv6 unicast
// parameters.
type Ipv6UnicastState struct {
	// original -> bgp-mp:send-default-route
	// bgp-mp:send-default-route's original type is boolean.
	// If set to true, send the default-route to the neighbour(s).
	SendDefaultRoute bool `mapstructure:"send-default-route" json:"send-default-route,omitempty"`
}

// struct for container bgp-mp:config.
// Configuration parameters for common IPv4 and IPv6 unicast
// AFI-SAFI options.
type Ipv6UnicastConfig struct {
	// original -> bgp-mp:send-default-route
	// bgp-mp:send-default-route's original type is boolean.
	// If set to true, send the default-route to the neighbour(s).
	SendDefaultRoute bool `mapstructure:"send-default-route" json:"send-default-route,omitempty"`
}

func (lhs *Ipv6UnicastConfig) Equal(rhs *Ipv6UnicastConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SendDefaultRoute != rhs.SendDefaultRoute {
		return false
	}
	return true
}

// struct for container bgp-mp:ipv6-unicast.
// IPv6 unicast configuration options.
type Ipv6Unicast struct {
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
	// original -> bgp-mp:ipv6-unicast-config
	// Configuration parameters for common IPv4 and IPv6 unicast
	// AFI-SAFI options.
	Config Ipv6UnicastConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp-mp:ipv6-unicast-state
	// State information for common IPv4 and IPv6 unicast
	// parameters.
	State Ipv6UnicastState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *Ipv6Unicast) Equal(rhs *Ipv6Unicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp-mp:state.
// State information for common IPv4 and IPv6 unicast
// parameters.
type Ipv4UnicastState struct {
	// original -> bgp-mp:send-default-route
	// bgp-mp:send-default-route's original type is boolean.
	// If set to true, send the default-route to the neighbour(s).
	SendDefaultRoute bool `mapstructure:"send-default-route" json:"send-default-route,omitempty"`
}

// struct for container bgp-mp:config.
// Configuration parameters for common IPv4 and IPv6 unicast
// AFI-SAFI options.
type Ipv4UnicastConfig struct {
	// original -> bgp-mp:send-default-route
	// bgp-mp:send-default-route's original type is boolean.
	// If set to true, send the default-route to the neighbour(s).
	SendDefaultRoute bool `mapstructure:"send-default-route" json:"send-default-route,omitempty"`
}

func (lhs *Ipv4UnicastConfig) Equal(rhs *Ipv4UnicastConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SendDefaultRoute != rhs.SendDefaultRoute {
		return false
	}
	return true
}

// struct for container bgp-mp:state.
// State information relating to the prefix-limit for the
// AFI-SAFI.
type PrefixLimitState struct {
	// original -> bgp-mp:max-prefixes
	// Maximum number of prefixes that will be accepted
	// from the neighbour.
	MaxPrefixes uint32 `mapstructure:"max-prefixes" json:"max-prefixes,omitempty"`
	// original -> bgp-mp:shutdown-threshold-pct
	// Threshold on number of prefixes that can be received
	// from a neighbour before generation of warning messages
	// or log entries. Expressed as a percentage of
	// max-prefixes.
	ShutdownThresholdPct Percentage `mapstructure:"shutdown-threshold-pct" json:"shutdown-threshold-pct,omitempty"`
	// original -> bgp-mp:restart-timer
	// bgp-mp:restart-timer's original type is decimal64.
	// Time interval in seconds after which the BGP session
	// is re-established after being torn down due to exceeding
	// the max-prefix limit.
	RestartTimer float64 `mapstructure:"restart-timer" json:"restart-timer,omitempty"`
}

// struct for container bgp-mp:config.
// Configuration parameters relating to the prefix
// limit for the AFI-SAFI.
type PrefixLimitConfig struct {
	// original -> bgp-mp:max-prefixes
	// Maximum number of prefixes that will be accepted
	// from the neighbour.
	MaxPrefixes uint32 `mapstructure:"max-prefixes" json:"max-prefixes,omitempty"`
	// original -> bgp-mp:shutdown-threshold-pct
	// Threshold on number of prefixes that can be received
	// from a neighbour before generation of warning messages
	// or log entries. Expressed as a percentage of
	// max-prefixes.
	ShutdownThresholdPct Percentage `mapstructure:"shutdown-threshold-pct" json:"shutdown-threshold-pct,omitempty"`
	// original -> bgp-mp:restart-timer
	// bgp-mp:restart-timer's original type is decimal64.
	// Time interval in seconds after which the BGP session
	// is re-established after being torn down due to exceeding
	// the max-prefix limit.
	RestartTimer float64 `mapstructure:"restart-timer" json:"restart-timer,omitempty"`
}

func (lhs *PrefixLimitConfig) Equal(rhs *PrefixLimitConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.MaxPrefixes != rhs.MaxPrefixes {
		return false
	}
	if lhs.ShutdownThresholdPct != rhs.ShutdownThresholdPct {
		return false
	}
	if lhs.RestartTimer != rhs.RestartTimer {
		return false
	}
	return true
}

// struct for container bgp-mp:prefix-limit.
// Configure the maximum number of prefixes that will be
// accepted from a peer.
type PrefixLimit struct {
	// original -> bgp-mp:prefix-limit-config
	// Configuration parameters relating to the prefix
	// limit for the AFI-SAFI.
	Config PrefixLimitConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp-mp:prefix-limit-state
	// State information relating to the prefix-limit for the
	// AFI-SAFI.
	State PrefixLimitState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *PrefixLimit) Equal(rhs *PrefixLimit) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp-mp:ipv4-unicast.
// IPv4 unicast configuration options.
type Ipv4Unicast struct {
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
	// original -> bgp-mp:ipv4-unicast-config
	// Configuration parameters for common IPv4 and IPv6 unicast
	// AFI-SAFI options.
	Config Ipv4UnicastConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp-mp:ipv4-unicast-state
	// State information for common IPv4 and IPv6 unicast
	// parameters.
	State Ipv4UnicastState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *Ipv4Unicast) Equal(rhs *Ipv4Unicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container rpol:state.
// Operational state for routing policy.
type ApplyPolicyState struct {
	// original -> rpol:import-policy
	// list of policy names in sequence to be applied on
	// receiving a routing update in the current context, e.g.,
	// for the current peer group, neighbor, address family,
	// etc.
	ImportPolicyList []string `mapstructure:"import-policy-list" json:"import-policy-list,omitempty"`
	// original -> rpol:default-import-policy
	// explicitly set a default policy if no policy definition
	// in the import policy chain is satisfied.
	DefaultImportPolicy DefaultPolicyType `mapstructure:"default-import-policy" json:"default-import-policy,omitempty"`
	// original -> rpol:export-policy
	// list of policy names in sequence to be applied on
	// sending a routing update in the current context, e.g.,
	// for the current peer group, neighbor, address family,
	// etc.
	ExportPolicyList []string `mapstructure:"export-policy-list" json:"export-policy-list,omitempty"`
	// original -> rpol:default-export-policy
	// explicitly set a default policy if no policy definition
	// in the export policy chain is satisfied.
	DefaultExportPolicy DefaultPolicyType `mapstructure:"default-export-policy" json:"default-export-policy,omitempty"`
	// original -> gobgp:in-policy
	// list of policy names in sequence to be applied on
	// sending a routing update in the current context, e.g.,
	// for the current other route server clients.
	InPolicyList []string `mapstructure:"in-policy-list" json:"in-policy-list,omitempty"`
	// original -> gobgp:default-in-policy
	// explicitly set a default policy if no policy definition
	// in the in-policy chain is satisfied.
	DefaultInPolicy DefaultPolicyType `mapstructure:"default-in-policy" json:"default-in-policy,omitempty"`
}

// struct for container rpol:config.
// Policy configuration data.
type ApplyPolicyConfig struct {
	// original -> rpol:import-policy
	// list of policy names in sequence to be applied on
	// receiving a routing update in the current context, e.g.,
	// for the current peer group, neighbor, address family,
	// etc.
	ImportPolicyList []string `mapstructure:"import-policy-list" json:"import-policy-list,omitempty"`
	// original -> rpol:default-import-policy
	// explicitly set a default policy if no policy definition
	// in the import policy chain is satisfied.
	DefaultImportPolicy DefaultPolicyType `mapstructure:"default-import-policy" json:"default-import-policy,omitempty"`
	// original -> rpol:export-policy
	// list of policy names in sequence to be applied on
	// sending a routing update in the current context, e.g.,
	// for the current peer group, neighbor, address family,
	// etc.
	ExportPolicyList []string `mapstructure:"export-policy-list" json:"export-policy-list,omitempty"`
	// original -> rpol:default-export-policy
	// explicitly set a default policy if no policy definition
	// in the export policy chain is satisfied.
	DefaultExportPolicy DefaultPolicyType `mapstructure:"default-export-policy" json:"default-export-policy,omitempty"`
	// original -> gobgp:in-policy
	// list of policy names in sequence to be applied on
	// sending a routing update in the current context, e.g.,
	// for the current other route server clients.
	InPolicyList []string `mapstructure:"in-policy-list" json:"in-policy-list,omitempty"`
	// original -> gobgp:default-in-policy
	// explicitly set a default policy if no policy definition
	// in the in-policy chain is satisfied.
	DefaultInPolicy DefaultPolicyType `mapstructure:"default-in-policy" json:"default-in-policy,omitempty"`
}

func (lhs *ApplyPolicyConfig) Equal(rhs *ApplyPolicyConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.ImportPolicyList) != len(rhs.ImportPolicyList) {
		return false
	}
	for idx, l := range lhs.ImportPolicyList {
		if l != rhs.ImportPolicyList[idx] {
			return false
		}
	}
	if lhs.DefaultImportPolicy != rhs.DefaultImportPolicy {
		return false
	}
	if len(lhs.ExportPolicyList) != len(rhs.ExportPolicyList) {
		return false
	}
	for idx, l := range lhs.ExportPolicyList {
		if l != rhs.ExportPolicyList[idx] {
			return false
		}
	}
	if lhs.DefaultExportPolicy != rhs.DefaultExportPolicy {
		return false
	}
	if len(lhs.InPolicyList) != len(rhs.InPolicyList) {
		return false
	}
	for idx, l := range lhs.InPolicyList {
		if l != rhs.InPolicyList[idx] {
			return false
		}
	}
	if lhs.DefaultInPolicy != rhs.DefaultInPolicy {
		return false
	}
	return true
}

// struct for container rpol:apply-policy.
// Anchor point for routing policies in the model.
// Import and export policies are with respect to the local
// routing table, i.e., export (send) and import (receive),
// depending on the context.
type ApplyPolicy struct {
	// original -> rpol:apply-policy-config
	// Policy configuration data.
	Config ApplyPolicyConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> rpol:apply-policy-state
	// Operational state for routing policy.
	State ApplyPolicyState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *ApplyPolicy) Equal(rhs *ApplyPolicy) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp-mp:state.
// State information relating to the AFI-SAFI.
type AfiSafiState struct {
	// original -> bgp-mp:afi-safi-name
	// AFI,SAFI.
	AfiSafiName AfiSafiType `mapstructure:"afi-safi-name" json:"afi-safi-name,omitempty"`
	// original -> bgp-mp:enabled
	// bgp-mp:enabled's original type is boolean.
	// This leaf indicates whether the IPv4 Unicast AFI,SAFI is
	// enabled for the neighbour or group.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> bgp-op:total-paths
	// Total number of BGP paths within the context.
	TotalPaths uint32 `mapstructure:"total-paths" json:"total-paths,omitempty"`
	// original -> bgp-op:total-prefixes
	// .
	TotalPrefixes uint32 `mapstructure:"total-prefixes" json:"total-prefixes,omitempty"`
	// original -> gobgp:family
	// gobgp:family's original type is route-family.
	// Address family value of AFI-SAFI pair translated from afi-safi-name.
	Family bgp.RouteFamily `mapstructure:"family" json:"family,omitempty"`
}

// struct for container bgp-mp:config.
// Configuration parameters for the AFI-SAFI.
type AfiSafiConfig struct {
	// original -> bgp-mp:afi-safi-name
	// AFI,SAFI.
	AfiSafiName AfiSafiType `mapstructure:"afi-safi-name" json:"afi-safi-name,omitempty"`
	// original -> bgp-mp:enabled
	// bgp-mp:enabled's original type is boolean.
	// This leaf indicates whether the IPv4 Unicast AFI,SAFI is
	// enabled for the neighbour or group.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
}

func (lhs *AfiSafiConfig) Equal(rhs *AfiSafiConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AfiSafiName != rhs.AfiSafiName {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	return true
}

// struct for container bgp-mp:state.
// State information for BGP graceful-restart.
type MpGracefulRestartState struct {
	// original -> bgp-mp:enabled
	// bgp-mp:enabled's original type is boolean.
	// This leaf indicates whether graceful-restart is enabled for
	// this AFI-SAFI.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> bgp-op:received
	// bgp-op:received's original type is boolean.
	// This leaf indicates whether the neighbor advertised the
	// ability to support graceful-restart for this AFI-SAFI.
	Received bool `mapstructure:"received" json:"received,omitempty"`
	// original -> bgp-op:advertised
	// bgp-op:advertised's original type is boolean.
	// This leaf indicates whether the ability to support
	// graceful-restart has been advertised to the peer.
	Advertised bool `mapstructure:"advertised" json:"advertised,omitempty"`
	// original -> gobgp:end-of-rib-received
	// gobgp:end-of-rib-received's original type is boolean.
	EndOfRibReceived bool `mapstructure:"end-of-rib-received" json:"end-of-rib-received,omitempty"`
	// original -> gobgp:end-of-rib-sent
	// gobgp:end-of-rib-sent's original type is boolean.
	EndOfRibSent bool `mapstructure:"end-of-rib-sent" json:"end-of-rib-sent,omitempty"`
}

// struct for container bgp-mp:config.
// Configuration options for BGP graceful-restart.
type MpGracefulRestartConfig struct {
	// original -> bgp-mp:enabled
	// bgp-mp:enabled's original type is boolean.
	// This leaf indicates whether graceful-restart is enabled for
	// this AFI-SAFI.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
}

func (lhs *MpGracefulRestartConfig) Equal(rhs *MpGracefulRestartConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	return true
}

// struct for container bgp-mp:graceful-restart.
// Parameters relating to BGP graceful-restart.
type MpGracefulRestart struct {
	// original -> bgp-mp:mp-graceful-restart-config
	// Configuration options for BGP graceful-restart.
	Config MpGracefulRestartConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp-mp:mp-graceful-restart-state
	// State information for BGP graceful-restart.
	State MpGracefulRestartState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *MpGracefulRestart) Equal(rhs *MpGracefulRestart) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp-mp:afi-safi.
// AFI,SAFI configuration available for the
// neighbour or group.
type AfiSafi struct {
	// original -> bgp-mp:afi-safi-name
	// original -> bgp-mp:mp-graceful-restart
	// Parameters relating to BGP graceful-restart.
	MpGracefulRestart MpGracefulRestart `mapstructure:"mp-graceful-restart" json:"mp-graceful-restart,omitempty"`
	// original -> bgp-mp:afi-safi-config
	// Configuration parameters for the AFI-SAFI.
	Config AfiSafiConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp-mp:afi-safi-state
	// State information relating to the AFI-SAFI.
	State AfiSafiState `mapstructure:"state" json:"state,omitempty"`
	// original -> rpol:apply-policy
	// Anchor point for routing policies in the model.
	// Import and export policies are with respect to the local
	// routing table, i.e., export (send) and import (receive),
	// depending on the context.
	ApplyPolicy ApplyPolicy `mapstructure:"apply-policy" json:"apply-policy,omitempty"`
	// original -> bgp-mp:ipv4-unicast
	// IPv4 unicast configuration options.
	Ipv4Unicast Ipv4Unicast `mapstructure:"ipv4-unicast" json:"ipv4-unicast,omitempty"`
	// original -> bgp-mp:ipv6-unicast
	// IPv6 unicast configuration options.
	Ipv6Unicast Ipv6Unicast `mapstructure:"ipv6-unicast" json:"ipv6-unicast,omitempty"`
	// original -> bgp-mp:ipv4-labelled-unicast
	// IPv4 Labelled Unicast configuration options.
	Ipv4LabelledUnicast Ipv4LabelledUnicast `mapstructure:"ipv4-labelled-unicast" json:"ipv4-labelled-unicast,omitempty"`
	// original -> bgp-mp:ipv6-labelled-unicast
	// IPv6 Labelled Unicast configuration options.
	Ipv6LabelledUnicast Ipv6LabelledUnicast `mapstructure:"ipv6-labelled-unicast" json:"ipv6-labelled-unicast,omitempty"`
	// original -> bgp-mp:l3vpn-ipv4-unicast
	// Unicast IPv4 L3VPN configuration options.
	L3vpnIpv4Unicast L3vpnIpv4Unicast `mapstructure:"l3vpn-ipv4-unicast" json:"l3vpn-ipv4-unicast,omitempty"`
	// original -> bgp-mp:l3vpn-ipv6-unicast
	// Unicast IPv6 L3VPN configuration options.
	L3vpnIpv6Unicast L3vpnIpv6Unicast `mapstructure:"l3vpn-ipv6-unicast" json:"l3vpn-ipv6-unicast,omitempty"`
	// original -> bgp-mp:l3vpn-ipv4-multicast
	// Multicast IPv4 L3VPN configuration options.
	L3vpnIpv4Multicast L3vpnIpv4Multicast `mapstructure:"l3vpn-ipv4-multicast" json:"l3vpn-ipv4-multicast,omitempty"`
	// original -> bgp-mp:l3vpn-ipv6-multicast
	// Multicast IPv6 L3VPN configuration options.
	L3vpnIpv6Multicast L3vpnIpv6Multicast `mapstructure:"l3vpn-ipv6-multicast" json:"l3vpn-ipv6-multicast,omitempty"`
	// original -> bgp-mp:l2vpn-vpls
	// BGP-signalled VPLS configuration options.
	L2vpnVpls L2vpnVpls `mapstructure:"l2vpn-vpls" json:"l2vpn-vpls,omitempty"`
	// original -> bgp-mp:l2vpn-evpn
	// BGP EVPN configuration options.
	L2vpnEvpn L2vpnEvpn `mapstructure:"l2vpn-evpn" json:"l2vpn-evpn,omitempty"`
	// original -> bgp-mp:route-selection-options
	// Parameters relating to options for route selection.
	RouteSelectionOptions RouteSelectionOptions `mapstructure:"route-selection-options" json:"route-selection-options,omitempty"`
	// original -> bgp-mp:use-multiple-paths
	// Parameters related to the use of multiple paths for the
	// same NLRI.
	UseMultiplePaths UseMultiplePaths `mapstructure:"use-multiple-paths" json:"use-multiple-paths,omitempty"`
	// original -> bgp-mp:prefix-limit
	// Configure the maximum number of prefixes that will be
	// accepted from a peer.
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit" json:"prefix-limit,omitempty"`
	// original -> gobgp:route-target-membership
	RouteTargetMembership RouteTargetMembership `mapstructure:"route-target-membership" json:"route-target-membership,omitempty"`
	// original -> gobgp:long-lived-graceful-restart
	LongLivedGracefulRestart LongLivedGracefulRestart `mapstructure:"long-lived-graceful-restart" json:"long-lived-graceful-restart,omitempty"`
	// original -> gobgp:add-paths
	// add-paths configuration options related to a particular AFI-SAFI.
	AddPaths AddPaths `mapstructure:"add-paths" json:"add-paths,omitempty"`
}

func (lhs *AfiSafi) Equal(rhs *AfiSafi) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.MpGracefulRestart.Equal(&(rhs.MpGracefulRestart)) {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	if !lhs.ApplyPolicy.Equal(&(rhs.ApplyPolicy)) {
		return false
	}
	if !lhs.Ipv4Unicast.Equal(&(rhs.Ipv4Unicast)) {
		return false
	}
	if !lhs.Ipv6Unicast.Equal(&(rhs.Ipv6Unicast)) {
		return false
	}
	if !lhs.Ipv4LabelledUnicast.Equal(&(rhs.Ipv4LabelledUnicast)) {
		return false
	}
	if !lhs.Ipv6LabelledUnicast.Equal(&(rhs.Ipv6LabelledUnicast)) {
		return false
	}
	if !lhs.L3vpnIpv4Unicast.Equal(&(rhs.L3vpnIpv4Unicast)) {
		return false
	}
	if !lhs.L3vpnIpv6Unicast.Equal(&(rhs.L3vpnIpv6Unicast)) {
		return false
	}
	if !lhs.L3vpnIpv4Multicast.Equal(&(rhs.L3vpnIpv4Multicast)) {
		return false
	}
	if !lhs.L3vpnIpv6Multicast.Equal(&(rhs.L3vpnIpv6Multicast)) {
		return false
	}
	if !lhs.L2vpnVpls.Equal(&(rhs.L2vpnVpls)) {
		return false
	}
	if !lhs.L2vpnEvpn.Equal(&(rhs.L2vpnEvpn)) {
		return false
	}
	if !lhs.RouteSelectionOptions.Equal(&(rhs.RouteSelectionOptions)) {
		return false
	}
	if !lhs.UseMultiplePaths.Equal(&(rhs.UseMultiplePaths)) {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	if !lhs.RouteTargetMembership.Equal(&(rhs.RouteTargetMembership)) {
		return false
	}
	if !lhs.LongLivedGracefulRestart.Equal(&(rhs.LongLivedGracefulRestart)) {
		return false
	}
	if !lhs.AddPaths.Equal(&(rhs.AddPaths)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information associated with graceful-restart.
type GracefulRestartState struct {
	// original -> bgp:enabled
	// bgp:enabled's original type is boolean.
	// Enable or disable the graceful-restart capability.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> bgp:restart-time
	// Estimated time (in seconds) for the local BGP speaker to
	// restart a session. This value is advertise in the graceful
	// restart BGP capability.  This is a 12-bit value, referred to
	// as Restart Time in RFC4724.  Per RFC4724, the suggested
	// default value is <= the hold-time value.
	RestartTime uint16 `mapstructure:"restart-time" json:"restart-time,omitempty"`
	// original -> bgp:stale-routes-time
	// bgp:stale-routes-time's original type is decimal64.
	// An upper-bound on the time thate stale routes will be
	// retained by a router after a session is restarted. If an
	// End-of-RIB (EOR) marker is received prior to this timer
	// expiring stale-routes will be flushed upon its receipt - if
	// no EOR is received, then when this timer expires stale paths
	// will be purged. This timer is referred to as the
	// Selection_Deferral_Timer in RFC4724.
	StaleRoutesTime float64 `mapstructure:"stale-routes-time" json:"stale-routes-time,omitempty"`
	// original -> bgp:helper-only
	// bgp:helper-only's original type is boolean.
	// Enable graceful-restart in helper mode only. When this
	// leaf is set, the local system does not retain forwarding
	// its own state during a restart, but supports procedures
	// for the receiving speaker, as defined in RFC4724.
	HelperOnly bool `mapstructure:"helper-only" json:"helper-only,omitempty"`
	// original -> bgp-op:peer-restart-time
	// The period of time (advertised by the peer) that
	// the peer expects a restart of a BGP session to
	// take.
	PeerRestartTime uint16 `mapstructure:"peer-restart-time" json:"peer-restart-time,omitempty"`
	// original -> bgp-op:peer-restarting
	// bgp-op:peer-restarting's original type is boolean.
	// This flag indicates whether the remote neighbor is currently
	// in the process of restarting, and hence received routes are
	// currently stale.
	PeerRestarting bool `mapstructure:"peer-restarting" json:"peer-restarting,omitempty"`
	// original -> bgp-op:local-restarting
	// bgp-op:local-restarting's original type is boolean.
	// This flag indicates whether the local neighbor is currently
	// restarting. The flag is unset after all NLRI have been
	// advertised to the peer, and the End-of-RIB (EOR) marker has
	// been unset.
	LocalRestarting bool `mapstructure:"local-restarting" json:"local-restarting,omitempty"`
	// original -> bgp-op:mode
	// Ths leaf indicates the mode of operation of BGP graceful
	// restart with the peer.
	Mode Mode `mapstructure:"mode" json:"mode,omitempty"`
	// original -> gobgp:deferral-time
	DeferralTime uint16 `mapstructure:"deferral-time" json:"deferral-time,omitempty"`
	// original -> gobgp:notification-enabled
	// gobgp:notification-enabled's original type is boolean.
	NotificationEnabled bool `mapstructure:"notification-enabled" json:"notification-enabled,omitempty"`
	// original -> gobgp:long-lived-enabled
	// gobgp:long-lived-enabled's original type is boolean.
	LongLivedEnabled bool `mapstructure:"long-lived-enabled" json:"long-lived-enabled,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to graceful-restart.
type GracefulRestartConfig struct {
	// original -> bgp:enabled
	// bgp:enabled's original type is boolean.
	// Enable or disable the graceful-restart capability.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> bgp:restart-time
	// Estimated time (in seconds) for the local BGP speaker to
	// restart a session. This value is advertise in the graceful
	// restart BGP capability.  This is a 12-bit value, referred to
	// as Restart Time in RFC4724.  Per RFC4724, the suggested
	// default value is <= the hold-time value.
	RestartTime uint16 `mapstructure:"restart-time" json:"restart-time,omitempty"`
	// original -> bgp:stale-routes-time
	// bgp:stale-routes-time's original type is decimal64.
	// An upper-bound on the time thate stale routes will be
	// retained by a router after a session is restarted. If an
	// End-of-RIB (EOR) marker is received prior to this timer
	// expiring stale-routes will be flushed upon its receipt - if
	// no EOR is received, then when this timer expires stale paths
	// will be purged. This timer is referred to as the
	// Selection_Deferral_Timer in RFC4724.
	StaleRoutesTime float64 `mapstructure:"stale-routes-time" json:"stale-routes-time,omitempty"`
	// original -> bgp:helper-only
	// bgp:helper-only's original type is boolean.
	// Enable graceful-restart in helper mode only. When this
	// leaf is set, the local system does not retain forwarding
	// its own state during a restart, but supports procedures
	// for the receiving speaker, as defined in RFC4724.
	HelperOnly bool `mapstructure:"helper-only" json:"helper-only,omitempty"`
	// original -> gobgp:deferral-time
	DeferralTime uint16 `mapstructure:"deferral-time" json:"deferral-time,omitempty"`
	// original -> gobgp:notification-enabled
	// gobgp:notification-enabled's original type is boolean.
	NotificationEnabled bool `mapstructure:"notification-enabled" json:"notification-enabled,omitempty"`
	// original -> gobgp:long-lived-enabled
	// gobgp:long-lived-enabled's original type is boolean.
	LongLivedEnabled bool `mapstructure:"long-lived-enabled" json:"long-lived-enabled,omitempty"`
}

func (lhs *GracefulRestartConfig) Equal(rhs *GracefulRestartConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.RestartTime != rhs.RestartTime {
		return false
	}
	if lhs.StaleRoutesTime != rhs.StaleRoutesTime {
		return false
	}
	if lhs.HelperOnly != rhs.HelperOnly {
		return false
	}
	if lhs.DeferralTime != rhs.DeferralTime {
		return false
	}
	if lhs.NotificationEnabled != rhs.NotificationEnabled {
		return false
	}
	if lhs.LongLivedEnabled != rhs.LongLivedEnabled {
		return false
	}
	return true
}

// struct for container bgp:graceful-restart.
// Parameters relating the graceful restart mechanism for BGP.
type GracefulRestart struct {
	// original -> bgp:graceful-restart-config
	// Configuration parameters relating to graceful-restart.
	Config GracefulRestartConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:graceful-restart-state
	// State information associated with graceful-restart.
	State GracefulRestartState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *GracefulRestart) Equal(rhs *GracefulRestart) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp-mp:state.
// State information relating to iBGP multipath.
type IbgpState struct {
	// original -> bgp-mp:maximum-paths
	// Maximum number of parallel paths to consider when using
	// iBGP multipath. The default is to use a single path.
	MaximumPaths uint32 `mapstructure:"maximum-paths" json:"maximum-paths,omitempty"`
}

// struct for container bgp-mp:config.
// Configuration parameters relating to iBGP multipath.
type IbgpConfig struct {
	// original -> bgp-mp:maximum-paths
	// Maximum number of parallel paths to consider when using
	// iBGP multipath. The default is to use a single path.
	MaximumPaths uint32 `mapstructure:"maximum-paths" json:"maximum-paths,omitempty"`
}

func (lhs *IbgpConfig) Equal(rhs *IbgpConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.MaximumPaths != rhs.MaximumPaths {
		return false
	}
	return true
}

// struct for container bgp-mp:ibgp.
// Multipath parameters for iBGP.
type Ibgp struct {
	// original -> bgp-mp:ibgp-config
	// Configuration parameters relating to iBGP multipath.
	Config IbgpConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp-mp:ibgp-state
	// State information relating to iBGP multipath.
	State IbgpState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *Ibgp) Equal(rhs *Ibgp) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp-mp:state.
// State information relating to eBGP multipath.
type EbgpState struct {
	// original -> bgp-mp:allow-multiple-as
	// bgp-mp:allow-multiple-as's original type is boolean.
	// Allow multipath to use paths from different neighbouring
	// ASes.  The default is to only consider multiple paths from
	// the same neighbouring AS.
	AllowMultipleAs bool `mapstructure:"allow-multiple-as" json:"allow-multiple-as,omitempty"`
	// original -> bgp-mp:maximum-paths
	// Maximum number of parallel paths to consider when using
	// BGP multipath. The default is use a single path.
	MaximumPaths uint32 `mapstructure:"maximum-paths" json:"maximum-paths,omitempty"`
}

// struct for container bgp-mp:config.
// Configuration parameters relating to eBGP multipath.
type EbgpConfig struct {
	// original -> bgp-mp:allow-multiple-as
	// bgp-mp:allow-multiple-as's original type is boolean.
	// Allow multipath to use paths from different neighbouring
	// ASes.  The default is to only consider multiple paths from
	// the same neighbouring AS.
	AllowMultipleAs bool `mapstructure:"allow-multiple-as" json:"allow-multiple-as,omitempty"`
	// original -> bgp-mp:maximum-paths
	// Maximum number of parallel paths to consider when using
	// BGP multipath. The default is use a single path.
	MaximumPaths uint32 `mapstructure:"maximum-paths" json:"maximum-paths,omitempty"`
}

func (lhs *EbgpConfig) Equal(rhs *EbgpConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AllowMultipleAs != rhs.AllowMultipleAs {
		return false
	}
	if lhs.MaximumPaths != rhs.MaximumPaths {
		return false
	}
	return true
}

// struct for container bgp-mp:ebgp.
// Multipath parameters for eBGP.
type Ebgp struct {
	// original -> bgp-mp:ebgp-config
	// Configuration parameters relating to eBGP multipath.
	Config EbgpConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp-mp:ebgp-state
	// State information relating to eBGP multipath.
	State EbgpState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *Ebgp) Equal(rhs *Ebgp) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp-mp:state.
// State parameters relating to multipath.
type UseMultiplePathsState struct {
	// original -> bgp-mp:enabled
	// bgp-mp:enabled's original type is boolean.
	// Whether the use of multiple paths for the same NLRI is
	// enabled for the neighbor. This value is overridden by
	// any more specific configuration value.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
}

// struct for container bgp-mp:config.
// Configuration parameters relating to multipath.
type UseMultiplePathsConfig struct {
	// original -> bgp-mp:enabled
	// bgp-mp:enabled's original type is boolean.
	// Whether the use of multiple paths for the same NLRI is
	// enabled for the neighbor. This value is overridden by
	// any more specific configuration value.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
}

func (lhs *UseMultiplePathsConfig) Equal(rhs *UseMultiplePathsConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	return true
}

// struct for container bgp-mp:use-multiple-paths.
// Parameters related to the use of multiple paths for the
// same NLRI.
type UseMultiplePaths struct {
	// original -> bgp-mp:use-multiple-paths-config
	// Configuration parameters relating to multipath.
	Config UseMultiplePathsConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp-mp:use-multiple-paths-state
	// State parameters relating to multipath.
	State UseMultiplePathsState `mapstructure:"state" json:"state,omitempty"`
	// original -> bgp-mp:ebgp
	// Multipath parameters for eBGP.
	Ebgp Ebgp `mapstructure:"ebgp" json:"ebgp,omitempty"`
	// original -> bgp-mp:ibgp
	// Multipath parameters for iBGP.
	Ibgp Ibgp `mapstructure:"ibgp" json:"ibgp,omitempty"`
}

func (lhs *UseMultiplePaths) Equal(rhs *UseMultiplePaths) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	if !lhs.Ebgp.Equal(&(rhs.Ebgp)) {
		return false
	}
	if !lhs.Ibgp.Equal(&(rhs.Ibgp)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to the BGP confederations.
type ConfederationState struct {
	// original -> bgp:enabled
	// bgp:enabled's original type is boolean.
	// When this leaf is set to true it indicates that
	// the local-AS is part of a BGP confederation.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> bgp:identifier
	// bgp:identifier's original type is inet:as-number.
	// Confederation identifier for the autonomous system.
	Identifier uint32 `mapstructure:"identifier" json:"identifier,omitempty"`
	// original -> bgp:member-as
	// original type is list of inet:as-number
	// Remote autonomous systems that are to be treated
	// as part of the local confederation.
	MemberAsList []uint32 `mapstructure:"member-as-list" json:"member-as-list,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to BGP confederations.
type ConfederationConfig struct {
	// original -> bgp:enabled
	// bgp:enabled's original type is boolean.
	// When this leaf is set to true it indicates that
	// the local-AS is part of a BGP confederation.
	Enabled bool `mapstructure:"enabled" json:"enabled,omitempty"`
	// original -> bgp:identifier
	// bgp:identifier's original type is inet:as-number.
	// Confederation identifier for the autonomous system.
	Identifier uint32 `mapstructure:"identifier" json:"identifier,omitempty"`
	// original -> bgp:member-as
	// original type is list of inet:as-number
	// Remote autonomous systems that are to be treated
	// as part of the local confederation.
	MemberAsList []uint32 `mapstructure:"member-as-list" json:"member-as-list,omitempty"`
}

func (lhs *ConfederationConfig) Equal(rhs *ConfederationConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.Identifier != rhs.Identifier {
		return false
	}
	if len(lhs.MemberAsList) != len(rhs.MemberAsList) {
		return false
	}
	for idx, l := range lhs.MemberAsList {
		if l != rhs.MemberAsList[idx] {
			return false
		}
	}
	return true
}

// struct for container bgp:confederation.
// Parameters indicating whether the local system acts as part
// of a BGP confederation.
type Confederation struct {
	// original -> bgp:confederation-config
	// Configuration parameters relating to BGP confederations.
	Config ConfederationConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:confederation-state
	// State information relating to the BGP confederations.
	State ConfederationState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *Confederation) Equal(rhs *Confederation) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to the default route distance.
type DefaultRouteDistanceState struct {
	// original -> bgp:external-route-distance
	// Administrative distance for routes learned from external
	// BGP (eBGP).
	ExternalRouteDistance uint8 `mapstructure:"external-route-distance" json:"external-route-distance,omitempty"`
	// original -> bgp:internal-route-distance
	// Administrative distance for routes learned from internal
	// BGP (iBGP).
	InternalRouteDistance uint8 `mapstructure:"internal-route-distance" json:"internal-route-distance,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to the default route
// distance.
type DefaultRouteDistanceConfig struct {
	// original -> bgp:external-route-distance
	// Administrative distance for routes learned from external
	// BGP (eBGP).
	ExternalRouteDistance uint8 `mapstructure:"external-route-distance" json:"external-route-distance,omitempty"`
	// original -> bgp:internal-route-distance
	// Administrative distance for routes learned from internal
	// BGP (iBGP).
	InternalRouteDistance uint8 `mapstructure:"internal-route-distance" json:"internal-route-distance,omitempty"`
}

func (lhs *DefaultRouteDistanceConfig) Equal(rhs *DefaultRouteDistanceConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.ExternalRouteDistance != rhs.ExternalRouteDistance {
		return false
	}
	if lhs.InternalRouteDistance != rhs.InternalRouteDistance {
		return false
	}
	return true
}

// struct for container bgp:default-route-distance.
// Administrative distance (or preference) assigned to
// routes received from different sources
// (external, internal, and local).
type DefaultRouteDistance struct {
	// original -> bgp:default-route-distance-config
	// Configuration parameters relating to the default route
	// distance.
	Config DefaultRouteDistanceConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:default-route-distance-state
	// State information relating to the default route distance.
	State DefaultRouteDistanceState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *DefaultRouteDistance) Equal(rhs *DefaultRouteDistance) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp-mp:state.
// State information for the route selection options.
type RouteSelectionOptionsState struct {
	// original -> bgp-mp:always-compare-med
	// bgp-mp:always-compare-med's original type is boolean.
	// Compare multi-exit discriminator (MED) value from
	// different ASes when selecting the best route.  The
	// default behavior is to only compare MEDs for paths
	// received from the same AS.
	AlwaysCompareMed bool `mapstructure:"always-compare-med" json:"always-compare-med,omitempty"`
	// original -> bgp-mp:ignore-as-path-length
	// bgp-mp:ignore-as-path-length's original type is boolean.
	// Ignore the AS path length when selecting the best path.
	// The default is to use the AS path length and prefer paths
	// with shorter length.
	IgnoreAsPathLength bool `mapstructure:"ignore-as-path-length" json:"ignore-as-path-length,omitempty"`
	// original -> bgp-mp:external-compare-router-id
	// bgp-mp:external-compare-router-id's original type is boolean.
	// When comparing similar routes received from external
	// BGP peers, use the router-id as a criterion to select
	// the active path.
	ExternalCompareRouterId bool `mapstructure:"external-compare-router-id" json:"external-compare-router-id,omitempty"`
	// original -> bgp-mp:advertise-inactive-routes
	// bgp-mp:advertise-inactive-routes's original type is boolean.
	// Advertise inactive routes to external peers.  The
	// default is to only advertise active routes.
	AdvertiseInactiveRoutes bool `mapstructure:"advertise-inactive-routes" json:"advertise-inactive-routes,omitempty"`
	// original -> bgp-mp:enable-aigp
	// bgp-mp:enable-aigp's original type is boolean.
	// Flag to enable sending / receiving accumulated IGP
	// attribute in routing updates.
	EnableAigp bool `mapstructure:"enable-aigp" json:"enable-aigp,omitempty"`
	// original -> bgp-mp:ignore-next-hop-igp-metric
	// bgp-mp:ignore-next-hop-igp-metric's original type is boolean.
	// Ignore the IGP metric to the next-hop when calculating
	// BGP best-path. The default is to select the route for
	// which the metric to the next-hop is lowest.
	IgnoreNextHopIgpMetric bool `mapstructure:"ignore-next-hop-igp-metric" json:"ignore-next-hop-igp-metric,omitempty"`
	// original -> gobgp:disable-best-path-selection
	// gobgp:disable-best-path-selection's original type is boolean.
	// Disables best path selection process.
	DisableBestPathSelection bool `mapstructure:"disable-best-path-selection" json:"disable-best-path-selection,omitempty"`
}

// struct for container bgp-mp:config.
// Configuration parameters relating to route selection
// options.
type RouteSelectionOptionsConfig struct {
	// original -> bgp-mp:always-compare-med
	// bgp-mp:always-compare-med's original type is boolean.
	// Compare multi-exit discriminator (MED) value from
	// different ASes when selecting the best route.  The
	// default behavior is to only compare MEDs for paths
	// received from the same AS.
	AlwaysCompareMed bool `mapstructure:"always-compare-med" json:"always-compare-med,omitempty"`
	// original -> bgp-mp:ignore-as-path-length
	// bgp-mp:ignore-as-path-length's original type is boolean.
	// Ignore the AS path length when selecting the best path.
	// The default is to use the AS path length and prefer paths
	// with shorter length.
	IgnoreAsPathLength bool `mapstructure:"ignore-as-path-length" json:"ignore-as-path-length,omitempty"`
	// original -> bgp-mp:external-compare-router-id
	// bgp-mp:external-compare-router-id's original type is boolean.
	// When comparing similar routes received from external
	// BGP peers, use the router-id as a criterion to select
	// the active path.
	ExternalCompareRouterId bool `mapstructure:"external-compare-router-id" json:"external-compare-router-id,omitempty"`
	// original -> bgp-mp:advertise-inactive-routes
	// bgp-mp:advertise-inactive-routes's original type is boolean.
	// Advertise inactive routes to external peers.  The
	// default is to only advertise active routes.
	AdvertiseInactiveRoutes bool `mapstructure:"advertise-inactive-routes" json:"advertise-inactive-routes,omitempty"`
	// original -> bgp-mp:enable-aigp
	// bgp-mp:enable-aigp's original type is boolean.
	// Flag to enable sending / receiving accumulated IGP
	// attribute in routing updates.
	EnableAigp bool `mapstructure:"enable-aigp" json:"enable-aigp,omitempty"`
	// original -> bgp-mp:ignore-next-hop-igp-metric
	// bgp-mp:ignore-next-hop-igp-metric's original type is boolean.
	// Ignore the IGP metric to the next-hop when calculating
	// BGP best-path. The default is to select the route for
	// which the metric to the next-hop is lowest.
	IgnoreNextHopIgpMetric bool `mapstructure:"ignore-next-hop-igp-metric" json:"ignore-next-hop-igp-metric,omitempty"`
	// original -> gobgp:disable-best-path-selection
	// gobgp:disable-best-path-selection's original type is boolean.
	// Disables best path selection process.
	DisableBestPathSelection bool `mapstructure:"disable-best-path-selection" json:"disable-best-path-selection,omitempty"`
}

func (lhs *RouteSelectionOptionsConfig) Equal(rhs *RouteSelectionOptionsConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AlwaysCompareMed != rhs.AlwaysCompareMed {
		return false
	}
	if lhs.IgnoreAsPathLength != rhs.IgnoreAsPathLength {
		return false
	}
	if lhs.ExternalCompareRouterId != rhs.ExternalCompareRouterId {
		return false
	}
	if lhs.AdvertiseInactiveRoutes != rhs.AdvertiseInactiveRoutes {
		return false
	}
	if lhs.EnableAigp != rhs.EnableAigp {
		return false
	}
	if lhs.IgnoreNextHopIgpMetric != rhs.IgnoreNextHopIgpMetric {
		return false
	}
	if lhs.DisableBestPathSelection != rhs.DisableBestPathSelection {
		return false
	}
	return true
}

// struct for container bgp-mp:route-selection-options.
// Parameters relating to options for route selection.
type RouteSelectionOptions struct {
	// original -> bgp-mp:route-selection-options-config
	// Configuration parameters relating to route selection
	// options.
	Config RouteSelectionOptionsConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp-mp:route-selection-options-state
	// State information for the route selection options.
	State RouteSelectionOptionsState `mapstructure:"state" json:"state,omitempty"`
}

func (lhs *RouteSelectionOptions) Equal(rhs *RouteSelectionOptions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

// struct for container bgp:state.
// State information relating to the global BGP router.
type GlobalState struct {
	// original -> bgp:as
	// bgp:as's original type is inet:as-number.
	// Local autonomous system number of the router.  Uses
	// the 32-bit as-number type from the model in RFC 6991.
	As uint32 `mapstructure:"as" json:"as,omitempty"`
	// original -> bgp:router-id
	// bgp:router-id's original type is inet:ipv4-address.
	// Router id of the router, expressed as an
	// 32-bit value, IPv4 address.
	RouterId string `mapstructure:"router-id" json:"router-id,omitempty"`
	// original -> bgp-op:total-paths
	// Total number of BGP paths within the context.
	TotalPaths uint32 `mapstructure:"total-paths" json:"total-paths,omitempty"`
	// original -> bgp-op:total-prefixes
	// .
	TotalPrefixes uint32 `mapstructure:"total-prefixes" json:"total-prefixes,omitempty"`
	// original -> gobgp:port
	Port int32 `mapstructure:"port" json:"port,omitempty"`
	// original -> gobgp:local-address
	LocalAddressList []string `mapstructure:"local-address-list" json:"local-address-list,omitempty"`
}

// struct for container bgp:config.
// Configuration parameters relating to the global BGP router.
type GlobalConfig struct {
	// original -> bgp:as
	// bgp:as's original type is inet:as-number.
	// Local autonomous system number of the router.  Uses
	// the 32-bit as-number type from the model in RFC 6991.
	As uint32 `mapstructure:"as" json:"as,omitempty"`
	// original -> bgp:router-id
	// bgp:router-id's original type is inet:ipv4-address.
	// Router id of the router, expressed as an
	// 32-bit value, IPv4 address.
	RouterId string `mapstructure:"router-id" json:"router-id,omitempty"`
	// original -> gobgp:port
	Port int32 `mapstructure:"port" json:"port,omitempty"`
	// original -> gobgp:local-address
	LocalAddressList []string `mapstructure:"local-address-list" json:"local-address-list,omitempty"`
}

func (lhs *GlobalConfig) Equal(rhs *GlobalConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.As != rhs.As {
		return false
	}
	if lhs.RouterId != rhs.RouterId {
		return false
	}
	if lhs.Port != rhs.Port {
		return false
	}
	if len(lhs.LocalAddressList) != len(rhs.LocalAddressList) {
		return false
	}
	for idx, l := range lhs.LocalAddressList {
		if l != rhs.LocalAddressList[idx] {
			return false
		}
	}
	return true
}

// struct for container bgp:global.
// Global configuration for the BGP router.
type Global struct {
	// original -> bgp:global-config
	// Configuration parameters relating to the global BGP router.
	Config GlobalConfig `mapstructure:"config" json:"config,omitempty"`
	// original -> bgp:global-state
	// State information relating to the global BGP router.
	State GlobalState `mapstructure:"state" json:"state,omitempty"`
	// original -> bgp-mp:route-selection-options
	// Parameters relating to options for route selection.
	RouteSelectionOptions RouteSelectionOptions `mapstructure:"route-selection-options" json:"route-selection-options,omitempty"`
	// original -> bgp:default-route-distance
	// Administrative distance (or preference) assigned to
	// routes received from different sources
	// (external, internal, and local).
	DefaultRouteDistance DefaultRouteDistance `mapstructure:"default-route-distance" json:"default-route-distance,omitempty"`
	// original -> bgp:confederation
	// Parameters indicating whether the local system acts as part
	// of a BGP confederation.
	Confederation Confederation `mapstructure:"confederation" json:"confederation,omitempty"`
	// original -> bgp-mp:use-multiple-paths
	// Parameters related to the use of multiple paths for the
	// same NLRI.
	UseMultiplePaths UseMultiplePaths `mapstructure:"use-multiple-paths" json:"use-multiple-paths,omitempty"`
	// original -> bgp:graceful-restart
	// Parameters relating the graceful restart mechanism for BGP.
	GracefulRestart GracefulRestart `mapstructure:"graceful-restart" json:"graceful-restart,omitempty"`
	// original -> bgp:afi-safis
	// Address family specific configuration.
	AfiSafis []AfiSafi `mapstructure:"afi-safis" json:"afi-safis,omitempty"`
	// original -> rpol:apply-policy
	// Anchor point for routing policies in the model.
	// Import and export policies are with respect to the local
	// routing table, i.e., export (send) and import (receive),
	// depending on the context.
	ApplyPolicy ApplyPolicy `mapstructure:"apply-policy" json:"apply-policy,omitempty"`
}

func (lhs *Global) Equal(rhs *Global) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	if !lhs.RouteSelectionOptions.Equal(&(rhs.RouteSelectionOptions)) {
		return false
	}
	if !lhs.DefaultRouteDistance.Equal(&(rhs.DefaultRouteDistance)) {
		return false
	}
	if !lhs.Confederation.Equal(&(rhs.Confederation)) {
		return false
	}
	if !lhs.UseMultiplePaths.Equal(&(rhs.UseMultiplePaths)) {
		return false
	}
	if !lhs.GracefulRestart.Equal(&(rhs.GracefulRestart)) {
		return false
	}
	if len(lhs.AfiSafis) != len(rhs.AfiSafis) {
		return false
	}
	{
		lmap := make(map[string]*AfiSafi)
		for i, l := range lhs.AfiSafis {
			lmap[mapkey(i, string(l.Config.AfiSafiName))] = &lhs.AfiSafis[i]
		}
		for i, r := range rhs.AfiSafis {
			if l, y := lmap[mapkey(i, string(r.Config.AfiSafiName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if !lhs.ApplyPolicy.Equal(&(rhs.ApplyPolicy)) {
		return false
	}
	return true
}

// struct for container bgp:bgp.
// Top-level configuration and state for the BGP router.
type Bgp struct {
	// original -> bgp:global
	// Global configuration for the BGP router.
	Global Global `mapstructure:"global" json:"global,omitempty"`
	// original -> bgp:neighbors
	// Configuration for BGP neighbors.
	Neighbors []Neighbor `mapstructure:"neighbors" json:"neighbors,omitempty"`
	// original -> bgp:peer-groups
	// Configuration for BGP peer-groups.
	PeerGroups []PeerGroup `mapstructure:"peer-groups" json:"peer-groups,omitempty"`
	// original -> gobgp:rpki-servers
	RpkiServers []RpkiServer `mapstructure:"rpki-servers" json:"rpki-servers,omitempty"`
	// original -> gobgp:bmp-servers
	BmpServers []BmpServer `mapstructure:"bmp-servers" json:"bmp-servers,omitempty"`
	// original -> gobgp:vrfs
	Vrfs []Vrf `mapstructure:"vrfs" json:"vrfs,omitempty"`
	// original -> gobgp:mrt-dump
	MrtDump []Mrt `mapstructure:"mrt-dump" json:"mrt-dump,omitempty"`
	// original -> gobgp:zebra
	Zebra Zebra `mapstructure:"zebra" json:"zebra,omitempty"`
	// original -> gobgp:collector
	Collector Collector `mapstructure:"collector" json:"collector,omitempty"`
	// original -> gobgp:dynamic-neighbors
	DynamicNeighbors []DynamicNeighbor `mapstructure:"dynamic-neighbors" json:"dynamic-neighbors,omitempty"`
}

func (lhs *Bgp) Equal(rhs *Bgp) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Global.Equal(&(rhs.Global)) {
		return false
	}
	if len(lhs.Neighbors) != len(rhs.Neighbors) {
		return false
	}
	{
		lmap := make(map[string]*Neighbor)
		for i, l := range lhs.Neighbors {
			lmap[mapkey(i, string(l.Config.NeighborAddress))] = &lhs.Neighbors[i]
		}
		for i, r := range rhs.Neighbors {
			if l, y := lmap[mapkey(i, string(r.Config.NeighborAddress))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.PeerGroups) != len(rhs.PeerGroups) {
		return false
	}
	{
		lmap := make(map[string]*PeerGroup)
		for i, l := range lhs.PeerGroups {
			lmap[mapkey(i, string(l.Config.PeerGroupName))] = &lhs.PeerGroups[i]
		}
		for i, r := range rhs.PeerGroups {
			if l, y := lmap[mapkey(i, string(r.Config.PeerGroupName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.RpkiServers) != len(rhs.RpkiServers) {
		return false
	}
	{
		lmap := make(map[string]*RpkiServer)
		for i, l := range lhs.RpkiServers {
			lmap[mapkey(i, string(l.Config.Address))] = &lhs.RpkiServers[i]
		}
		for i, r := range rhs.RpkiServers {
			if l, y := lmap[mapkey(i, string(r.Config.Address))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.BmpServers) != len(rhs.BmpServers) {
		return false
	}
	{
		lmap := make(map[string]*BmpServer)
		for i, l := range lhs.BmpServers {
			lmap[mapkey(i, string(l.Config.Address))] = &lhs.BmpServers[i]
		}
		for i, r := range rhs.BmpServers {
			if l, y := lmap[mapkey(i, string(r.Config.Address))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.Vrfs) != len(rhs.Vrfs) {
		return false
	}
	{
		lmap := make(map[string]*Vrf)
		for i, l := range lhs.Vrfs {
			lmap[mapkey(i, string(l.Config.Name))] = &lhs.Vrfs[i]
		}
		for i, r := range rhs.Vrfs {
			if l, y := lmap[mapkey(i, string(r.Config.Name))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.MrtDump) != len(rhs.MrtDump) {
		return false
	}
	{
		lmap := make(map[string]*Mrt)
		for i, l := range lhs.MrtDump {
			lmap[mapkey(i, string(l.Config.FileName))] = &lhs.MrtDump[i]
		}
		for i, r := range rhs.MrtDump {
			if l, y := lmap[mapkey(i, string(r.Config.FileName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if !lhs.Zebra.Equal(&(rhs.Zebra)) {
		return false
	}
	if !lhs.Collector.Equal(&(rhs.Collector)) {
		return false
	}
	if len(lhs.DynamicNeighbors) != len(rhs.DynamicNeighbors) {
		return false
	}
	{
		lmap := make(map[string]*DynamicNeighbor)
		for i, l := range lhs.DynamicNeighbors {
			lmap[mapkey(i, string(l.Config.Prefix))] = &lhs.DynamicNeighbors[i]
		}
		for i, r := range rhs.DynamicNeighbors {
			if l, y := lmap[mapkey(i, string(r.Config.Prefix))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}

// struct for container gobgp:set-large-community-method.
type SetLargeCommunityMethod struct {
	// original -> gobgp:communities
	CommunitiesList []string `mapstructure:"communities-list" json:"communities-list,omitempty"`
}

func (lhs *SetLargeCommunityMethod) Equal(rhs *SetLargeCommunityMethod) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.CommunitiesList) != len(rhs.CommunitiesList) {
		return false
	}
	for idx, l := range lhs.CommunitiesList {
		if l != rhs.CommunitiesList[idx] {
			return false
		}
	}
	return true
}

// struct for container gobgp:set-large-community.
type SetLargeCommunity struct {
	// original -> gobgp:set-large-community-method
	SetLargeCommunityMethod SetLargeCommunityMethod `mapstructure:"set-large-community-method" json:"set-large-community-method,omitempty"`
	// original -> gobgp:options
	Options BgpSetCommunityOptionType `mapstructure:"options" json:"options,omitempty"`
}

func (lhs *SetLargeCommunity) Equal(rhs *SetLargeCommunity) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.SetLargeCommunityMethod.Equal(&(rhs.SetLargeCommunityMethod)) {
		return false
	}
	if lhs.Options != rhs.Options {
		return false
	}
	return true
}

// struct for container bgp-pol:set-ext-community-method.
// Option to set communities using an inline list or
// reference to an existing defined set.
type SetExtCommunityMethod struct {
	// original -> bgp-pol:communities
	// original type is list of union
	// Set the community values for the update inline with
	// a list.
	CommunitiesList []string `mapstructure:"communities-list" json:"communities-list,omitempty"`
	// original -> bgp-pol:ext-community-set-ref
	// References a defined extended community set by
	// name.
	ExtCommunitySetRef string `mapstructure:"ext-community-set-ref" json:"ext-community-set-ref,omitempty"`
}

func (lhs *SetExtCommunityMethod) Equal(rhs *SetExtCommunityMethod) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.CommunitiesList) != len(rhs.CommunitiesList) {
		return false
	}
	for idx, l := range lhs.CommunitiesList {
		if l != rhs.CommunitiesList[idx] {
			return false
		}
	}
	if lhs.ExtCommunitySetRef != rhs.ExtCommunitySetRef {
		return false
	}
	return true
}

// struct for container bgp-pol:set-ext-community.
// Action to set the extended community attributes of the
// route, along with options to modify how the community is
// modified.
type SetExtCommunity struct {
	// original -> bgp-pol:set-ext-community-method
	// Option to set communities using an inline list or
	// reference to an existing defined set.
	SetExtCommunityMethod SetExtCommunityMethod `mapstructure:"set-ext-community-method" json:"set-ext-community-method,omitempty"`
	// original -> bgp-pol:options
	// bgp-pol:options's original type is bgp-set-community-option-type.
	// options for modifying the extended community
	// attribute with the specified values. These options
	// apply to both methods of setting the community
	// attribute.
	Options string `mapstructure:"options" json:"options,omitempty"`
}

func (lhs *SetExtCommunity) Equal(rhs *SetExtCommunity) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.SetExtCommunityMethod.Equal(&(rhs.SetExtCommunityMethod)) {
		return false
	}
	if lhs.Options != rhs.Options {
		return false
	}
	return true
}

// struct for container bgp-pol:set-community-method.
// Option to set communities using an inline list or
// reference to an existing defined set.
type SetCommunityMethod struct {
	// original -> bgp-pol:communities
	// original type is list of union
	// Set the community values for the update inline with
	// a list.
	CommunitiesList []string `mapstructure:"communities-list" json:"communities-list,omitempty"`
	// original -> bgp-pol:community-set-ref
	// References a defined community set by name.
	CommunitySetRef string `mapstructure:"community-set-ref" json:"community-set-ref,omitempty"`
}

func (lhs *SetCommunityMethod) Equal(rhs *SetCommunityMethod) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.CommunitiesList) != len(rhs.CommunitiesList) {
		return false
	}
	for idx, l := range lhs.CommunitiesList {
		if l != rhs.CommunitiesList[idx] {
			return false
		}
	}
	if lhs.CommunitySetRef != rhs.CommunitySetRef {
		return false
	}
	return true
}

// struct for container bgp-pol:set-community.
// action to set the community attributes of the route, along
// with options to modify how the community is modified.
type SetCommunity struct {
	// original -> bgp-pol:set-community-method
	// Option to set communities using an inline list or
	// reference to an existing defined set.
	SetCommunityMethod SetCommunityMethod `mapstructure:"set-community-method" json:"set-community-method,omitempty"`
	// original -> bgp-pol:options
	// bgp-pol:options's original type is bgp-set-community-option-type.
	// Options for modifying the community attribute with
	// the specified values.  These options apply to both
	// methods of setting the community attribute.
	Options string `mapstructure:"options" json:"options,omitempty"`
}

func (lhs *SetCommunity) Equal(rhs *SetCommunity) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.SetCommunityMethod.Equal(&(rhs.SetCommunityMethod)) {
		return false
	}
	if lhs.Options != rhs.Options {
		return false
	}
	return true
}

// struct for container bgp-pol:set-as-path-prepend.
// action to prepend local AS number to the AS-path a
// specified number of times.
type SetAsPathPrepend struct {
	// original -> bgp-pol:repeat-n
	// number of times to prepend the local AS
	// number.
	RepeatN uint8 `mapstructure:"repeat-n" json:"repeat-n,omitempty"`
	// original -> gobgp:as
	// gobgp:as's original type is union.
	// autonomous system number or 'last-as' which means
	// the leftmost as number in the AS-path to be prepended.
	As string `mapstructure:"as" json:"as,omitempty"`
}

func (lhs *SetAsPathPrepend) Equal(rhs *SetAsPathPrepend) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.RepeatN != rhs.RepeatN {
		return false
	}
	if lhs.As != rhs.As {
		return false
	}
	return true
}

// struct for container bgp-pol:bgp-actions.
// Definitions for policy action statements that
// change BGP-specific attributes of the route.
type BgpActions struct {
	// original -> bgp-pol:set-as-path-prepend
	// action to prepend local AS number to the AS-path a
	// specified number of times.
	SetAsPathPrepend SetAsPathPrepend `mapstructure:"set-as-path-prepend" json:"set-as-path-prepend,omitempty"`
	// original -> bgp-pol:set-community
	// action to set the community attributes of the route, along
	// with options to modify how the community is modified.
	SetCommunity SetCommunity `mapstructure:"set-community" json:"set-community,omitempty"`
	// original -> bgp-pol:set-ext-community
	// Action to set the extended community attributes of the
	// route, along with options to modify how the community is
	// modified.
	SetExtCommunity SetExtCommunity `mapstructure:"set-ext-community" json:"set-ext-community,omitempty"`
	// original -> bgp-pol:set-route-origin
	// set the origin attribute to the specified
	// value.
	SetRouteOrigin BgpOriginAttrType `mapstructure:"set-route-origin" json:"set-route-origin,omitempty"`
	// original -> bgp-pol:set-local-pref
	// set the local pref attribute on the route
	// update.
	SetLocalPref uint32 `mapstructure:"set-local-pref" json:"set-local-pref,omitempty"`
	// original -> bgp-pol:set-next-hop
	// set the next-hop attribute in the route update.
	SetNextHop BgpNextHopType `mapstructure:"set-next-hop" json:"set-next-hop,omitempty"`
	// original -> bgp-pol:set-med
	// set the med metric attribute in the route
	// update.
	SetMed BgpSetMedType `mapstructure:"set-med" json:"set-med,omitempty"`
	// original -> gobgp:set-large-community
	SetLargeCommunity SetLargeCommunity `mapstructure:"set-large-community" json:"set-large-community,omitempty"`
}

func (lhs *BgpActions) Equal(rhs *BgpActions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.SetAsPathPrepend.Equal(&(rhs.SetAsPathPrepend)) {
		return false
	}
	if !lhs.SetCommunity.Equal(&(rhs.SetCommunity)) {
		return false
	}
	if !lhs.SetExtCommunity.Equal(&(rhs.SetExtCommunity)) {
		return false
	}
	if lhs.SetRouteOrigin != rhs.SetRouteOrigin {
		return false
	}
	if lhs.SetLocalPref != rhs.SetLocalPref {
		return false
	}
	if lhs.SetNextHop != rhs.SetNextHop {
		return false
	}
	if lhs.SetMed != rhs.SetMed {
		return false
	}
	if !lhs.SetLargeCommunity.Equal(&(rhs.SetLargeCommunity)) {
		return false
	}
	return true
}

// struct for container rpol:igp-actions.
// Actions to set IGP route attributes; these actions
// apply to multiple IGPs.
type IgpActions struct {
	// original -> rpol:set-tag
	// Set the tag value for OSPF or IS-IS routes.
	SetTag TagType `mapstructure:"set-tag" json:"set-tag,omitempty"`
}

func (lhs *IgpActions) Equal(rhs *IgpActions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SetTag != rhs.SetTag {
		return false
	}
	return true
}

// struct for container rpol:actions.
// Action statements for this policy
// statement.
type Actions struct {
	// original -> rpol:route-disposition
	// Select the final disposition for the route, either
	// accept or reject.
	RouteDisposition RouteDisposition `mapstructure:"route-disposition" json:"route-disposition,omitempty"`
	// original -> rpol:igp-actions
	// Actions to set IGP route attributes; these actions
	// apply to multiple IGPs.
	IgpActions IgpActions `mapstructure:"igp-actions" json:"igp-actions,omitempty"`
	// original -> bgp-pol:bgp-actions
	// Definitions for policy action statements that
	// change BGP-specific attributes of the route.
	BgpActions BgpActions `mapstructure:"bgp-actions" json:"bgp-actions,omitempty"`
}

func (lhs *Actions) Equal(rhs *Actions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.RouteDisposition != rhs.RouteDisposition {
		return false
	}
	if !lhs.IgpActions.Equal(&(rhs.IgpActions)) {
		return false
	}
	if !lhs.BgpActions.Equal(&(rhs.BgpActions)) {
		return false
	}
	return true
}

// struct for container gobgp:match-large-community-set.
type MatchLargeCommunitySet struct {
	// original -> gobgp:large-community-set
	LargeCommunitySet string `mapstructure:"large-community-set" json:"large-community-set,omitempty"`
	// original -> rpol:match-set-options
	// Optional parameter that governs the behaviour of the
	// match operation.
	MatchSetOptions MatchSetOptionsType `mapstructure:"match-set-options" json:"match-set-options,omitempty"`
}

func (lhs *MatchLargeCommunitySet) Equal(rhs *MatchLargeCommunitySet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.LargeCommunitySet != rhs.LargeCommunitySet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

// struct for container bgp-pol:as-path-length.
// Value and comparison operations for conditions based on the
// length of the AS path in the route update.
type AsPathLength struct {
	// original -> ptypes:operator
	// type of comparison to be performed.
	Operator AttributeComparison `mapstructure:"operator" json:"operator,omitempty"`
	// original -> ptypes:value
	// value to compare with the community count.
	Value uint32 `mapstructure:"value" json:"value,omitempty"`
}

func (lhs *AsPathLength) Equal(rhs *AsPathLength) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Operator != rhs.Operator {
		return false
	}
	if lhs.Value != rhs.Value {
		return false
	}
	return true
}

// struct for container bgp-pol:community-count.
// Value and comparison operations for conditions based on the
// number of communities in the route update.
type CommunityCount struct {
	// original -> ptypes:operator
	// type of comparison to be performed.
	Operator AttributeComparison `mapstructure:"operator" json:"operator,omitempty"`
	// original -> ptypes:value
	// value to compare with the community count.
	Value uint32 `mapstructure:"value" json:"value,omitempty"`
}

func (lhs *CommunityCount) Equal(rhs *CommunityCount) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Operator != rhs.Operator {
		return false
	}
	if lhs.Value != rhs.Value {
		return false
	}
	return true
}

// struct for container bgp-pol:match-as-path-set.
// Match a referenced as-path set according to the logic
// defined in the match-set-options leaf.
type MatchAsPathSet struct {
	// original -> bgp-pol:as-path-set
	// References a defined AS path set.
	AsPathSet string `mapstructure:"as-path-set" json:"as-path-set,omitempty"`
	// original -> rpol:match-set-options
	// Optional parameter that governs the behaviour of the
	// match operation.
	MatchSetOptions MatchSetOptionsType `mapstructure:"match-set-options" json:"match-set-options,omitempty"`
}

func (lhs *MatchAsPathSet) Equal(rhs *MatchAsPathSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AsPathSet != rhs.AsPathSet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

// struct for container bgp-pol:match-ext-community-set.
// Match a referenced extended community-set according to the
// logic defined in the match-set-options leaf.
type MatchExtCommunitySet struct {
	// original -> bgp-pol:ext-community-set
	// References a defined extended community set.
	ExtCommunitySet string `mapstructure:"ext-community-set" json:"ext-community-set,omitempty"`
	// original -> rpol:match-set-options
	// Optional parameter that governs the behaviour of the
	// match operation.
	MatchSetOptions MatchSetOptionsType `mapstructure:"match-set-options" json:"match-set-options,omitempty"`
}

func (lhs *MatchExtCommunitySet) Equal(rhs *MatchExtCommunitySet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.ExtCommunitySet != rhs.ExtCommunitySet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

// struct for container bgp-pol:match-community-set.
// Match a referenced community-set according to the logic
// defined in the match-set-options leaf.
type MatchCommunitySet struct {
	// original -> bgp-pol:community-set
	// References a defined community set.
	CommunitySet string `mapstructure:"community-set" json:"community-set,omitempty"`
	// original -> rpol:match-set-options
	// Optional parameter that governs the behaviour of the
	// match operation.
	MatchSetOptions MatchSetOptionsType `mapstructure:"match-set-options" json:"match-set-options,omitempty"`
}

func (lhs *MatchCommunitySet) Equal(rhs *MatchCommunitySet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.CommunitySet != rhs.CommunitySet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

// struct for container bgp-pol:bgp-conditions.
// Policy conditions for matching
// BGP-specific defined sets or comparing BGP-specific
// attributes.
type BgpConditions struct {
	// original -> bgp-pol:match-community-set
	// Match a referenced community-set according to the logic
	// defined in the match-set-options leaf.
	MatchCommunitySet MatchCommunitySet `mapstructure:"match-community-set" json:"match-community-set,omitempty"`
	// original -> bgp-pol:match-ext-community-set
	// Match a referenced extended community-set according to the
	// logic defined in the match-set-options leaf.
	MatchExtCommunitySet MatchExtCommunitySet `mapstructure:"match-ext-community-set" json:"match-ext-community-set,omitempty"`
	// original -> bgp-pol:match-as-path-set
	// Match a referenced as-path set according to the logic
	// defined in the match-set-options leaf.
	MatchAsPathSet MatchAsPathSet `mapstructure:"match-as-path-set" json:"match-as-path-set,omitempty"`
	// original -> bgp-pol:med-eq
	// Condition to check if the received MED value is equal to
	// the specified value.
	MedEq uint32 `mapstructure:"med-eq" json:"med-eq,omitempty"`
	// original -> bgp-pol:origin-eq
	// Condition to check if the route origin is equal to the
	// specified value.
	OriginEq BgpOriginAttrType `mapstructure:"origin-eq" json:"origin-eq,omitempty"`
	// original -> bgp-pol:next-hop-in
	// original type is list of inet:ip-address
	// List of next hop addresses to check for in the route
	// update.
	NextHopInList []string `mapstructure:"next-hop-in-list" json:"next-hop-in-list,omitempty"`
	// original -> bgp-pol:afi-safi-in
	// List of address families which the NLRI may be
	// within.
	AfiSafiInList []AfiSafiType `mapstructure:"afi-safi-in-list" json:"afi-safi-in-list,omitempty"`
	// original -> bgp-pol:local-pref-eq
	// Condition to check if the local pref attribute is equal to
	// the specified value.
	LocalPrefEq uint32 `mapstructure:"local-pref-eq" json:"local-pref-eq,omitempty"`
	// original -> bgp-pol:community-count
	// Value and comparison operations for conditions based on the
	// number of communities in the route update.
	CommunityCount CommunityCount `mapstructure:"community-count" json:"community-count,omitempty"`
	// original -> bgp-pol:as-path-length
	// Value and comparison operations for conditions based on the
	// length of the AS path in the route update.
	AsPathLength AsPathLength `mapstructure:"as-path-length" json:"as-path-length,omitempty"`
	// original -> bgp-pol:route-type
	// Condition to check the route type in the route update.
	RouteType RouteType `mapstructure:"route-type" json:"route-type,omitempty"`
	// original -> gobgp:rpki-validation-result
	// specify the validation result of RPKI based on ROA as conditions.
	RpkiValidationResult RpkiValidationResultType `mapstructure:"rpki-validation-result" json:"rpki-validation-result,omitempty"`
	// original -> gobgp:match-large-community-set
	MatchLargeCommunitySet MatchLargeCommunitySet `mapstructure:"match-large-community-set" json:"match-large-community-set,omitempty"`
}

func (lhs *BgpConditions) Equal(rhs *BgpConditions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.MatchCommunitySet.Equal(&(rhs.MatchCommunitySet)) {
		return false
	}
	if !lhs.MatchExtCommunitySet.Equal(&(rhs.MatchExtCommunitySet)) {
		return false
	}
	if !lhs.MatchAsPathSet.Equal(&(rhs.MatchAsPathSet)) {
		return false
	}
	if lhs.MedEq != rhs.MedEq {
		return false
	}
	if lhs.OriginEq != rhs.OriginEq {
		return false
	}
	if len(lhs.NextHopInList) != len(rhs.NextHopInList) {
		return false
	}
	for idx, l := range lhs.NextHopInList {
		if l != rhs.NextHopInList[idx] {
			return false
		}
	}
	if len(lhs.AfiSafiInList) != len(rhs.AfiSafiInList) {
		return false
	}
	for idx, l := range lhs.AfiSafiInList {
		if l != rhs.AfiSafiInList[idx] {
			return false
		}
	}
	if lhs.LocalPrefEq != rhs.LocalPrefEq {
		return false
	}
	if !lhs.CommunityCount.Equal(&(rhs.CommunityCount)) {
		return false
	}
	if !lhs.AsPathLength.Equal(&(rhs.AsPathLength)) {
		return false
	}
	if lhs.RouteType != rhs.RouteType {
		return false
	}
	if lhs.RpkiValidationResult != rhs.RpkiValidationResult {
		return false
	}
	if !lhs.MatchLargeCommunitySet.Equal(&(rhs.MatchLargeCommunitySet)) {
		return false
	}
	return true
}

// struct for container rpol:igp-conditions.
// Policy conditions for IGP attributes.
type IgpConditions struct {
}

func (lhs *IgpConditions) Equal(rhs *IgpConditions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	return true
}

// struct for container rpol:match-tag-set.
// Match a referenced tag set according to the logic defined
// in the match-options-set leaf.
type MatchTagSet struct {
	// original -> rpol:tag-set
	// References a defined tag set.
	TagSet string `mapstructure:"tag-set" json:"tag-set,omitempty"`
	// original -> rpol:match-set-options
	// Optional parameter that governs the behaviour of the
	// match operation.  This leaf only supports matching on ANY
	// member of the set or inverting the match.  Matching on ALL is
	// not supported).
	MatchSetOptions MatchSetOptionsRestrictedType `mapstructure:"match-set-options" json:"match-set-options,omitempty"`
}

func (lhs *MatchTagSet) Equal(rhs *MatchTagSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.TagSet != rhs.TagSet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

// struct for container rpol:match-neighbor-set.
// Match a referenced neighbor set according to the logic
// defined in the match-set-options-leaf.
type MatchNeighborSet struct {
	// original -> rpol:neighbor-set
	// References a defined neighbor set.
	NeighborSet string `mapstructure:"neighbor-set" json:"neighbor-set,omitempty"`
	// original -> rpol:match-set-options
	// Optional parameter that governs the behaviour of the
	// match operation.  This leaf only supports matching on ANY
	// member of the set or inverting the match.  Matching on ALL is
	// not supported).
	MatchSetOptions MatchSetOptionsRestrictedType `mapstructure:"match-set-options" json:"match-set-options,omitempty"`
}

func (lhs *MatchNeighborSet) Equal(rhs *MatchNeighborSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.NeighborSet != rhs.NeighborSet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

// struct for container rpol:match-prefix-set.
// Match a referenced prefix-set according to the logic
// defined in the match-set-options leaf.
type MatchPrefixSet struct {
	// original -> rpol:prefix-set
	// References a defined prefix set.
	PrefixSet string `mapstructure:"prefix-set" json:"prefix-set,omitempty"`
	// original -> rpol:match-set-options
	// Optional parameter that governs the behaviour of the
	// match operation.  This leaf only supports matching on ANY
	// member of the set or inverting the match.  Matching on ALL is
	// not supported).
	MatchSetOptions MatchSetOptionsRestrictedType `mapstructure:"match-set-options" json:"match-set-options,omitempty"`
}

func (lhs *MatchPrefixSet) Equal(rhs *MatchPrefixSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.PrefixSet != rhs.PrefixSet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

// struct for container rpol:conditions.
// Condition statements for this
// policy statement.
type Conditions struct {
	// original -> rpol:call-policy
	// Applies the statements from the specified policy
	// definition and then returns control the current
	// policy statement. Note that the called policy may
	// itself call other policies (subject to
	// implementation limitations). This is intended to
	// provide a policy 'subroutine' capability.  The
	// called policy should contain an explicit or a
	// default route disposition that returns an
	// effective true (accept-route) or false
	// (reject-route), otherwise the behavior may be
	// ambiguous and implementation dependent.
	CallPolicy string `mapstructure:"call-policy" json:"call-policy,omitempty"`
	// original -> rpol:match-prefix-set
	// Match a referenced prefix-set according to the logic
	// defined in the match-set-options leaf.
	MatchPrefixSet MatchPrefixSet `mapstructure:"match-prefix-set" json:"match-prefix-set,omitempty"`
	// original -> rpol:match-neighbor-set
	// Match a referenced neighbor set according to the logic
	// defined in the match-set-options-leaf.
	MatchNeighborSet MatchNeighborSet `mapstructure:"match-neighbor-set" json:"match-neighbor-set,omitempty"`
	// original -> rpol:match-tag-set
	// Match a referenced tag set according to the logic defined
	// in the match-options-set leaf.
	MatchTagSet MatchTagSet `mapstructure:"match-tag-set" json:"match-tag-set,omitempty"`
	// original -> rpol:install-protocol-eq
	// Condition to check the protocol / method used to install
	// which installed the route into the local routing table.
	InstallProtocolEq InstallProtocolType `mapstructure:"install-protocol-eq" json:"install-protocol-eq,omitempty"`
	// original -> rpol:igp-conditions
	// Policy conditions for IGP attributes.
	IgpConditions IgpConditions `mapstructure:"igp-conditions" json:"igp-conditions,omitempty"`
	// original -> bgp-pol:bgp-conditions
	// Policy conditions for matching
	// BGP-specific defined sets or comparing BGP-specific
	// attributes.
	BgpConditions BgpConditions `mapstructure:"bgp-conditions" json:"bgp-conditions,omitempty"`
}

func (lhs *Conditions) Equal(rhs *Conditions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.CallPolicy != rhs.CallPolicy {
		return false
	}
	if !lhs.MatchPrefixSet.Equal(&(rhs.MatchPrefixSet)) {
		return false
	}
	if !lhs.MatchNeighborSet.Equal(&(rhs.MatchNeighborSet)) {
		return false
	}
	if !lhs.MatchTagSet.Equal(&(rhs.MatchTagSet)) {
		return false
	}
	if lhs.InstallProtocolEq != rhs.InstallProtocolEq {
		return false
	}
	if !lhs.IgpConditions.Equal(&(rhs.IgpConditions)) {
		return false
	}
	if !lhs.BgpConditions.Equal(&(rhs.BgpConditions)) {
		return false
	}
	return true
}

// struct for container rpol:statement.
// Policy statements group conditions and actions
// within a policy definition.  They are evaluated in
// the order specified (see the description of policy
// evaluation at the top of this module.
type Statement struct {
	// original -> rpol:name
	// name of the policy statement.
	Name string `mapstructure:"name" json:"name,omitempty"`
	// original -> rpol:conditions
	// Condition statements for this
	// policy statement.
	Conditions Conditions `mapstructure:"conditions" json:"conditions,omitempty"`
	// original -> rpol:actions
	// Action statements for this policy
	// statement.
	Actions Actions `mapstructure:"actions" json:"actions,omitempty"`
}

func (lhs *Statement) Equal(rhs *Statement) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Name != rhs.Name {
		return false
	}
	if !lhs.Conditions.Equal(&(rhs.Conditions)) {
		return false
	}
	if !lhs.Actions.Equal(&(rhs.Actions)) {
		return false
	}
	return true
}

// struct for container rpol:policy-definition.
// List of top-level policy definitions, keyed by unique
// name.  These policy definitions are expected to be
// referenced (by name) in policy chains specified in import
// or export configuration statements.
type PolicyDefinition struct {
	// original -> rpol:name
	// Name of the top-level policy definition -- this name
	//  is used in references to the current policy.
	Name string `mapstructure:"name" json:"name,omitempty"`
	// original -> rpol:statements
	// Enclosing container for policy statements.
	Statements []Statement `mapstructure:"statements" json:"statements,omitempty"`
}

func (lhs *PolicyDefinition) Equal(rhs *PolicyDefinition) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Name != rhs.Name {
		return false
	}
	if len(lhs.Statements) != len(rhs.Statements) {
		return false
	}
	{
		lmap := make(map[string]*Statement)
		for i, l := range lhs.Statements {
			lmap[mapkey(i, string(l.Name))] = &lhs.Statements[i]
		}
		for i, r := range rhs.Statements {
			if l, y := lmap[mapkey(i, string(r.Name))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}

// struct for container gobgp:large-community-set.
type LargeCommunitySet struct {
	// original -> gobgp:large-community-set-name
	LargeCommunitySetName string `mapstructure:"large-community-set-name" json:"large-community-set-name,omitempty"`
	// original -> gobgp:large-community
	// extended community set member.
	LargeCommunityList []string `mapstructure:"large-community-list" json:"large-community-list,omitempty"`
}

func (lhs *LargeCommunitySet) Equal(rhs *LargeCommunitySet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.LargeCommunitySetName != rhs.LargeCommunitySetName {
		return false
	}
	if len(lhs.LargeCommunityList) != len(rhs.LargeCommunityList) {
		return false
	}
	for idx, l := range lhs.LargeCommunityList {
		if l != rhs.LargeCommunityList[idx] {
			return false
		}
	}
	return true
}

// struct for container bgp-pol:as-path-set.
// Definitions for AS path sets.
type AsPathSet struct {
	// original -> bgp-pol:as-path-set-name
	// name of the AS path set -- this is used to reference
	// the set in match conditions.
	AsPathSetName string `mapstructure:"as-path-set-name" json:"as-path-set-name,omitempty"`
	// original -> gobgp:as-path
	// AS path expression.
	AsPathList []string `mapstructure:"as-path-list" json:"as-path-list,omitempty"`
}

func (lhs *AsPathSet) Equal(rhs *AsPathSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AsPathSetName != rhs.AsPathSetName {
		return false
	}
	if len(lhs.AsPathList) != len(rhs.AsPathList) {
		return false
	}
	for idx, l := range lhs.AsPathList {
		if l != rhs.AsPathList[idx] {
			return false
		}
	}
	return true
}

// struct for container bgp-pol:ext-community-set.
// Definitions for extended community sets.
type ExtCommunitySet struct {
	// original -> bgp-pol:ext-community-set-name
	// name / label of the extended community set -- this is
	// used to reference the set in match conditions.
	ExtCommunitySetName string `mapstructure:"ext-community-set-name" json:"ext-community-set-name,omitempty"`
	// original -> gobgp:ext-community
	// extended community set member.
	ExtCommunityList []string `mapstructure:"ext-community-list" json:"ext-community-list,omitempty"`
}

func (lhs *ExtCommunitySet) Equal(rhs *ExtCommunitySet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.ExtCommunitySetName != rhs.ExtCommunitySetName {
		return false
	}
	if len(lhs.ExtCommunityList) != len(rhs.ExtCommunityList) {
		return false
	}
	for idx, l := range lhs.ExtCommunityList {
		if l != rhs.ExtCommunityList[idx] {
			return false
		}
	}
	return true
}

// struct for container bgp-pol:community-set.
// Definitions for community sets.
type CommunitySet struct {
	// original -> bgp-pol:community-set-name
	// name / label of the community set -- this is used to
	// reference the set in match conditions.
	CommunitySetName string `mapstructure:"community-set-name" json:"community-set-name,omitempty"`
	// original -> gobgp:community
	// community set member.
	CommunityList []string `mapstructure:"community-list" json:"community-list,omitempty"`
}

func (lhs *CommunitySet) Equal(rhs *CommunitySet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.CommunitySetName != rhs.CommunitySetName {
		return false
	}
	if len(lhs.CommunityList) != len(rhs.CommunityList) {
		return false
	}
	for idx, l := range lhs.CommunityList {
		if l != rhs.CommunityList[idx] {
			return false
		}
	}
	return true
}

// struct for container bgp-pol:bgp-defined-sets.
// BGP-related set definitions for policy match conditions.
type BgpDefinedSets struct {
	// original -> bgp-pol:community-sets
	// Enclosing container for community sets.
	CommunitySets []CommunitySet `mapstructure:"community-sets" json:"community-sets,omitempty"`
	// original -> bgp-pol:ext-community-sets
	// Enclosing container for extended community sets.
	ExtCommunitySets []ExtCommunitySet `mapstructure:"ext-community-sets" json:"ext-community-sets,omitempty"`
	// original -> bgp-pol:as-path-sets
	// Enclosing container for AS path sets.
	AsPathSets []AsPathSet `mapstructure:"as-path-sets" json:"as-path-sets,omitempty"`
	// original -> gobgp:large-community-sets
	LargeCommunitySets []LargeCommunitySet `mapstructure:"large-community-sets" json:"large-community-sets,omitempty"`
}

func (lhs *BgpDefinedSets) Equal(rhs *BgpDefinedSets) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.CommunitySets) != len(rhs.CommunitySets) {
		return false
	}
	{
		lmap := make(map[string]*CommunitySet)
		for i, l := range lhs.CommunitySets {
			lmap[mapkey(i, string(l.CommunitySetName))] = &lhs.CommunitySets[i]
		}
		for i, r := range rhs.CommunitySets {
			if l, y := lmap[mapkey(i, string(r.CommunitySetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.ExtCommunitySets) != len(rhs.ExtCommunitySets) {
		return false
	}
	{
		lmap := make(map[string]*ExtCommunitySet)
		for i, l := range lhs.ExtCommunitySets {
			lmap[mapkey(i, string(l.ExtCommunitySetName))] = &lhs.ExtCommunitySets[i]
		}
		for i, r := range rhs.ExtCommunitySets {
			if l, y := lmap[mapkey(i, string(r.ExtCommunitySetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.AsPathSets) != len(rhs.AsPathSets) {
		return false
	}
	{
		lmap := make(map[string]*AsPathSet)
		for i, l := range lhs.AsPathSets {
			lmap[mapkey(i, string(l.AsPathSetName))] = &lhs.AsPathSets[i]
		}
		for i, r := range rhs.AsPathSets {
			if l, y := lmap[mapkey(i, string(r.AsPathSetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.LargeCommunitySets) != len(rhs.LargeCommunitySets) {
		return false
	}
	{
		lmap := make(map[string]*LargeCommunitySet)
		for i, l := range lhs.LargeCommunitySets {
			lmap[mapkey(i, string(l.LargeCommunitySetName))] = &lhs.LargeCommunitySets[i]
		}
		for i, r := range rhs.LargeCommunitySets {
			if l, y := lmap[mapkey(i, string(r.LargeCommunitySetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}

// struct for container rpol:tag.
// list of tags that are part of the tag set.
type Tag struct {
	// original -> rpol:value
	// Value of the tag set member.
	Value TagType `mapstructure:"value" json:"value,omitempty"`
}

func (lhs *Tag) Equal(rhs *Tag) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Value != rhs.Value {
		return false
	}
	return true
}

// struct for container rpol:tag-set.
// Definitions for tag sets.
type TagSet struct {
	// original -> rpol:tag-set-name
	// name / label of the tag set -- this is used to reference
	// the set in match conditions.
	TagSetName string `mapstructure:"tag-set-name" json:"tag-set-name,omitempty"`
	// original -> rpol:tag
	// list of tags that are part of the tag set.
	TagList []Tag `mapstructure:"tag-list" json:"tag-list,omitempty"`
}

func (lhs *TagSet) Equal(rhs *TagSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.TagSetName != rhs.TagSetName {
		return false
	}
	if len(lhs.TagList) != len(rhs.TagList) {
		return false
	}
	{
		lmap := make(map[string]*Tag)
		for i, l := range lhs.TagList {
			lmap[mapkey(i, string(l.Value))] = &lhs.TagList[i]
		}
		for i, r := range rhs.TagList {
			if l, y := lmap[mapkey(i, string(r.Value))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}

// struct for container rpol:neighbor-set.
// Definitions for neighbor sets.
type NeighborSet struct {
	// original -> rpol:neighbor-set-name
	// name / label of the neighbor set -- this is used to
	// reference the set in match conditions.
	NeighborSetName string `mapstructure:"neighbor-set-name" json:"neighbor-set-name,omitempty"`
	// original -> gobgp:neighbor-info
	// original type is list of inet:ip-address
	// neighbor ip address or prefix.
	NeighborInfoList []string `mapstructure:"neighbor-info-list" json:"neighbor-info-list,omitempty"`
}

func (lhs *NeighborSet) Equal(rhs *NeighborSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.NeighborSetName != rhs.NeighborSetName {
		return false
	}
	if len(lhs.NeighborInfoList) != len(rhs.NeighborInfoList) {
		return false
	}
	for idx, l := range lhs.NeighborInfoList {
		if l != rhs.NeighborInfoList[idx] {
			return false
		}
	}
	return true
}

// struct for container rpol:prefix.
// List of prefix expressions that are part of the set.
type Prefix struct {
	// original -> rpol:ip-prefix
	// rpol:ip-prefix's original type is inet:ip-prefix.
	// The prefix member in CIDR notation -- while the
	// prefix may be either IPv4 or IPv6, most
	// implementations require all members of the prefix set
	// to be the same address family.  Mixing address types in
	// the same prefix set is likely to cause an error.
	IpPrefix string `mapstructure:"ip-prefix" json:"ip-prefix,omitempty"`
	// original -> rpol:masklength-range
	// Defines a range for the masklength, or 'exact' if
	// the prefix has an exact length.
	//
	// Example: 10.3.192.0/21 through 10.3.192.0/24 would be
	// expressed as prefix: 10.3.192.0/21,
	// masklength-range: 21..24.
	//
	// Example: 10.3.192.0/21 would be expressed as
	// prefix: 10.3.192.0/21,
	// masklength-range: exact.
	MasklengthRange string `mapstructure:"masklength-range" json:"masklength-range,omitempty"`
}

func (lhs *Prefix) Equal(rhs *Prefix) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.IpPrefix != rhs.IpPrefix {
		return false
	}
	if lhs.MasklengthRange != rhs.MasklengthRange {
		return false
	}
	return true
}

// struct for container rpol:prefix-set.
// List of the defined prefix sets.
type PrefixSet struct {
	// original -> rpol:prefix-set-name
	// name / label of the prefix set -- this is used to
	// reference the set in match conditions.
	PrefixSetName string `mapstructure:"prefix-set-name" json:"prefix-set-name,omitempty"`
	// original -> rpol:prefix
	// List of prefix expressions that are part of the set.
	PrefixList []Prefix `mapstructure:"prefix-list" json:"prefix-list,omitempty"`
}

func (lhs *PrefixSet) Equal(rhs *PrefixSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.PrefixSetName != rhs.PrefixSetName {
		return false
	}
	if len(lhs.PrefixList) != len(rhs.PrefixList) {
		return false
	}
	{
		lmap := make(map[string]*Prefix)
		for i, l := range lhs.PrefixList {
			lmap[mapkey(i, string(l.IpPrefix+l.MasklengthRange))] = &lhs.PrefixList[i]
		}
		for i, r := range rhs.PrefixList {
			if l, y := lmap[mapkey(i, string(r.IpPrefix+r.MasklengthRange))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}

// struct for container rpol:defined-sets.
// Predefined sets of attributes used in policy match
// statements.
type DefinedSets struct {
	// original -> rpol:prefix-sets
	// Enclosing container for defined prefix sets for matching.
	PrefixSets []PrefixSet `mapstructure:"prefix-sets" json:"prefix-sets,omitempty"`
	// original -> rpol:neighbor-sets
	// Enclosing container for defined neighbor sets for matching.
	NeighborSets []NeighborSet `mapstructure:"neighbor-sets" json:"neighbor-sets,omitempty"`
	// original -> rpol:tag-sets
	// Enclosing container for defined tag sets for matching.
	TagSets []TagSet `mapstructure:"tag-sets" json:"tag-sets,omitempty"`
	// original -> bgp-pol:bgp-defined-sets
	// BGP-related set definitions for policy match conditions.
	BgpDefinedSets BgpDefinedSets `mapstructure:"bgp-defined-sets" json:"bgp-defined-sets,omitempty"`
}

func (lhs *DefinedSets) Equal(rhs *DefinedSets) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.PrefixSets) != len(rhs.PrefixSets) {
		return false
	}
	{
		lmap := make(map[string]*PrefixSet)
		for i, l := range lhs.PrefixSets {
			lmap[mapkey(i, string(l.PrefixSetName))] = &lhs.PrefixSets[i]
		}
		for i, r := range rhs.PrefixSets {
			if l, y := lmap[mapkey(i, string(r.PrefixSetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.NeighborSets) != len(rhs.NeighborSets) {
		return false
	}
	{
		lmap := make(map[string]*NeighborSet)
		for i, l := range lhs.NeighborSets {
			lmap[mapkey(i, string(l.NeighborSetName))] = &lhs.NeighborSets[i]
		}
		for i, r := range rhs.NeighborSets {
			if l, y := lmap[mapkey(i, string(r.NeighborSetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.TagSets) != len(rhs.TagSets) {
		return false
	}
	{
		lmap := make(map[string]*TagSet)
		for i, l := range lhs.TagSets {
			lmap[mapkey(i, string(l.TagSetName))] = &lhs.TagSets[i]
		}
		for i, r := range rhs.TagSets {
			if l, y := lmap[mapkey(i, string(r.TagSetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if !lhs.BgpDefinedSets.Equal(&(rhs.BgpDefinedSets)) {
		return false
	}
	return true
}

// struct for container rpol:routing-policy.
// top-level container for all routing policy configuration.
type RoutingPolicy struct {
	// original -> rpol:defined-sets
	// Predefined sets of attributes used in policy match
	// statements.
	DefinedSets DefinedSets `mapstructure:"defined-sets" json:"defined-sets,omitempty"`
	// original -> rpol:policy-definitions
	// Enclosing container for the list of top-level policy
	// definitions.
	PolicyDefinitions []PolicyDefinition `mapstructure:"policy-definitions" json:"policy-definitions,omitempty"`
}

func (lhs *RoutingPolicy) Equal(rhs *RoutingPolicy) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.DefinedSets.Equal(&(rhs.DefinedSets)) {
		return false
	}
	if len(lhs.PolicyDefinitions) != len(rhs.PolicyDefinitions) {
		return false
	}
	{
		lmap := make(map[string]*PolicyDefinition)
		for i, l := range lhs.PolicyDefinitions {
			lmap[mapkey(i, string(l.Name))] = &lhs.PolicyDefinitions[i]
		}
		for i, r := range rhs.PolicyDefinitions {
			if l, y := lmap[mapkey(i, string(r.Name))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}
