#ifndef _MOVELIST_H
#define _MOVELIST_H
#include <qglobal.h>
#include <QListWidget>
#include "osl/state/simpleState.h"
#include "osl/stl/vector.h"

class MoveList : public QListWidget
{
Q_OBJECT
public:
  MoveList(QWidget *parent = 0);
  void setState(const osl::state::SimpleState& initialState,
		const osl::vector<osl::Move>& m,
		const osl::vector<int>& t,
		const osl::vector<QString>&);
  osl::Move getMove(unsigned int n) const;
  void pushMove(osl::Move move);
  int getTime(unsigned int n) const;
  size_t numMoves() const;
private:
  osl::SimpleState state;
  osl::vector<osl::Move> moves;
  osl::vector<int> timeList;
};

#endif // _MOVELIST_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
