% GRADLE(1) gradle 3.1 | Gradle Command Line Manual
% Gradle Depvelopers
% 19 September 2016

# NAME

gradle - A powerful build system for the JVM

# SYNOPSIS

**gradle** [_option..._] [_task..._]

# OPTIONS

## General options

-?, -h, --help
: Shows a help message.

-a, --no-rebuild
: Do not rebuild project dependencies.

--all
: Shows additional detail in the task listing. See "Listing tasks" in Gradle
  User Guide.

-b, --build-file
: Specifies the build file. See "Selecting which build to execute" in Gradle
  User Guide.

-c, --settings-file
: Specifies the settings file.

--console
: Specifies which type of console output to generate.

Set to **plain** to generate plain text only. This option disables all color and
other rich output in the console output.

Set to **auto** (the default) to enable color and other rich output in the
console output when the build process is attached to a console, or to generate
plain text only when not attached to a console.

Set to **rich** to enable color and other rich output in the console output,
regardless of whether the build process is not attached to a console. When not
attached to a console, the build output will use ANSI control characters to
generate the rich output.

--continue
: Continues task execution after a task failure.

--configure-on-demand (incubating)
: Only relevant projects are configured in this build run. This means faster
  builds for large multi-projects. See "Configuration on demand" in Gradle User
  Guide.

-D, --system-prop
: Sets a system property of the JVM, for example **-Dmyprop=myvalue**. See
  "Gradle properties and system properties" in Gradle User Guide.

-d, --debug
: Log in debug mode (includes normal stacktrace). See "Logging" in Gradle User
  Guide.

-g, --gradle-user-home
: Specifies the Gradle user home directory. The default is the **.gradle**
  directory in the user's home directory.

--gui
: Launches the Gradle GUI. See "Using the Gradle Graphical User Interface" in
  Gradle User Guide.

--include-build
: Run the build as a composite, including the specified build. See
  "Composite Builds" in Gradle User Guide.

-I, --init-script
: Specifies an initialization script. See "Initialization Scripts" in Gradle
  User Guide.

-i, --info
: Set log level to info. See "Logging" in Gradle User Guide.

-m, --dry-run
: Runs the build with all task actions disabled. See "Dry Run" in Gradle User
  Guide.

--offline
: Specifies that the build should operate without accessing network resources.
  See "Command line options to override caching" in Gradle User Guide.

-P, --project-prop
: Sets a project property of the root project, for example **-Pmyprop=myvalue**.
  See "Gradle properties and system properties" in Gradle User Guide.

-p, --project-dir
: Specifies the start directory for Gradle. Defaults to current directory. See
  "Selecting which build to execute" in Gradle User Guide.

--parallel (incubating)
: Build projects in parallel. Gradle will attempt to determine the optimal
  number of executor threads to use. This option should only be used with
  decoupled projects (see "Decoupled Projects" in Gradle User Guide).

--max-workers (incubating)
: Sets the maximum number of workers that Gradle may use. For example
  **--max-workers=3**. The default is the number of processors. This option
  replaces -**-parallel-threads** when used in conjunction with **--parallel**.

--profile
: Profiles build execution time and generates a report in the
  **buildDir/reports/profile** directory. See Section 4.6.8, "Profiling a
  build".

--project-cache-dir
: Specifies the project-specific cache directory. Default value is **.gradle**
  in the root project directory.

-q, --quiet
: Log errors only. See "Logging" in Gradle User Guide.

--recompile-scripts
: Forces scripts to be recompiled, bypassing caching.

--refresh-dependencies
: Refresh the state of dependencies. See "Command line options to override
  caching" in Gradle User Guide.

--rerun-tasks
: Specifies that any task optimization is ignored.

-S, --full-stacktrace
: Print out the full (very verbose) stacktrace for any exceptions. See "Logging"
  in Gradle User Guide.

-s, --stacktrace
: Print out the stacktrace also for user exceptions (e.g. compile error). See
  "Logging" in Gradle User Guide.

-t, --continuous (incubating)
: Enables continuous building - Gradle will automatically re-run when changes
  are detected.

-u, --no-search-upwards
: Don't search in parent directories for a **settings.gradle** file.

-v, --version
: Prints version info.

-x, --exclude-task
: Specifies a task to be excluded from execution. See "Excluding tasks" in
  Gradle User Guide.

The above information is printed to the console when you execute **gradle -h**.

## Deprecated options

--no-color
: Do not use color in the console output. This option has been replaced by the
  **--console** plain option.

--parallel-threads
: Build projects in parallel, using the specified number of executor threads.
  For example **--parallel-threads=3**. This option should only be used with
  decoupled projects (see "Decoupled Projects" in Gradle User Guide). This
  option has been replaced by **--max-workers**.

## Daemon options

The Chapter 6, "The Gradle Daemon" contains more information about the daemon.
For example it includes information how to turn on the daemon by default so that
you can avoid using **--daemon** all the time.

--daemon
: Uses the Gradle daemon to run the build. Starts the daemon if not running or
  existing daemon busy. Chapter 6, "The Gradle Daemon" contains more detailed
  information when new daemon processes are started.

--foreground
: Starts the Gradle daemon in the foreground. Useful for debugging or
  troubleshooting because you can easily monitor the build execution.

--no-daemon
: Do not use the Gradle daemon to run the build. Useful occasionally if you have
  configured Gradle to always run with the daemon by default.

--stop
: Stops the Gradle daemon if it is running. You can only stop daemons that were
  started with the Gradle version you use when running **--stop**.

## System properties

The following system properties are available for the **gradle** command. Note
that command-line options take precedence over system properties.

gradle.user.home
: Specifies the Gradle user home directory.

The Section 11.1, "Configuring the build environment via **gradle.properties**"
contains specific information about Gradle configuration available via system
properties.

## Environment variables

The following environment variables are available for the **gradle** command.
Note that command-line options and system properties take precedence over
environment variables.

GRADLE_OPTS
: Specifies command-line arguments to use to start the JVM. This can be useful
  for setting the system properties to use for running Gradle. For example you
  could set **GRADLE_OPTS="-Dorg.gradle.daemon=true"** to use the Gradle daemon
  without needing to use the **--daemon** option every time you run Gradle.
  Section 11.1, "Configuring the build environment via **gradle.properties**"
  contains more information about ways of configuring the daemon without using
  environmental variables, e.g. in more maintainable and explicit way.

GRADLE_USER_HOME
: Specifies the Gradle user home directory (which defaults to
  **USER_HOME/.gradle** if not set).

JAVA_HOME
: Specifies the JDK installation directory to use.

# SEE ALSO

https://docs.gradle.org/current/userguide/gradle_command_line.html