/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains interfaces for {@link com.gs.collections.api.multimap.Multimap}.
 * <p>
 *     A Multimap is a type of {@link java.util.Map} that can associate multiple values for keys.
 * </p>
 * <p>
 *      This package contains 3 interfaces:
 * <ul>
 *     <li>
 *         {@link com.gs.collections.api.multimap.Multimap} - a Read-only Multimap API.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.multimap.MutableMultimap} - a modifiable Multimap.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.multimap.ImmutableMultimap} - the non-modifiable equivalent interface to {@link com.gs.collections.api.multimap.MutableMultimap}.
 *     </li>
 * </ul>
 * </p>
 */
package com.gs.collections.api.multimap;
