/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1301, USA.
 */
#ifndef GF_NOTIFICATION_H
#define GF_NOTIFICATION_H

#define GF_NOTIFICATION(obj)	((GfNotification *)obj)

#define GF_NOTIFICATION_MASTER	"!master"
#define GF_NOTIFICATION_MIN		(16)
#define GF_NOTIFICATION_MAX		(512)

typedef struct _GfNotification		GfNotification;

#include <glib.h>
#include <gdk/gdk.h>

#include "gf_event_info.h"
#include "gf_item.h"
#include "gf_theme.h"

#include "account.h"
#include "blist.h"
#include "conversation.h"
#include "xmlnode.h"

G_BEGIN_DECLS

GfNotification *gf_notification_new(GfTheme *theme);
GfNotification *gf_notification_new_from_xmlnode(GfTheme *theme, xmlnode *node);
GfNotification *gf_notification_copy(GfNotification *notification);
xmlnode *gf_notification_to_xmlnode(GfNotification *notification);
void gf_notification_destroy(GfNotification *notification);

void gf_notification_set_type(GfNotification *notification, const gchar *type);
const gchar *gf_notification_get_type(GfNotification *notification);
void gf_notification_set_use_gtk(GfNotification *notification, gboolean value);
gboolean gf_notification_get_use_gtk(GfNotification *notification);
void gf_notification_set_background(GfNotification *notification, const gchar *background);
const gchar *gf_notification_get_background(GfNotification *notification);
void gf_notification_set_width(GfNotification *notification, gint width);
gint gf_notification_get_width(GfNotification *notification);
void gf_notification_set_height(GfNotification *notification, gint height);
gint gf_notification_get_height(GfNotification *notification);
void gf_notification_set_alias(GfNotification *notification, const gchar *alias);
const gchar *gf_notification_get_alias(const GfNotification *notification);

void gf_notification_add_item(GfNotification *notification, GfItem *item);
void gf_notification_remove_item(GfNotification *notification, GfItem *item);
GList *gf_notification_get_items(GfNotification *notification);

void gf_notifications_swap(GfNotification *notification1, GfNotification *notification2);
GList *gf_notifications_for_event(const gchar *type);
GfNotification *gf_notification_find_for_event(const gchar *type);
GfNotification *gf_notification_find_for_theme(GfTheme *theme, const gchar *n_type);
GdkPixbuf *gf_notification_render(GfNotification 
*notification, GfEventInfo *info);
GfTheme *gf_notification_get_theme(GfNotification *notification);

void gf_notifications_init();
void gf_notifications_uninit();

G_END_DECLS

#endif /* GF_NOTIFICATION_H */
