/* 
 * File: setupwidget.c
 *
 * GKrellM 2 Plugin to control XMMS2
 * Copyright (c) 2005-2008 Johannes Heimansberg
 *
 * requires GKrellM 2 and XMMS2
 *
 * Released under the GNU General Public License v2
 */
#include "setupwidget.h"

const char *setup_widget_get_ipc_path(SetupWidget *sw)
{
	return gtk_entry_get_text(GTK_ENTRY(sw->entry_ipc_path));
}

void setup_widget_set_ipc_path(SetupWidget *sw, char *path)
{
	gtk_entry_set_text(GTK_ENTRY(sw->entry_ipc_path), path);
}

void setup_widget_set_scroll_speed(SetupWidget *sw, int speed)
{
	gtk_range_set_value(GTK_RANGE(sw->hscale_scroll_speed), speed);
}

int setup_widget_get_scroll_speed(SetupWidget *sw)
{
	return gtk_range_get_value(GTK_RANGE(sw->hscale_scroll_speed));
}

void setup_widget_set_auto_reconnect(SetupWidget *sw, gboolean value)
{
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sw->checkbox_auto_reconnect), value);
}

gboolean setup_widget_get_auto_reconnect(SetupWidget *sw)
{
	return gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sw->checkbox_auto_reconnect));
}


GtkWidget *setup_widget_create(SetupWidget *sw)
{
	sw->box = gtk_vbox_new(FALSE, 3);
	sw->frame1 = gtk_frame_new("xmms2d settings");
	sw->frame2 = gtk_frame_new("gkrellxmms2 settings");
	gtk_box_pack_start(GTK_BOX(sw->box), sw->frame1, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(sw->box), sw->frame2, TRUE, TRUE, 0);

	/* xmms2d setup widgets */
	sw->table1 = gtk_table_new(1, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(sw->frame1), sw->table1);
	sw->label_ipc_path = gtk_label_new("xmms2d IPC path");
	gtk_table_attach(GTK_TABLE(sw->table1), sw->label_ipc_path, 0, 1, 0, 1, GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_FILL, 5, 5);
	sw->entry_ipc_path = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(sw->table1), sw->entry_ipc_path, 1, 2, 0, 1, GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 5, 5);

	/* gkrellxmms2 setup widgets */
	sw->table2 = gtk_table_new(3, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(sw->frame2), sw->table2);
	sw->checkbox_show_volume_slider = gtk_check_button_new_with_mnemonic("Show _volume slider");
	gtk_table_attach(GTK_TABLE(sw->table2), sw->checkbox_show_volume_slider, 0, 2, 0, 1, GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_FILL, 5, 5);
	sw->checkbox_auto_reconnect = gtk_check_button_new_with_mnemonic("Auto _reconnect");
	gtk_table_attach(GTK_TABLE(sw->table2), sw->checkbox_auto_reconnect, 0, 2, 2, 3, GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_FILL, 5, 5);
	sw->label_scroll_speed = gtk_label_new("Title scroll speed");
	gtk_table_attach(GTK_TABLE(sw->table2), sw->label_scroll_speed, 0, 1, 3, 4, GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_FILL, 5, 5);
	sw->hscale_scroll_speed = gtk_hscale_new_with_range(0, 5, 1);
	gtk_table_attach(GTK_TABLE(sw->table2), sw->hscale_scroll_speed, 1, 2, 3, 4, GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 5, 5);
	return sw->box;
}
