#------------------------------------------------------
#
#  This file contains interim functionality to detect the legacy form of options
#  and other variables (e.g. WITH_MPI instead of the preferred LIBGRIDXC_WITH_MPI).
#
message(STATUS "Only prefixed (e.g. LIBGRIDXC_WITH_MPI) variable names allowed")

foreach(opt
	WITH_MPI
	WITH_LIBXC
	WITH_GRID_SP
	BUILD_DOCS
)

   if( DEFINED ${opt} )
     if ( NOT DEFINED LIBGRIDXC_${opt})
       if (PROJECT_IS_TOP_LEVEL)
         message(FATAL_ERROR "Using deprecated ${opt} option variable instead of LIBGRIDXC_${opt}")
       else()
         message(WARNING "${opt} is a deprecated option name in Libgridxc. Define LIBGRIDXC_${opt} if needed")
       endif()
     else ()
      message(STATUS " >> Both the deprecated ${opt} option variable name and the new variable LIBGRIDXC_${opt} are set")
      message(STATUS "LIBGRIDXC_${opt}: ${LIBGRIDXC_${opt}}")
      message(WARNING " >> The new variable LIBGRIDXC_${opt} takes precedence")
     endif()
   endif()

endforeach()
