/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ParametersWidgetBase.h"

#include <QGridLayout>

#include "ParametersWidgetBase_p.h"
#include "Proxy_p.h"

using namespace QtShiva;

ParametersWidgetBase::ParametersWidgetBase( QWidget* _parent ) : QWidget( _parent ), d(new Private)
{
  d->self = this;
  d->selfLayout = new QGridLayout( this );
  d->selfLayout->setRowStretch( 1, 10 );
}

ParametersWidgetBase::~ParametersWidgetBase()
{
  delete d->parametrisation;
  delete d;
}

void ParametersWidgetBase::setParameter(const GTLCore::String& _name, const GTLCore::Value& _value)
{
  d->proxies[_name]->setValue(_value);
}

void ParametersWidgetBase::setParametrisation( Parametrisation* _parametrisation)
{
  delete d->parametrisation;
  d->parametrisation = _parametrisation;
  d->parametrisation->p = d;
}

#include "ParametersWidgetBase.moc"
