/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <stdio.h> 
#include <strings.h>
#include "Input.h"
#include "Metview.h"
#include <MvXApplication.h>


void Input::inputCB(XtPointer data,int*,XtInputId* id)
{
	Input* p = ((Input*)data);
	char buf[1024];

	if(fgets(buf,sizeof(buf),p->file_))
	{
		if(buf[0]) buf[strlen(buf)-1] = 0;
		p->ready(buf);
	}
	else 
		p->done(p->file_);
}

Input::Input():
	id_(0),
	file_(0)
{
}

Input::~Input()
{
	stop();
}

void Input::stop()
{
	if(file_)
	{
		XtRemoveInput(id_);
		file_ = 0;
	}
}

void Input::start(FILE* f)
{
	if(file_ == 0 && f != 0)
	{
		file_ = f;
		id_ = XtAppAddInput(MvXApplication::context(),fileno(f),
			XtPointer(XtInputReadMask),
			inputCB,this);
	}
}

