/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "Timeout.h"
#include "Metview.h"
#include <MvXApplication.h>


void Timeout::timeoutCB(XtPointer data,XtIntervalId* id)
{
	Timeout* t = (Timeout*)data;

	if(t->actived_) 
	{
		t->running_ = True;
		t->run();
		t->running_ = False;
	}

	if(t->actived_) 
		t->id_ = XtAppAddTimeOut(MvXApplication::context(),
			t->frequency_*1000,timeoutCB,t);
}

Timeout::Timeout(double frequency):
	actived_(False),
	frequency_(frequency),
	id_(0),
	running_(False)
{
}

Timeout::~Timeout()
{
	disable();
}

void Timeout::enable()
{
	if(!actived_ /*&& app_context*/)
	{
		id_      = XtAppAddTimeOut(MvXApplication::context(),
			frequency_*1000,timeoutCB,this);
		actived_ = True;
	}
}


void Timeout::disable()
{
	if(actived_ && id_)
	{
		XtRemoveTimeOut(id_);
		id_      = 0;
		actived_ = False;
	}
}

void Timeout::frequency(double n)
{
	frequency_ = n;
	if(!running_ && actived_)
	{
		disable();
		enable();
	}
}

void Timeout::drift(double n,double maximum)
{
	double x = frequency_ + n;
	if(x>maximum) x = maximum;
	frequency(x);
}
