/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <MvTemplates.h>

#include "uPlotBatchApp.h"
#include "PmContext.h"
#include "Root.h"

uPlotBatchApp::uPlotBatchApp(int& ac, char** av, const char* name) : 
   MvApplication(ac,av,name)
{
   // Install Resources
   //InstallResources();

   // Register this service
   registerTMvServe(*this,0);
}

uPlotBatchApp::~uPlotBatchApp()
{
}

// Serve Method
// called by MvTransaction to process the request
void
uPlotBatchApp::serve ( MvProtocol& proto, MvRequest& inRequest )
{
   // Create a new context, based on the input Request
   PmContext * context = new PmContext ( proto, inRequest );

   // Increment the reference counting
   context->Attach();

   // It is a new call, so it first needs to clean the previous structure
   Root::Instance().Clean();

   // Execute the context
   context->Execute();

   // Decrement the reference counting
   //FAMI092013: it was causing function TMvServe::callback to crash because
   // this function is called afterwards and it still needs the context object.
   //context->Detach();
}
