// 
// Wmp11Ids.cs
//  
// Author:
//       Scott Thomas <lunchtimemama@gmail.com>
// 
// Copyright (c) 2010 Scott Thomas
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

namespace Mono.Upnp.Dcp.MediaServer1.FileSystem.Wmp11
{
    // See NetCompat_WMP11.docx
    public static class Wmp11Ids
    {
        public const string Root = "0";
        public const string Music = "1";
        public const string AllMusic = "4";
        public const string MusicGenre = "5";
        public const string MusicArtist = "6";
        public const string MusicAlbum = "7";
        public const string MusicPlaylists = "F";
        public const string MusicFolders = "14";
        public const string MusicContributingArtists = "100";
        public const string MusicAlbumArtist = "107";
        public const string MusicComposer = "108";
        public const string MusicRating = "101";
        public const string MusicRating1Star = "102";
        public const string MusicRating2Star = "103";
        public const string MusicRating3Star = "104";
        public const string MusicRating4Star = "105";
        public const string MusicRating5Star = "106";
        public const string Video = "2";
        public const string AllVideo = "8";
        public const string VideoGenre = "9";
        public const string VideoActor = "A";
        public const string VideoSeries = "E";
        public const string VidePlaylist = "10";
        public const string VideoFolders = "15";
        public const string VideoRating = "200";
        public const string VideoRating1Star = "201";
        public const string VideoRating2Star = "202";
        public const string VideoRating3Star = "203";
        public const string VideoRating4Star = "204";
        public const string VideoRating5Star = "205";
        public const string Pictures = "3";
        public const string AllPictures = "B";
        public const string PicturesDateTaken = "C";
        public const string PicturesAlbums = "D";
        public const string PicturesKeywords = "D2";
        public const string PicturesPlaylist = "11";
        public const string PicturesFolders = "16";
        public const string PicturesRating = "300";
        public const string PicturesRating1Star = "301";
        public const string PicturesRating2Star = "302";
        public const string PicturesRating3Star = "303";
        public const string PicturesRating4Star = "304";
        public const string PicturesRating5Star = "305";
        public const string PicturesUnrated = "306";
        public const string Playlists = "12";
        public const string AllPlaylists = "13";
        public const string PlaylistsFolders = "17";
    }
}
