//
// ccsd_2t_r12_left.cc
//
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki.toru@gmail.com>
// Maintainer: TS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//
  
// This is a C++ code generated by SMITH
  
#include <algorithm>
#include <chemistry/qc/ccr12/ccsd_2t_r12_left.h>
#include <chemistry/qc/ccr12/parenthesis2tnum.h>
using namespace sc;
  
  
CCSD_2T_R12_LEFT::CCSD_2T_R12_LEFT(CCR12_Info* info):Parenthesis2tNum(info){};
  
  
  
void CCSD_2T_R12_LEFT::compute_amp(double* a_i0,const long t_h4b,const long t_h5b,const long t_h6b,const long t_p1b,const long t_p2b,const long t_p3b,const long toggle){
  
in.resize(8);
i1xn.resize(16);
  
if (toggle==2L) {
smith_0_1(a_i0,t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b);
}
if (toggle==1L) {
i1xn.at(0)=new Tensor("ccsd_2t_r12_left_1x0_0",z->mem());
offset_smith_0_2();
smith_0_2_0(); //z->f1()=>in.at(1x0)
smith_1_6(); //z->t1(),z->v2()=>in.at(1x0)
}
if (toggle==2L) {
smith_0_2(a_i0,t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b);
}
if (toggle==1L) {
i1xn.at(1)=new Tensor("ccsd_2t_r12_left_1x1_1",z->mem());
offset_smith_0_3();
smith_0_3_0(); //z->v2()=>in.at(1x1)
smith_1_7(); //z->t1(),z->v2()=>in.at(1x1)
}
if (toggle==2L) {
smith_0_3(a_i0,t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b);
}
if (toggle==2L) {
smith_0_4(a_i0,t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b);
}
if (toggle==2L) {
smith_0_5(a_i0,t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b);
}
if (toggle==1L) {
i1xn.at(2)=new Tensor("ccsd_2t_r12_left_1x2_8",z->mem());
offset_smith_0_8();
smith_1_8(); //z->t1(),z->lambda2()=>in.at(1x2)
}
if (toggle==2L) {
smith_0_8(a_i0,t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b);
}
if (toggle==3L) {
delete i1xn.at(2);
delete i1xn.at(1);
delete i1xn.at(0);
}
  
}
  
void CCSD_2T_R12_LEFT::smith_0_1(double* a_i0,const long t_h4b,const long t_h5b,const long t_h6b,const long t_p1b,const long t_p2b,const long t_p3b){ 
      
const long perm[9][6]={0,1,2,3,4,5, 0,1,2,4,3,5, 0,1,2,5,3,4, 1,0,2,3,4,5, 1,0,2,4,3,5, 1,0,2,5,3,4, 2,0,1,3,4,5, 2,0,1,4,3,5, 2,0,1,5,3,4}; 
const long t_b[6]={t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b}; 
for (long permutation=0L;permutation<9L;++permutation) { 
 const long h4b=t_b[perm[permutation][0]]; 
 const long h5b=t_b[perm[permutation][1]]; 
 const long h6b=t_b[perm[permutation][2]]; 
 const long p1b=t_b[perm[permutation][3]]; 
 const long p2b=t_b[perm[permutation][4]]; 
 const long p3b=t_b[perm[permutation][5]]; 
 bool skip=false; 
 for (long p_p=0L;p_p<permutation;++p_p) { 
  if(h4b==t_b[perm[p_p][0]] 
  && h5b==t_b[perm[p_p][1]] 
  && h6b==t_b[perm[p_p][2]] 
  && p1b==t_b[perm[p_p][3]] 
  && p2b==t_b[perm[p_p][4]] 
  && p3b==t_b[perm[p_p][5]]) skip=true; 
 } 
 if (skip) continue; 
 if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)!=12L) { 
  if (z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)) { 
   if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(p1b)^(z->get_sym(p2b)^z->get_sym(p3b))))))==(z->irrep_y()^z->irrep_v())) { 
    long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b)*z->get_range(p1b)*z->get_range(p2b)*z->get_range(p3b); 
    double* k_c_sort=z->mem()->malloc_local_double(dimc); 
    std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
    if (z->get_spin(h4b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h4b)^z->get_sym(p1b))==z->irrep_y()) { 
      long h4b_0,p1b_0; 
      z->restricted_2(h4b,p1b,h4b_0,p1b_0); 
      long h5b_1,h6b_1,p2b_1,p3b_1; 
      z->restricted_4(h5b,h6b,p2b,p3b,h5b_1,h6b_1,p2b_1,p3b_1); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h4b)*z->get_range(p1b); 
      long dima0=dim_common*dima0_sort; 
      long dima1_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(p2b)*z->get_range(p3b); 
      long dima1=dim_common*dima1_sort; 
      if (dima0>0L && dima1>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->lambda1()->get_block(p1b_0-z->noab()+z->nvab()*(h4b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(p1b),1,0,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
       double* k_a1=z->mem()->malloc_local_double(dima1); 
       z->v2()->get_block(p3b_1+(z->nab())*(p2b_1+(z->nab())*(h6b_1+(z->nab())*(h5b_1))),k_a1); 
       z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p2b),z->get_range(p3b),3,2,1,0,+1.0); 
       z->mem()->free_local_double(k_a1); 
       double factor=1.0; 
       z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
       z->mem()->free_local_double(k_a1_sort); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
    if (h5b>=h4b && p2b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(h5b),z->get_range(p1b),z->get_range(h4b),5,3,2,4,1,0,+1.0); 
    } 
    if (h5b>=h4b && p3b>=p1b && p1b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(h5b),z->get_range(p1b),z->get_range(h4b),5,3,2,1,4,0,-1.0); 
    } 
    if (h5b>=h4b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(h5b),z->get_range(p1b),z->get_range(h4b),5,3,2,1,0,4,+1.0); 
    } 
    if (h6b>=h4b && h4b>=h5b && p2b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(h5b),z->get_range(p1b),z->get_range(h4b),3,5,2,4,1,0,-1.0); 
    } 
    if (h6b>=h4b && h4b>=h5b && p3b>=p1b && p1b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(h5b),z->get_range(p1b),z->get_range(h4b),3,5,2,1,4,0,+1.0); 
    } 
    if (h6b>=h4b && h4b>=h5b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(h5b),z->get_range(p1b),z->get_range(h4b),3,5,2,1,0,4,-1.0); 
    } 
    if (h4b>=h6b && p2b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(h5b),z->get_range(p1b),z->get_range(h4b),3,2,5,4,1,0,+1.0); 
    } 
    if (h4b>=h6b && p3b>=p1b && p1b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(h5b),z->get_range(p1b),z->get_range(h4b),3,2,5,1,4,0,-1.0); 
    } 
    if (h4b>=h6b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(h5b),z->get_range(p1b),z->get_range(h4b),3,2,5,1,0,4,+1.0); 
    } 
    z->mem()->free_local_double(k_c_sort); 
   } 
  } 
 } 
} 
} 
  
void CCSD_2T_R12_LEFT::smith_0_2(double* a_i0,const long t_h4b,const long t_h5b,const long t_h6b,const long t_p1b,const long t_p2b,const long t_p3b){ 
      
const long perm[9][6]={0,1,2,3,4,5, 0,1,2,3,5,4, 0,1,2,4,5,3, 0,2,1,3,4,5, 0,2,1,3,5,4, 0,2,1,4,5,3, 1,2,0,3,4,5, 1,2,0,3,5,4, 1,2,0,4,5,3}; 
const long t_b[6]={t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b}; 
for (long permutation=0L;permutation<9L;++permutation) { 
 const long h4b=t_b[perm[permutation][0]]; 
 const long h5b=t_b[perm[permutation][1]]; 
 const long h6b=t_b[perm[permutation][2]]; 
 const long p1b=t_b[perm[permutation][3]]; 
 const long p2b=t_b[perm[permutation][4]]; 
 const long p3b=t_b[perm[permutation][5]]; 
 bool skip=false; 
 for (long p_p=0L;p_p<permutation;++p_p) { 
  if(h4b==t_b[perm[p_p][0]] 
  && h5b==t_b[perm[p_p][1]] 
  && h6b==t_b[perm[p_p][2]] 
  && p1b==t_b[perm[p_p][3]] 
  && p2b==t_b[perm[p_p][4]] 
  && p3b==t_b[perm[p_p][5]]) skip=true; 
 } 
 if (skip) continue; 
 if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)!=12L) { 
  if (z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)) { 
   if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(p1b)^(z->get_sym(p2b)^z->get_sym(p3b))))))==(z->irrep_y()^z->irrep_f())) { 
    long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b)*z->get_range(p1b)*z->get_range(p2b)*z->get_range(p3b); 
    double* k_c_sort=z->mem()->malloc_local_double(dimc); 
    std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
    if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(p1b)^z->get_sym(p2b))))==z->irrep_y()) { 
      long h4b_0,h5b_0,p1b_0,p2b_0; 
      z->restricted_4(h4b,h5b,p1b,p2b,h4b_0,h5b_0,p1b_0,p2b_0); 
      long h6b_1,p3b_1; 
      z->restricted_2(h6b,p3b,h6b_1,p3b_1); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h4b)*z->get_range(h5b)*z->get_range(p1b)*z->get_range(p2b); 
      long dima0=dim_common*dima0_sort; 
      long dima1_sort=z->get_range(h6b)*z->get_range(p3b); 
      long dima1=dim_common*dima1_sort; 
      if (dima0>0L && dima1>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->lambda2()->get_block(p2b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h5b_0+z->noab()*(h4b_0))),k_a0); 
       z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
       double* k_a1=z->mem()->malloc_local_double(dima1); 
       i1xn[0]->get_block(p3b_1-z->noab()+z->nvab()*(h6b_1),k_a1); 
       z->sort_indices2(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(p3b),1,0,+1.0); 
       z->mem()->free_local_double(k_a1); 
       double factor=1.0; 
       z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
       z->mem()->free_local_double(k_a1_sort); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
    if (h6b>=h5b && p3b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(p2b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,4,1,3,2,0,+1.0); 
    } 
    if (h6b>=h5b && p2b>=p3b && p3b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(p2b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,4,1,3,0,2,-1.0); 
    } 
    if (h6b>=h5b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(p2b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,4,1,0,3,2,+1.0); 
    } 
    if (h5b>=h6b && h6b>=h4b && p3b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(p2b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,1,4,3,2,0,-1.0); 
    } 
    if (h5b>=h6b && h6b>=h4b && p2b>=p3b && p3b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(p2b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,1,4,3,0,2,+1.0); 
    } 
    if (h5b>=h6b && h6b>=h4b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(p2b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,1,4,0,3,2,-1.0); 
    } 
    if (h4b>=h6b && p3b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(p2b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),1,5,4,3,2,0,+1.0); 
    } 
    if (h4b>=h6b && p2b>=p3b && p3b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(p2b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),1,5,4,3,0,2,-1.0); 
    } 
    if (h4b>=h6b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(p2b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),1,5,4,0,3,2,+1.0); 
    } 
    z->mem()->free_local_double(k_c_sort); 
   } 
  } 
 } 
} 
} 
  
void CCSD_2T_R12_LEFT::smith_0_2_0(){ 
      
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  long tileoffset; 
  tileoffset=(p3b-z->noab()+z->nvab()*(h6b)); 
  if (i1xn[0]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p3b)!=4L) { 
    if (z->get_spin(h6b)==z->get_spin(p3b)) { 
     if ((z->get_sym(h6b)^z->get_sym(p3b))==z->irrep_f()) { 
      long dimc=z->get_range(h6b)*z->get_range(p3b); 
      long h6b_0,p3b_0; 
      z->restricted_2(h6b,p3b,h6b_0,p3b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h6b)*z->get_range(p3b); 
      long dima0=dim_common*dima0_sort; 
      if (dima0>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->f1()->get_block(p3b_0+(z->nab())*(h6b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(p3b),0,1,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_c=z->mem()->malloc_local_double(dimc); 
       z->sort_indices2(k_a0_sort,k_c,z->get_range(h6b),z->get_range(p3b),0,1,+1.0); 
       i1xn[0]->add_block(p3b-z->noab()+z->nvab()*(h6b),k_c); 
       z->mem()->free_local_double(k_c); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_R12_LEFT::offset_smith_0_2(){ 
 
long size=0L; 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  if (z->get_spin(h6b)==z->get_spin(p3b)) { 
   if ((z->get_sym(h6b)^z->get_sym(p3b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p3b)!=4L) { 
     i1xn[0]->input_offset(p3b-z->noab()+z->nvab()*(h6b),size); 
     size+=z->get_range(h6b)*z->get_range(p3b); 
    } 
   } 
  } 
 } 
} 
i1xn[0]->set_filesize(size); 
i1xn[0]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_R12_LEFT::smith_0_3(double* a_i0,const long t_h4b,const long t_h5b,const long t_h6b,const long t_p1b,const long t_p2b,const long t_p3b){ 
      
const long perm[9][6]={0,1,2,3,4,5, 0,1,2,3,5,4, 0,1,2,4,5,3, 1,0,2,3,4,5, 1,0,2,3,5,4, 1,0,2,4,5,3, 2,0,1,3,4,5, 2,0,1,3,5,4, 2,0,1,4,5,3}; 
const long t_b[6]={t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b}; 
for (long permutation=0L;permutation<9L;++permutation) { 
 const long h4b=t_b[perm[permutation][0]]; 
 const long h5b=t_b[perm[permutation][1]]; 
 const long h6b=t_b[perm[permutation][2]]; 
 const long p1b=t_b[perm[permutation][3]]; 
 const long p2b=t_b[perm[permutation][4]]; 
 const long p3b=t_b[perm[permutation][5]]; 
 bool skip=false; 
 for (long p_p=0L;p_p<permutation;++p_p) { 
  if(h4b==t_b[perm[p_p][0]] 
  && h5b==t_b[perm[p_p][1]] 
  && h6b==t_b[perm[p_p][2]] 
  && p1b==t_b[perm[p_p][3]] 
  && p2b==t_b[perm[p_p][4]] 
  && p3b==t_b[perm[p_p][5]]) skip=true; 
 } 
 if (skip) continue; 
 if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)!=12L) { 
  if (z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)) { 
   if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(p1b)^(z->get_sym(p2b)^z->get_sym(p3b))))))==(z->irrep_y()^z->irrep_v())) { 
    long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b)*z->get_range(p1b)*z->get_range(p2b)*z->get_range(p3b); 
    double* k_c_sort=z->mem()->malloc_local_double(dimc); 
    std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
    for (long h7b=0L;h7b<z->noab();++h7b) { 
     if (z->get_spin(h4b)+z->get_spin(h7b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
      if ((z->get_sym(h4b)^(z->get_sym(h7b)^(z->get_sym(p1b)^z->get_sym(p2b))))==z->irrep_y()) { 
       long h4b_0,h7b_0,p1b_0,p2b_0; 
       z->restricted_4(h4b,h7b,p1b,p2b,h4b_0,h7b_0,p1b_0,p2b_0); 
       long h5b_1,h6b_1,h7b_1,p3b_1; 
       z->restricted_4(h5b,h6b,h7b,p3b,h5b_1,h6b_1,h7b_1,p3b_1); 
       long dim_common=z->get_range(h7b); 
       long dima0_sort=z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
       long dima0=dim_common*dima0_sort; 
       long dima1_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(p3b); 
       long dima1=dim_common*dima1_sort; 
       if (dima0>0L && dima1>0L) { 
        double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
        double* k_a0=z->mem()->malloc_local_double(dima0); 
        if (h4b<h7b) { 
         z->lambda2()->get_block(p2b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h7b_0+z->noab()*(h4b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h7b),z->get_range(p1b),z->get_range(p2b),3,2,0,1,+1.0); 
        } 
        else if (h7b<=h4b) { 
         z->lambda2()->get_block(p2b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h4b_0+z->noab()*(h7b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h4b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,-1.0); 
        } 
        z->mem()->free_local_double(k_a0); 
        double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
        double* k_a1=z->mem()->malloc_local_double(dima1); 
        i1xn[1]->get_block(p3b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h6b_1+z->noab()*(h5b_1))),k_a1); 
        z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h7b),z->get_range(p3b),3,1,0,2,+1.0); 
        z->mem()->free_local_double(k_a1); 
        double factor=1.0; 
        z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        z->mem()->free_local_double(k_a1_sort); 
        z->mem()->free_local_double(k_a0_sort); 
       } 
      } 
     } 
    } 
    if (h5b>=h4b && p3b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),5,2,1,4,3,0,+1.0); 
    } 
    if (h5b>=h4b && p2b>=p3b && p3b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),5,2,1,4,0,3,-1.0); 
    } 
    if (h5b>=h4b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),5,2,1,0,4,3,+1.0); 
    } 
    if (h6b>=h4b && h4b>=h5b && p3b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,5,1,4,3,0,-1.0); 
    } 
    if (h6b>=h4b && h4b>=h5b && p2b>=p3b && p3b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,5,1,4,0,3,+1.0); 
    } 
    if (h6b>=h4b && h4b>=h5b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,5,1,0,4,3,-1.0); 
    } 
    if (h4b>=h6b && p3b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,1,5,4,3,0,+1.0); 
    } 
    if (h4b>=h6b && p2b>=p3b && p3b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,1,5,4,0,3,-1.0); 
    } 
    if (h4b>=h6b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,1,5,0,4,3,+1.0); 
    } 
    z->mem()->free_local_double(k_c_sort); 
   } 
  } 
 } 
} 
} 
  
void CCSD_2T_R12_LEFT::smith_0_3_0(){ 
      
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
    long tileoffset; 
    tileoffset=(p3b-z->noab()+z->nvab()*(h7b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (i1xn[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(p3b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h7b)+z->get_spin(p3b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h7b)^z->get_sym(p3b))))==z->irrep_v()) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h7b)*z->get_range(p3b); 
        long h5b_0,h6b_0,h7b_0,p3b_0; 
        z->restricted_4(h5b,h6b,h7b,p3b,h5b_0,h6b_0,h7b_0,p3b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h7b)*z->get_range(p3b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p3b_0+(z->nab())*(h7b_0+(z->nab())*(h6b_0+(z->nab())*(h5b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h7b),z->get_range(p3b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h5b),z->get_range(h6b),z->get_range(h7b),z->get_range(p3b),0,1,2,3,-1.0); 
         i1xn[1]->add_block(p3b-z->noab()+z->nvab()*(h7b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_R12_LEFT::offset_smith_0_3(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
    if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h7b)+z->get_spin(p3b)) { 
     if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h7b)^z->get_sym(p3b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(p3b)!=8L) { 
       i1xn[1]->input_offset(p3b-z->noab()+z->nvab()*(h7b+z->noab()*(h6b+z->noab()*(h5b))),size); 
       size+=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h7b)*z->get_range(p3b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
i1xn[1]->set_filesize(size); 
i1xn[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_R12_LEFT::smith_0_4(double* a_i0,const long t_h4b,const long t_h5b,const long t_h6b,const long t_p1b,const long t_p2b,const long t_p3b){ 
      
const long perm[9][6]={0,1,2,3,4,5, 0,1,2,4,3,5, 0,1,2,5,3,4, 0,2,1,3,4,5, 0,2,1,4,3,5, 0,2,1,5,3,4, 1,2,0,3,4,5, 1,2,0,4,3,5, 1,2,0,5,3,4}; 
const long t_b[6]={t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b}; 
for (long permutation=0L;permutation<9L;++permutation) { 
 const long h4b=t_b[perm[permutation][0]]; 
 const long h5b=t_b[perm[permutation][1]]; 
 const long h6b=t_b[perm[permutation][2]]; 
 const long p1b=t_b[perm[permutation][3]]; 
 const long p2b=t_b[perm[permutation][4]]; 
 const long p3b=t_b[perm[permutation][5]]; 
 bool skip=false; 
 for (long p_p=0L;p_p<permutation;++p_p) { 
  if(h4b==t_b[perm[p_p][0]] 
  && h5b==t_b[perm[p_p][1]] 
  && h6b==t_b[perm[p_p][2]] 
  && p1b==t_b[perm[p_p][3]] 
  && p2b==t_b[perm[p_p][4]] 
  && p3b==t_b[perm[p_p][5]]) skip=true; 
 } 
 if (skip) continue; 
 if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)!=12L) { 
  if (z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)) { 
   if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(p1b)^(z->get_sym(p2b)^z->get_sym(p3b))))))==(z->irrep_y()^z->irrep_v())) { 
    long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b)*z->get_range(p1b)*z->get_range(p2b)*z->get_range(p3b); 
    double* k_c_sort=z->mem()->malloc_local_double(dimc); 
    std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
    for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
     if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(p1b)+z->get_spin(p7b)) { 
      if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(p1b)^z->get_sym(p7b))))==z->irrep_y()) { 
       long h4b_0,h5b_0,p1b_0,p7b_0; 
       z->restricted_4(h4b,h5b,p1b,p7b,h4b_0,h5b_0,p1b_0,p7b_0); 
       long h6b_1,p7b_1,p2b_1,p3b_1; 
       z->restricted_4(h6b,p7b,p2b,p3b,h6b_1,p7b_1,p2b_1,p3b_1); 
       long dim_common=z->get_range(p7b); 
       long dima0_sort=z->get_range(h4b)*z->get_range(h5b)*z->get_range(p1b); 
       long dima0=dim_common*dima0_sort; 
       long dima1_sort=z->get_range(h6b)*z->get_range(p2b)*z->get_range(p3b); 
       long dima1=dim_common*dima1_sort; 
       if (dima0>0L && dima1>0L) { 
        double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
        double* k_a0=z->mem()->malloc_local_double(dima0); 
        if (p1b<p7b) { 
         z->lambda2()->get_block(p7b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h5b_0+z->noab()*(h4b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(p1b),z->get_range(p7b),2,1,0,3,+1.0); 
        } 
        else if (p7b<=p1b) { 
         z->lambda2()->get_block(p1b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(h5b_0+z->noab()*(h4b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(p7b),z->get_range(p1b),3,1,0,2,-1.0); 
        } 
        z->mem()->free_local_double(k_a0); 
        double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
        double* k_a1=z->mem()->malloc_local_double(dima1); 
        z->v2()->get_block(p3b_1+(z->nab())*(p2b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1))),k_a1); 
        z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(p7b),z->get_range(p2b),z->get_range(p3b),3,2,0,1,+1.0); 
        z->mem()->free_local_double(k_a1); 
        double factor=1.0; 
        z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        z->mem()->free_local_double(k_a1_sort); 
        z->mem()->free_local_double(k_a0_sort); 
       } 
      } 
     } 
    } 
    if (h6b>=h5b && p2b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,4,2,3,1,0,-1.0); 
    } 
    if (h6b>=h5b && p3b>=p1b && p1b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,4,2,1,3,0,+1.0); 
    } 
    if (h6b>=h5b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,4,2,1,0,3,-1.0); 
    } 
    if (h5b>=h6b && h6b>=h4b && p2b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,2,4,3,1,0,+1.0); 
    } 
    if (h5b>=h6b && h6b>=h4b && p3b>=p1b && p1b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,2,4,1,3,0,-1.0); 
    } 
    if (h5b>=h6b && h6b>=h4b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,2,4,1,0,3,+1.0); 
    } 
    if (h4b>=h6b && p2b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),2,5,4,3,1,0,-1.0); 
    } 
    if (h4b>=h6b && p3b>=p1b && p1b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),2,5,4,1,3,0,+1.0); 
    } 
    if (h4b>=h6b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),2,5,4,1,0,3,-1.0); 
    } 
    z->mem()->free_local_double(k_c_sort); 
   } 
  } 
 } 
} 
} 
  
void CCSD_2T_R12_LEFT::smith_0_5(double* a_i0,const long t_h4b,const long t_h5b,const long t_h6b,const long t_p1b,const long t_p2b,const long t_p3b){ 
      
const long perm[9][6]={0,1,2,3,4,5, 0,1,2,4,3,5, 0,1,2,5,3,4, 0,2,1,3,4,5, 0,2,1,4,3,5, 0,2,1,5,3,4, 1,2,0,3,4,5, 1,2,0,4,3,5, 1,2,0,5,3,4}; 
const long t_b[6]={t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b}; 
for (long permutation=0L;permutation<9L;++permutation) { 
 const long h4b=t_b[perm[permutation][0]]; 
 const long h5b=t_b[perm[permutation][1]]; 
 const long h6b=t_b[perm[permutation][2]]; 
 const long p1b=t_b[perm[permutation][3]]; 
 const long p2b=t_b[perm[permutation][4]]; 
 const long p3b=t_b[perm[permutation][5]]; 
 bool skip=false; 
 for (long p_p=0L;p_p<permutation;++p_p) { 
  if(h4b==t_b[perm[p_p][0]] 
  && h5b==t_b[perm[p_p][1]] 
  && h6b==t_b[perm[p_p][2]] 
  && p1b==t_b[perm[p_p][3]] 
  && p2b==t_b[perm[p_p][4]] 
  && p3b==t_b[perm[p_p][5]]) skip=true; 
 } 
 if (skip) continue; 
 if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)!=12L) { 
  if (z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)) { 
   if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(p1b)^(z->get_sym(p2b)^z->get_sym(p3b))))))==(z->irrep_y()^z->irrep_v())) { 
    long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b)*z->get_range(p1b)*z->get_range(p2b)*z->get_range(p3b); 
    double* k_c_sort=z->mem()->malloc_local_double(dimc); 
    std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
    for (long q7b=z->noab()+z->nvab();q7b<z->nab();++q7b) { 
     if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(p1b)+z->get_spin(q7b)) { 
      if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(p1b)^z->get_sym(q7b))))==z->irrep_y()) { 
       long h4b_0,h5b_0,p1b_0,q7b_0; 
       z->restricted_4(h4b,h5b,p1b,q7b,h4b_0,h5b_0,p1b_0,q7b_0); 
       long h6b_1,q7b_1,p2b_1,p3b_1; 
       z->restricted_4(h6b,q7b,p2b,p3b,h6b_1,q7b_1,p2b_1,p3b_1); 
       long dim_common=z->get_range(q7b); 
       long dima0_sort=z->get_range(h4b)*z->get_range(h5b)*z->get_range(p1b); 
       long dima0=dim_common*dima0_sort; 
       long dima1_sort=z->get_range(h6b)*z->get_range(p2b)*z->get_range(p3b); 
       long dima1=dim_common*dima1_sort; 
       if (dima0>0L && dima1>0L) { 
        double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
        double* k_a0=z->mem()->malloc_local_double(dima0); 
        z->ly()->get_block(q7b_0-z->noab()-z->nvab()+z->ncab()*(p1b_0-z->noab()+z->nvab()*(h5b_0+z->noab()*(h4b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(p1b),z->get_range(q7b),2,1,0,3,+1.0); 
        z->mem()->free_local_double(k_a0); 
        double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
        double* k_a1=z->mem()->malloc_local_double(dima1); 
        z->v2()->get_block(p3b_1+(z->nab())*(p2b_1+(z->nab())*(q7b_1+(z->nab())*(h6b_1))),k_a1); 
        z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(q7b),z->get_range(p2b),z->get_range(p3b),3,2,0,1,+1.0); 
        z->mem()->free_local_double(k_a1); 
        double factor=1.0; 
        z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        z->mem()->free_local_double(k_a1_sort); 
        z->mem()->free_local_double(k_a0_sort); 
       } 
      } 
     } 
    } 
    if (h6b>=h5b && p2b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,4,2,3,1,0,-1.0); 
    } 
    if (h6b>=h5b && p3b>=p1b && p1b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,4,2,1,3,0,+1.0); 
    } 
    if (h6b>=h5b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,4,2,1,0,3,-1.0); 
    } 
    if (h5b>=h6b && h6b>=h4b && p2b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,2,4,3,1,0,+1.0); 
    } 
    if (h5b>=h6b && h6b>=h4b && p3b>=p1b && p1b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,2,4,1,3,0,-1.0); 
    } 
    if (h5b>=h6b && h6b>=h4b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),5,2,4,1,0,3,+1.0); 
    } 
    if (h4b>=h6b && p2b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),2,5,4,3,1,0,-1.0); 
    } 
    if (h4b>=h6b && p3b>=p1b && p1b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),2,5,4,1,3,0,+1.0); 
    } 
    if (h4b>=h6b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(p2b),z->get_range(h6b),z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),2,5,4,1,0,3,-1.0); 
    } 
    z->mem()->free_local_double(k_c_sort); 
   } 
  } 
 } 
} 
} 
  
void CCSD_2T_R12_LEFT::smith_0_8(double* a_i0,const long t_h4b,const long t_h5b,const long t_h6b,const long t_p1b,const long t_p2b,const long t_p3b){ 
      
const long perm[9][6]={0,1,2,3,4,5, 0,1,2,3,5,4, 0,1,2,4,5,3, 1,0,2,3,4,5, 1,0,2,3,5,4, 1,0,2,4,5,3, 2,0,1,3,4,5, 2,0,1,3,5,4, 2,0,1,4,5,3}; 
const long t_b[6]={t_h4b,t_h5b,t_h6b,t_p1b,t_p2b,t_p3b}; 
for (long permutation=0L;permutation<9L;++permutation) { 
 const long h4b=t_b[perm[permutation][0]]; 
 const long h5b=t_b[perm[permutation][1]]; 
 const long h6b=t_b[perm[permutation][2]]; 
 const long p1b=t_b[perm[permutation][3]]; 
 const long p2b=t_b[perm[permutation][4]]; 
 const long p3b=t_b[perm[permutation][5]]; 
 bool skip=false; 
 for (long p_p=0L;p_p<permutation;++p_p) { 
  if(h4b==t_b[perm[p_p][0]] 
  && h5b==t_b[perm[p_p][1]] 
  && h6b==t_b[perm[p_p][2]] 
  && p1b==t_b[perm[p_p][3]] 
  && p2b==t_b[perm[p_p][4]] 
  && p3b==t_b[perm[p_p][5]]) skip=true; 
 } 
 if (skip) continue; 
 if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)!=12L) { 
  if (z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(p1b)+z->get_spin(p2b)+z->get_spin(p3b)) { 
   if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(p1b)^(z->get_sym(p2b)^z->get_sym(p3b))))))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
    long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b)*z->get_range(p1b)*z->get_range(p2b)*z->get_range(p3b); 
    double* k_c_sort=z->mem()->malloc_local_double(dimc); 
    std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
    for (long h7b=0L;h7b<z->noab();++h7b) { 
     if (z->get_spin(h4b)+z->get_spin(h7b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
      if ((z->get_sym(h4b)^(z->get_sym(h7b)^(z->get_sym(p1b)^z->get_sym(p2b))))==z->irrep_v()) { 
       long h4b_0,h7b_0,p1b_0,p2b_0; 
       z->restricted_4(h4b,h7b,p1b,p2b,h4b_0,h7b_0,p1b_0,p2b_0); 
       long h5b_1,h6b_1,h7b_1,p3b_1; 
       z->restricted_4(h5b,h6b,h7b,p3b,h5b_1,h6b_1,h7b_1,p3b_1); 
       long dim_common=z->get_range(h7b); 
       long dima0_sort=z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
       long dima0=dim_common*dima0_sort; 
       long dima1_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(p3b); 
       long dima1=dim_common*dima1_sort; 
       if (dima0>0L && dima1>0L) { 
        double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
        double* k_a0=z->mem()->malloc_local_double(dima0); 
        if (h4b<h7b) { 
         z->v2()->get_block(p2b_0+(z->nab())*(p1b_0+(z->nab())*(h7b_0+(z->nab())*(h4b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h7b),z->get_range(p1b),z->get_range(p2b),3,2,0,1,+1.0); 
        } 
        else if (h7b<=h4b) { 
         z->v2()->get_block(p2b_0+(z->nab())*(p1b_0+(z->nab())*(h4b_0+(z->nab())*(h7b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h4b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,-1.0); 
        } 
        z->mem()->free_local_double(k_a0); 
        double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
        double* k_a1=z->mem()->malloc_local_double(dima1); 
        i1xn[2]->get_block(p3b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h6b_1+z->noab()*(h5b_1))),k_a1); 
        z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h7b),z->get_range(p3b),3,1,0,2,+1.0); 
        z->mem()->free_local_double(k_a1); 
        double factor=1.0; 
        z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        z->mem()->free_local_double(k_a1_sort); 
        z->mem()->free_local_double(k_a0_sort); 
       } 
      } 
     } 
    } 
    if (h5b>=h4b && p3b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),5,2,1,4,3,0,+1.0); 
    } 
    if (h5b>=h4b && p2b>=p3b && p3b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),5,2,1,4,0,3,-1.0); 
    } 
    if (h5b>=h4b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),5,2,1,0,4,3,+1.0); 
    } 
    if (h6b>=h4b && h4b>=h5b && p3b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,5,1,4,3,0,-1.0); 
    } 
    if (h6b>=h4b && h4b>=h5b && p2b>=p3b && p3b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,5,1,4,0,3,+1.0); 
    } 
    if (h6b>=h4b && h4b>=h5b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,5,1,0,4,3,-1.0); 
    } 
    if (h4b>=h6b && p3b>=p2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,1,5,4,3,0,+1.0); 
    } 
    if (h4b>=h6b && p2b>=p3b && p3b>=p1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,1,5,4,0,3,-1.0); 
    } 
    if (h4b>=h6b && p1b>=p3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),2,1,5,0,4,3,+1.0); 
    } 
    z->mem()->free_local_double(k_c_sort); 
   } 
  } 
 } 
} 
} 
  
void CCSD_2T_R12_LEFT::offset_smith_0_8(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
    if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h7b)+z->get_spin(p3b)) { 
     if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h7b)^z->get_sym(p3b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(p3b)!=8L) { 
       i1xn[2]->input_offset(p3b-z->noab()+z->nvab()*(h7b+z->noab()*(h6b+z->noab()*(h5b))),size); 
       size+=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h7b)*z->get_range(p3b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
i1xn[2]->set_filesize(size); 
i1xn[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_R12_LEFT::smith_1_6(){ 
      
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  long tileoffset; 
  tileoffset=(p3b-z->noab()+z->nvab()*(h6b)); 
  if (i1xn[0]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p3b)!=4L) { 
    if (z->get_spin(h6b)==z->get_spin(p3b)) { 
     if ((z->get_sym(h6b)^z->get_sym(p3b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h6b)*z->get_range(p3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
        if (z->get_spin(p7b)==z->get_spin(h8b)) { 
         if ((z->get_sym(p7b)^z->get_sym(h8b))==z->irrep_t()) { 
          long p7b_0,h8b_0; 
          z->restricted_2(p7b,h8b,p7b_0,h8b_0); 
          long h6b_1,h8b_1,p3b_1,p7b_1; 
          z->restricted_4(h6b,h8b,p3b,p7b,h6b_1,h8b_1,p3b_1,p7b_1); 
          long dim_common=z->get_range(h8b)*z->get_range(p7b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h6b)*z->get_range(p3b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h8b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h8b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h6b<h8b && p3b<p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p3b_1+(z->nab())*(h8b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h8b),z->get_range(p3b),z->get_range(p7b),2,0,3,1,+1.0); 
           } 
           else if (h6b<h8b && p7b<=p3b) { 
            z->v2()->get_block(p3b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h8b),z->get_range(p7b),z->get_range(p3b),3,0,2,1,-1.0); 
           } 
           else if (h8b<=h6b && p3b<p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p3b_1+(z->nab())*(h6b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h6b),z->get_range(p3b),z->get_range(p7b),2,1,3,0,-1.0); 
           } 
           else if (h8b<=h6b && p7b<=p3b) { 
            z->v2()->get_block(p3b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h6b),z->get_range(p7b),z->get_range(p3b),3,1,2,0,+1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p3b),z->get_range(h6b),1,0,+1.0); 
      i1xn[0]->add_block(p3b-z->noab()+z->nvab()*(h6b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_R12_LEFT::smith_1_7(){ 
      
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
    long tileoffset; 
    tileoffset=(p3b-z->noab()+z->nvab()*(h7b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (i1xn[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(p3b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h7b)+z->get_spin(p3b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h7b)^z->get_sym(p3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h7b)*z->get_range(p3b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h7b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h7b))==z->irrep_t()) { 
           long p8b_0,h7b_0; 
           z->restricted_2(p8b,h7b,p8b_0,h7b_0); 
           long h5b_1,h6b_1,p3b_1,p8b_1; 
           z->restricted_4(h5b,h6b,p3b,p8b,h5b_1,h6b_1,p3b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h7b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(p3b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h7b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h7b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p3b<p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p3b_1+(z->nab())*(h6b_1+(z->nab())*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p3b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p3b) { 
             z->v2()->get_block(p3b_1+(z->nab())*(p8b_1+(z->nab())*(h6b_1+(z->nab())*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p8b),z->get_range(p3b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(h7b),2,1,3,0,+1.0); 
        i1xn[1]->add_block(p3b-z->noab()+z->nvab()*(h7b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_R12_LEFT::smith_1_8(){ 
      
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
    long tileoffset; 
    tileoffset=(p3b-z->noab()+z->nvab()*(h7b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (i1xn[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(p3b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h7b)+z->get_spin(p3b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h7b)^z->get_sym(p3b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h7b)*z->get_range(p3b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h7b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h7b))==z->irrep_t()) { 
           long p8b_0,h7b_0; 
           z->restricted_2(p8b,h7b,p8b_0,h7b_0); 
           long h5b_1,h6b_1,p3b_1,p8b_1; 
           z->restricted_4(h5b,h6b,p3b,p8b,h5b_1,h6b_1,p3b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h7b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(p3b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h7b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h7b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p3b<p8b) { 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p3b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p3b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p3b) { 
             z->lambda2()->get_block(p3b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p8b),z->get_range(p3b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p3b),z->get_range(h6b),z->get_range(h5b),z->get_range(h7b),2,1,3,0,+1.0); 
        i1xn[2]->add_block(p3b-z->noab()+z->nvab()*(h7b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
