///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __LAMMPS_DUMP_PARSER_H
#define __LAMMPS_DUMP_PARSER_H

#include <core/Core.h>
#include "../MultiFileParser.h"

namespace AtomViz {

/**
 * \brief Common base class for file parser's that can read LAMMPS dump files.
 *
 * \author Alexander Stukowski
 */
class ATOMVIZ_DLLEXPORT LAMMPSDumpParser : public MultiFileParser
{
protected:
	/// \brief Constructs a new instance of this class.
	/// \param isLoading Specifies whether the object's data fields will be initialized from the
	///                  data stored in a scene file after the instance has been created.
	LAMMPSDumpParser(bool isLoading = false);

public:

	/// Opens the settings dialog for this parser.
	/// \return \a true if the dialog has been approved by the user; \a false when the user has canceled the operation.
	virtual bool showSettingsDialog(QWidget* parent);

	/// \brief Returns whether this import filter provides a settings dialog box.
	virtual bool hasSettingsDialog() { return true; }

private:

	Q_OBJECT
	DECLARE_ABSTRACT_PLUGIN_CLASS(LAMMPSDumpParser)
};

};	// End of namespace AtomViz

#endif // __LAMMPS_DUMP_PARSER_H
