/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OWQTBROWSERWIDGET_H
#define OWQTBROWSERWIDGET_H

#include <QtCore/QObject>

#include <util/NonCopyable.h>

#include <string>

#include<QtNetwork/QtNetwork>
#include<QtGui/QtGui>
#include<QtWebKit/QtWebKit>

class QtQuteCom;

/**
 * Embedded HTML browser widget inside the main window.
 *
 * Works only under Windows for the moment using a ActiveX control.
 *
 * @author Tanguy Krotoff
 * @author Mathieu Stute
 */

class QtWebPage :public QWebPage
{
protected:
	bool acceptNavigationRequest(QWebFrame *frame, const QNetworkRequest &request, NavigationType type)
	{
		//if(type == QWebPage::NavigationTypeOther)
		//	QDesktopServices::openUrl(request.url());

		return QWebPage::acceptNavigationRequest(frame,request,type);
	}
};

class QtBrowserWidget : public QObject, NonCopyable {
	Q_OBJECT
public:

	QtBrowserWidget(QtQuteCom & qtQuteCom);

	~QtBrowserWidget();

	QWidget * getWidget() const;

	/**
	 * Loads the default URL, loaded at startup.
	 */
	void loadDefaultURL();

	/**
	 * Loads the URL when the user is connecting.
	 */
	void loadProgressURL();

private Q_SLOTS:

	/**
	 * delete the browser.
	 */
	void slotUserProfileDeleted();

	void linkClicked_slot(const QUrl & url);

private:

	QtQuteCom & _qtQuteCom;

	QWebView * _qtBrowser;

	QString base_path;

Q_SIGNALS:
		void openqutecom_phonebook_signal();
		void openqutecom_log_signal();
		void openqutecom_configuration_signal();
		void openqutecom_dial_signal();
		void openqutecom_addcontact_signal();
		void openqutecom_selfcare_signal();
		void openqutecom_forum_signal();
		void openqutecom_smartdirectory_signal();
		void openqutecom_secret_permanent_signal();
};

#endif	//OWQTBROWSERWIDGET_H
