#!/bin/sh
# This starts up a cluster monitoring website.  You can change
# the paths, the default wulfhosts file, and can customize the
# header.

WULFCONF=/etc/wulfware
WULFPATH=/var/www/html/wulf2html

if [ -d /var/www/html/wulf2html ]
then
  cp $WULFCONF/cluster_header.html $WULFPATH/index.html
  wulf2html -d 60 -f $WULFCONF/wulfhosts -i $WULFCONF/cluster_header.html -t 0 $WULFPATH/vmstat.html &
  wulf2html -d 60 -f $WULFCONF/wulfhosts -i $WULFCONF/cluster_header.html -t 2 $WULFPATH/memory.html &
  wulf2html -d 60 -f $WULFCONF/wulfhosts -i $WULFCONF/cluster_header.html -t 3 $WULFPATH/network.html &
  wulf2html -d 60 -f $WULFCONF/wulfhosts -i $WULFCONF/cluster_header.html -t 4 $WULFPATH/cpustat.html &
  wulf2html -d 60 -f $WULFCONF/wulfhosts -i $WULFCONF/cluster_header.html -t 6 $WULFPATH/jobs.html &
else
  echo "Error!  $WULFPATH does not exist!" >&2
  exit 1;
fi

