#! /usr/bin/perl 
 use lib qw( /usr/lib/perl );

 use FileHandle;
 use IO::Handle;

 $new = "$ENV{HOME}/public_html/wulflogger.html.new";
 $old = "$ENV{HOME}/public_html/wulflogger.html";
 $time = localtime;

 open(WEBOUT,">$new") || die "Sorry, I couldn't open $new: $!\n";
 print WEBOUT "
<html>
 <head>
 </head>

 <body>
 <meta http-equiv=\"refresh\" content=\"5\">

 <h2>r-cluster load average data from time $time</h2>
 <hr>
 <table width=\"400\" border=\"2\" cellpadding=\"2\">
   <tr> <td> NODE </td> <td> Load 1 </td> <td> Load 5 </td> <td> Load 15 </td> </tr>
";

 $delay = 5;
 open(STDIN ,"./wulflogger -t 1 -d $delay -f ~/.wulfhosts-r | ") || die "Sorry, I couldn't open stdin: $!\n";
 while(<STDIN>){
  chop;
  if(!/^#/){
    @fields =  split(/\s+/,$_);
    ($node,$stat,$time,$load1,$load5,$load15) = split(/\s+/,$_);
    $time = int($time);
    $_ = $stat;
    if(/down/) {
      print WEBOUT "<tr bgcolor=\"#000000\"><td><font color=\"FFFFFF\">$node</font> </td> <td><font color=\"FFFFFF\">down</font></td><td></td><td></td></tr>\n";
    } else {
      if($load1 > 2.5) {
        print WEBOUT "<tr bgcolor=\"#FF0000\"><td> $node </td> <td> $load1 </td> <td> $load5 </td> <td> $load15 </td></tr>\n";
      } elsif($load1 > 1.5) {
        print WEBOUT "<tr bgcolor=\"#FFFF00\"><td> $node </td> <td> $load1 </td> <td> $load5 </td> <td> $load15 </td></tr>\n";
      } elsif($load1 > 0.5) {
        print WEBOUT "<tr bgcolor=\"#00FF00\"><td> $node </td> <td> $load1 </td> <td> $load5 </td> <td> $load15 </td></tr>\n";
      } else {
        print WEBOUT "<tr bgcolor=\"#0000FF\"><td> $node </td> <td> $load1 </td> <td> $load5 </td> <td> $load15 </td></tr>\n";
      }
    }
    flush WEBOUT;
  } else {
    print WEBOUT "
 </table>
 </body>
</html>
";
    close(WEBOUT);
    rename $new,$old;
    $time = localtime;
    open(WEBOUT,">$new") || die "Sorry, I couldn't open $new: $!\n";
    print WEBOUT "
<html>
 <head>
 </head>

 <body>
 <meta http-equiv=\"refresh\" content=\"5\">

 <h2>r-cluster load average data from time $time</h2>
 <hr>
 <table width=\"400\" border=\"2\" cellpadding=\"2\">
   <tr> <td> NODE </td> <td> Load 1 </td> <td> Load 5 </td> <td> Load 15 </td> </tr>
";
  }
 }

# Get rid of temporary file on exit, if possible.
 unlink $new;
