/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the  "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "DOMSupportDefault.hpp"



#include "xalanc/Include/XalanMemoryManagement.hpp"



#include "DOMServices.hpp"
#include "DOMSupportException.hpp"



namespace XALAN_CPP_NAMESPACE {



DOMSupportDefault::DOMSupportDefault(MemoryManager&     /* theManager */) :
    DOMSupport()
{
}



DOMSupportDefault::DOMSupportDefault() :
    DOMSupport()
{
}



DOMSupportDefault::~DOMSupportDefault()
{
}



void
DOMSupportDefault::reset()
{
}



static const XalanDOMString     s_emptyString(XalanMemMgrs::getDummyMemMgr());



const XalanDOMString&
DOMSupportDefault::getUnparsedEntityURI(
            const XalanDOMString&   /* theName */,
            const XalanDocument&    /* theDocument */) const
{
    return s_emptyString;
}



bool
DOMSupportDefault::isNodeAfter(
            const XalanNode&    node1,
            const XalanNode&    node2) const
{
    return DOMServices::isNodeAfter(node1, node2);
}



}
