/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1994
 * Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the default keymap of the HP-4032 X terminal (aka Aptrex), 
 * whose physical appearance mimics the Sun type 5 PC-style keyboard.
 * By Mark Borges <mdb@cdc.noaa.gov>.
 */

static const struct default_keycode_map hp4032x_map [] = {
  {  16, 0,		{ XK_F1 }},
  {  17, 0,		{ XK_Escape }},
  {  18, 0,		{ XK_Help }},
  {  19, 0,		{ XK_F11,	XK_F11,
			XK_Cancel }},
  {  20, 0,		{ XK_F12,	XK_F12,
			XK_Redo }},
  {  21, 0,		{ XK_F13,	XK_F13,
			SunXK_Props }},
  {  22, 0,		{ XK_Tab,	hpXK_BackTab }},
  {  23, 0,		{ XK_grave,	XK_asciitilde,
			XK_guillemotleft,	XK_guillemotright }},
  {  24, 0,		{ XK_F2 }},
  {  25, 0,		{ XK_F14,	XK_F14,
			XK_Undo }},
  {  26, ControlMask,	{ XK_Control_L }},
  {  27, ShiftMask,	{ XK_Shift_L }},
  {  28, 0,		{ XK_F15,	XK_F15,
			SunXK_Front }},
  {  29, LockMask,	{ XK_Caps_Lock }},
  {  30, 0,		{ XK_q,	XK_Q,
			XK_periodcentered,	XK_periodcentered }},
  {  31, 0,		{ XK_1,	XK_exclam,
			XK_exclamdown,	XK_exclamdown }},
  {  32, 0,		{ XK_F3 }},
  {  33, 0,		{ XK_F16,	XK_F16,
			SunXK_Copy }},
  {  34, Mod4Mask,	{ XK_Alt_L }},
  {  35, 0,		{ XK_z,	XK_Z,
			XK_paragraph,	XK_paragraph }},
  {  36, 0,		{ XK_s,	XK_S,
			XK_ssharp,	XK_ssharp }},
  {  37, 0,		{ XK_a,	XK_A,
			XK_aring,	XK_Aring }},
  {  38, 0,		{ XK_w,	XK_W,
			XK_asciitilde,	XK_asciitilde }},
  {  39, 0,		{ XK_2,	XK_at,
			XK_at,	XK_at }},
  {  40, 0,		{ XK_F4 }},
  {  41, 0,		{ XK_F17,	XK_F17,
			SunXK_Open }},
  {  42, 0,		{ XK_c,	XK_C,
			XK_ccedilla,	XK_Ccedilla }},
  {  43, 0,		{ XK_x,	XK_X,
			XK_scaron,	XK_Scaron }},
  {  44, 0,		{ XK_d,	XK_D,
			XK_eth,	XK_ETH }},
  {  45, 0,		{ XK_e,	XK_E,
			XK_ae,	XK_AE }},
  {  46, 0,		{ XK_4,	XK_dollar,
			XK_onequarter,	hpXK_Ydiaeresis }},
  {  47, 0,		{ XK_3,	XK_numbersign,
			XK_numbersign,	XK_numbersign }},
  {  48, 0,		{ XK_F5 }},
  {  49, 0,		{ XK_F18,	XK_F18,
			SunXK_Paste }},
  {  50, 0,		{ XK_space }},
  {  51, 0,		{ XK_v,	XK_V,
			XK_section,	XK_section }},
  {  52, 0,		{ XK_f,	XK_F,
			hpXK_guilder,	hpXK_guilder }},
  {  53, 0,		{ XK_t,	XK_T,
			hpXK_mute_grave,	hpXK_mute_grave }},
  {  54, 0,		{ XK_r,	XK_R,
			hpXK_mute_acute,	hpXK_mute_acute }},
  {  55, 0,		{ XK_5,	XK_percent,
			XK_onehalf,	XK_onehalf }},
  {  56, 0,		{ XK_F6 }},
  {  57, 0,		{ XK_F19,	XK_F19,
			XK_Find }},
  {  58, 0,		{ XK_n,	XK_N,
			XK_ordfeminine,	XK_ordfeminine }},
  {  59, 0,		{ XK_b,	XK_B,
			hpXK_block,	hpXK_block }},
  {  60, 0,		{ XK_h,	XK_H,
			XK_yen,	XK_yen }},
  {  61, 0,		{ XK_g,	XK_G,
			XK_currency,	XK_currency }},
  {  62, 0,		{ XK_y,	XK_Y,
			hpXK_mute_asciicircum,	hpXK_mute_asciicircum }},
  {  63, 0,		{ XK_6,	XK_asciicircum,
			XK_asciicircum,	XK_asciicircum }},
  {  64, 0,		{ XK_F7 }},
  {  65, 0,		{ XK_F20,	XK_F20,
			SunXK_Cut }},
  {  66, 0,		{ XK_Multi_key }},
  {  67, 0,		{ XK_m,	XK_M,
			XK_masculine,	XK_masculine }},
  {  68, 0,		{ XK_j,	XK_J,
			XK_dollar,	XK_dollar }},
  {  69, 0,		{ XK_u,	XK_U,
			hpXK_mute_diaeresis,	hpXK_mute_diaeresis }},
  {  70, 0,		{ XK_7,	XK_ampersand,
			XK_backslash,	XK_backslash }},
  {  71, 0,		{ XK_8,	XK_asterisk,
			XK_bracketleft,	XK_braceleft }},
  {  72, 0,		{ XK_F8 }},
  {  73, Mod1Mask,	{ XK_Meta_L }},
  {  74, 0,		{ XK_comma,	XK_less,
			XK_less,	XK_less }},
  {  75, 0,		{ XK_k,	XK_K,
			XK_cent,	XK_cent }},
  {  76, 0,		{ XK_i,	XK_I,
			hpXK_mute_asciitilde,	hpXK_mute_asciitilde }},
  {  77, 0,		{ XK_o,	XK_O,
			XK_oslash,	XK_Ooblique }},
  {  78, 0,		{ XK_0,	XK_parenright,
			XK_questiondown,	XK_questiondown }},
  {  79, 0,		{ XK_9,	XK_parenleft,
			XK_bracketright,	XK_braceright }},
  {  80, 0,		{ XK_F9 }},
  {  81, Mod1Mask,	{ XK_Meta_R }},
  {  82, 0,		{ XK_period,	XK_greater,
			XK_greater,	XK_greater }},
  {  83, 0,		{ XK_slash,	XK_question,
			XK_underscore,	XK_underscore }},
  {  84, 0,		{ XK_l,	XK_L,
			XK_sterling,	XK_sterling }},
  {  85, 0,		{ XK_semicolon,	XK_colon,
			hpXK_lira,	hpXK_lira }},
  {  86, 0,		{ XK_p,	XK_P,
			XK_thorn,	XK_THORN }},
  {  87, 0,		{ XK_minus,	XK_underscore,
			hpXK_longminus,	XK_macron }},
  {  88, 0,		{ XK_F10 }},
  {  91, 0,		{ XK_apostrophe,	XK_quotedbl,
			XK_grave,	XK_apostrophe }},
  {  93, 0,		{ XK_bracketleft,	XK_braceleft,
			XK_degree,	XK_degree }},
  {  94, 0,		{ XK_equal,	XK_plus,
			XK_plusminus,	XK_plusminus }},
  {  95, 0,		{ XK_F11 }},
  {  96, 0,		{ XK_F22,	XK_F22,
			XK_Print,	SunXK_Sys_Req }},
  {  97, Mod2Mask,	{ XK_Mode_switch }},
  {  98, ShiftMask,	{ XK_Shift_R }},
  {  99, 0,		{ XK_Return }},
  { 100, 0,		{ XK_bracketright,	XK_braceright,
			XK_brokenbar,	XK_brokenbar }},
  { 101, 0,		{ XK_backslash,	XK_bar,
			XK_brokenbar,	XK_mu }},
  { 103, 0,		{ XK_F12 }},
  { 104, 0,		{ XK_F23,	XK_F23,
			XK_Scroll_Lock }},
  { 105, 0,		{ XK_Down }},
  { 106, 0,		{ XK_Left }},
  { 107, 0,		{ XK_F21,	XK_F21,
			XK_Pause,	XK_Break }},
  { 108, 0,		{ XK_Up }},
  { 109, 0,		{ XK_Delete }},
  { 110, 0,		{ XK_End }},
  { 111, 0,		{ XK_BackSpace }},
  { 112, 0,		{ XK_Insert }},
  { 114, 0,		{ XK_F33,	XK_F33,
			XK_KP_1,	XK_End }},
  { 115, 0,		{ XK_Right }},
  { 116, 0,		{ XK_Left,	XK_F30,
			XK_KP_4 }},
  { 117, 0,		{ XK_F27,	XK_F27,
			XK_KP_7,	XK_Home }},
  { 118, 0,		{ XK_Next }},
  { 119, 0,		{ XK_Home }},
  { 120, 0,		{ XK_Prior }},
  { 121, 0,		{ XK_Insert,	XK_Insert,
			XK_KP_0 }},
  { 122, 0,		{ XK_Delete,	XK_Delete,
			XK_KP_Decimal }},
  { 123, 0,		{ XK_Down,	XK_F34,
			XK_KP_2 }},
  { 124, 0,		{ XK_F31,	XK_F31,
			XK_KP_5 }},
  { 125, 0,		{ XK_Right,	XK_F32,
			XK_KP_6 }},
  { 126, 0,		{ XK_Up,	XK_F28,
			XK_KP_8 }},
  { 127, Mod3Mask,	{ XK_Num_Lock }},
  { 128, 0,		{ XK_F25,	XK_F25,
			XK_KP_Divide }},
  { 130, 0,		{ XK_KP_Enter }},
  { 131, 0,		{ XK_F35,	XK_F35,
			XK_KP_3,	XK_Next }},
  { 133, 0,		{ XK_KP_Add }},
  { 134, 0,		{ XK_F29,	XK_F29,
			XK_KP_9,	XK_Prior }},
  { 135, 0,		{ XK_F26,	XK_F26,
			XK_KP_Multiply }},
  { 141, 0,		{ XK_F24,	XK_F24,
			XK_KP_Subtract }},
  };
