/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the XMPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * XMPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: xmpi_about.cc,v 1.3 2003/09/03 04:28:53 jsquyres Exp $
 *
 *	Function:	- about XMPI
 */

#include <Xm/MessageB.h>

#include "xmpi.h"
#include "xmpi_about.h"

/*
 * private functions
 */
static void ok_cb(Widget);

/*
 * external functions
 */
extern Widget xmpi_wmshell();

/*
 * private data
 */
static char copyright[] =
"\nCopyright (C) 1999, University of Notre Dame\n";

static char promotion[] =
"\nFor more information see <http://www.mpi.nd.edu/lam/software/xmpi/>";

/*
 *	xmpi_about
 *
 *	Function:	- display about XMPI information
 *	Accepts:	- parent widget
 */
void
xmpi_about(Widget parent)
{
  Widget dialog;

  XmString xstr;

  char buf[1024];

  char *version;

  strcpy(buf, "Version: XMPI " XMPI_VERSION);

  version = xmpi_sys_version();
  if (version) {
    strcat(buf, " / ");
    strcat(buf, version);
  }
  strcat(buf, "\n");
  strcat(buf, copyright);
  strcat(buf, promotion);

  dialog = XmCreateInformationDialog(parent, (char*) "message", NULL, 0);

  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));

  xstr = XmStringCreateLtoR(buf, XmSTRING_DEFAULT_CHARSET);
  XtVaSetValues(dialog, XmNmessageString, xstr, NULL);
  XmStringFree(xstr);

  XtAddCallback(dialog, XmNokCallback, (XtCallbackProc) ok_cb, NULL);

  XtManageChild(dialog);
}

/*
 *	ok_cb
 *
 *	Function:	- about dialog OK callback
 *	Accepts:	- dialog widget
 */
static void
ok_cb(Widget dialog)
{
  XtDestroyWidget(dialog);
}
