//-----------------------------------------------------------------------------
//  Copyright (C) 2002-2010 Thomas S. Ullrich 
//
//  This file is part of "xyscan".
//
//  This file may be used under the terms of the GNU General Public License.
//  This project is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License.
//  
//  Author: Thomas S. Ullrich
//  Last update: November 19, 2010
//-----------------------------------------------------------------------------
#include <QtGui>
#include <iostream>
#include "xyscanWindow.h"
#include "xyscanVersion.h"

using namespace std; 

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    Q_INIT_RESOURCE(xyscan);
    app.setApplicationVersion(VERSION);

    //
    //  Set language and prepare translator
    //
    QLocale locale = QLocale::system();  
    QTranslator translator;
    QTranslator xyscanTranslator;
        
    if (locale.language() == QLocale::French) {
        QString path = qApp->applicationDirPath();
#if defined(Q_OS_MAC)   
        path += "/../Resources/";
#endif        
        bool rc = translator.load("qt_fr", QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        if (!rc) 
            cerr << "xdvmp (main): Warning, failed to load french translation (qt_fr)." << endl;
        rc = xyscanTranslator.load("xyscan_fr",path);
        if (!rc) 
            cerr << "xdvmp (main): Warning, failed to load french translation (xyscan_fr)." << endl;
        app.installTranslator(&translator);
        app.installTranslator(&xyscanTranslator);
    }
    
    //
    //  Create and launch xyscan
    //
    xyscanWindow win;
    win.show();
    return app.exec();
}


