package ONVIF::Analytics::Types::MetadataAttributes;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS = 'ONVIF::Analytics::Types::MetadataAttributes::_MetadataAttributes::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %CanContainPTZ_of :ATTR(:get<CanContainPTZ>);
my %CanContainAnalytics_of :ATTR(:get<CanContainAnalytics>);
my %CanContainNotifications_of :ATTR(:get<CanContainNotifications>);

__PACKAGE__->_factory(
    [ qw(        CanContainPTZ
        CanContainAnalytics
        CanContainNotifications

    ) ],
    {
        'CanContainPTZ' => \%CanContainPTZ_of,
        'CanContainAnalytics' => \%CanContainAnalytics_of,
        'CanContainNotifications' => \%CanContainNotifications_of,
    },
    {
        'CanContainPTZ' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'CanContainAnalytics' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'CanContainNotifications' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'CanContainPTZ' => 'CanContainPTZ',
        'CanContainAnalytics' => 'CanContainAnalytics',
        'CanContainNotifications' => 'CanContainNotifications',
    }
);

} # end BLOCK




package ONVIF::Analytics::Types::MetadataAttributes::_MetadataAttributes::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %PtzSpaces_of :ATTR(:get<PtzSpaces>);

__PACKAGE__->_factory(
    [ qw(
        PtzSpaces
    ) ],
    {

        PtzSpaces => \%PtzSpaces_of,
    },
    {
        PtzSpaces => 'ONVIF::Analytics::Types::StringAttrList',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

ONVIF::Analytics::Types::MetadataAttributes

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
MetadataAttributes from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * CanContainPTZ


=item * CanContainAnalytics


=item * CanContainNotifications




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::MetadataAttributes
   CanContainPTZ =>  $some_value, # boolean
   CanContainAnalytics =>  $some_value, # boolean
   CanContainNotifications =>  $some_value, # boolean
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ONVIF::Analytics::Types::MetadataAttributes::_MetadataAttributes::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * PtzSpaces

 List of all PTZ spaces active for recording. Note that events are only recorded on position changes and the actual point of recording may not necessarily contain an event of the specified type. 



This attribute is of type L<ONVIF::Analytics::Types::StringAttrList|ONVIF::Analytics::Types::StringAttrList>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

